/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import weblogic.management.tools.AttributeInfo;

public final class MBeanReflector {
    private final Set attributes = new TreeSet();
    private final Set operations = new TreeSet();
    private final Class subject;

    public MBeanReflector(Class clazz) {
        this.subject = clazz;
        this.initialize(this.subject);
    }

    public MBeanReflector(String string) {
        try {
            this.subject = AttributeInfo.Helper.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.initialize(this.subject);
    }

    public Class getSubject() {
        return this.subject;
    }

    public Operation[] getOperations() {
        Operation[] operationArray = new Operation[this.operations.size()];
        return this.operations.toArray(operationArray);
    }

    public Attribute[] getAttributes() {
        Attribute[] attributeArray = new Attribute[this.attributes.size()];
        return this.attributes.toArray(attributeArray);
    }

    public Method getAttributeGetMethod(Attribute attribute) {
        Class[] classArray = new Class[]{};
        Method method = this.getMethod("get" + attribute.getName(), classArray);
        if (method != null) {
            return method;
        }
        return this.getMethod("is" + attribute.getName(), classArray);
    }

    public Method getAttributeSetMethod(Attribute attribute) {
        Class[] classArray = new Class[]{attribute.getType()};
        return this.getMethod("set" + attribute.getName(), classArray);
    }

    public Method getAttributeAddMethod(Attribute attribute) {
        Class[] classArray = new Class[]{attribute.getType().getComponentType()};
        return this.getMethod("add" + attribute.getSingularName(), classArray);
    }

    public Method getAttributeRemoveMethod(Attribute attribute) {
        Class[] classArray = new Class[]{attribute.getType().getComponentType()};
        return this.getMethod("remove" + attribute.getSingularName(), classArray);
    }

    private Method getMethod(String string, Class[] classArray) {
        try {
            return this.subject.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private void initialize(Class clazz) {
        Attribute attribute;
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getName().startsWith("set")) {
                arrayList.add(method);
                continue;
            }
            attribute = Attribute.attributeFromMethod(method);
            if (attribute != null) {
                this.attributes.add(attribute);
                continue;
            }
            this.operations.add(new Operation(method));
        }
        for (Method method : arrayList) {
            attribute = Attribute.attributeFromMethod(method);
            if (attribute != null && this.attributes.contains(attribute)) continue;
            Operation operation = new Operation(method);
            this.operations.add(operation);
        }
    }

    public static final class Operation
    implements Comparable {
        private final Method method;

        Operation(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.method.getName().hashCode();
        }

        public boolean equals(Object object) {
            Class<?>[] classArray;
            if (object == this) {
                return true;
            }
            if (!(object instanceof Operation)) {
                return false;
            }
            Operation operation = (Operation)object;
            if (operation.method == this.method) {
                return true;
            }
            if (!operation.method.getName().equals(this.method.getName())) {
                return false;
            }
            Class<?>[] classArray2 = this.method.getParameterTypes();
            if (classArray2.length != (classArray = operation.method.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i] == classArray[i]) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object object) {
            Operation operation = (Operation)object;
            if (this.equals(operation)) {
                return 0;
            }
            int n = operation.method.getName().compareTo(this.method.getName());
            if (n != 0) {
                return n;
            }
            return System.identityHashCode(operation) - System.identityHashCode(this);
        }
    }

    public static final class Attribute
    implements Comparable {
        private final String name;
        private final Class type;

        Attribute(String string, Class clazz) {
            this.name = string;
            this.type = clazz;
        }

        private static Attribute attributeFromMethod(Method method) {
            String string = method.getName();
            if (string.startsWith("get") && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
                return new Attribute(string.substring(3), method.getReturnType());
            }
            if (string.startsWith("is") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 0) {
                return new Attribute(string.substring(2), Boolean.TYPE);
            }
            if (string.startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
                return new Attribute(string.substring(3), method.getParameterTypes()[0]);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public String getSingularName() {
            if (this.name.endsWith("ies")) {
                return this.name.substring(0, this.name.length() - 3) + 'y';
            }
            if (this.name.endsWith("s")) {
                return this.name.substring(0, this.name.length() - 1);
            }
            return this.name;
        }

        public String getFieldName() {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
            for (int i = 1; !(i >= stringBuffer.length() || Character.isLowerCase(stringBuffer.charAt(i)) || i + 1 < stringBuffer.length() && Character.isLowerCase(stringBuffer.charAt(i + 1))); ++i) {
                stringBuffer.setCharAt(i, Character.toLowerCase(stringBuffer.charAt(i)));
            }
            return stringBuffer.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            return attribute.type == this.type && attribute.name.equals(this.name);
        }

        public int compareTo(Object object) {
            Attribute attribute = (Attribute)object;
            if (this.equals(attribute)) {
                return 0;
            }
            int n = this.name.compareTo(attribute.name);
            if (n != 0) {
                return n;
            }
            return System.identityHashCode(attribute) - System.identityHashCode(this);
        }
    }
}

