/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.lang.reflect.Method;
import java.util.Locale;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import weblogic.management.info.ExtendedOperationInfo;
import weblogic.management.tools.AttributeInfo;
import weblogic.utils.reflect.UniqueMethod;

class OperationInfo
extends MBeanOperationInfo
implements ExtendedOperationInfo {
    private static final long serialVersionUID = 6938333905828247476L;
    String methodClassName = null;
    private String parameterString = "";
    private String parameterNames = "";
    private String exceptionString = "";
    private String[] legalChecks = null;
    private String[] legalResponses = null;
    private transient Method method = null;
    private boolean dynamic = false;

    public OperationInfo(String string, Method method, boolean bl, String[] stringArray, String[] stringArray2) {
        super(string, method);
        this.dynamic = bl;
        this.method = method;
        this.methodClassName = method.getDeclaringClass().getName();
        this.legalChecks = stringArray;
        this.legalResponses = stringArray2;
        this.initialize();
    }

    private static String getType(String string) {
        if (string.startsWith("[L")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setLength(stringBuffer.length() + 1);
            stringBuffer.setCharAt(stringBuffer.length() - 2, '[');
            stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
            stringBuffer = stringBuffer.reverse();
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer = stringBuffer.reverse();
            return stringBuffer.toString();
        }
        return string;
    }

    private static String getParamName(String string, int n) {
        int n2;
        if (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((n2 = string.lastIndexOf(46)) > -1) {
            string = string.substring(n2 + 1, string.length());
        }
        string = string.substring(0, 1).toLowerCase(Locale.US) + string.substring(1, string.length());
        return "_wl_" + string + "_" + n;
    }

    public Method getMethod() {
        if (this.method != null) {
            return this.method;
        }
        try {
            Class<?> clazz = Class.forName(this.methodClassName);
            MBeanParameterInfo[] mBeanParameterInfoArray = this.getSignature();
            Class[] classArray = new Class[mBeanParameterInfoArray.length];
            for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
                classArray[i] = AttributeInfo.Helper.findClass(mBeanParameterInfoArray[i].getType());
            }
            this.method = UniqueMethod.intern((Method)clazz.getMethod(this.name, classArray));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new RuntimeException("error deserializing OperationInfo " + this.name);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("error deserializing OperationInfo " + this.name);
        }
        return this.method;
    }

    public String getParameterString() {
        return this.parameterString;
    }

    public String getParameterNames() {
        return this.parameterNames;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    public String getReturnType() {
        return OperationInfo.getType(this.getMethod().getReturnType().getName());
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String getLegalCheck() {
        if (this.legalChecks != null && this.legalChecks.length > 0) {
            return this.legalChecks[0];
        }
        return null;
    }

    public String[] getLegalChecks() {
        return this.legalChecks;
    }

    public String[] getLegalResponses() {
        return this.legalResponses;
    }

    public String getLegalResponse() {
        if (this.legalResponses != null && this.legalResponses.length > 0) {
            return this.legalResponses[0];
        }
        return null;
    }

    public String toString() {
        String string = super.toString();
        string = string + ", dynamic=" + this.dynamic;
        return string;
    }

    private void initialize() {
        Class<?>[] classArray = this.getMethod().getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            String string = OperationInfo.getType(classArray[i].getName());
            String string2 = "value";
            if (classArray.length > 1) {
                string2 = OperationInfo.getParamName(string, i);
            }
            if (this.parameterString.length() > 0) {
                this.parameterString = this.parameterString + ", ";
            }
            this.parameterString = this.parameterString + string + " " + string2;
            this.parameterNames = this.parameterNames + string2;
            if (i >= classArray.length - 1) continue;
            this.parameterNames = this.parameterNames + ", ";
        }
        Class<?>[] classArray2 = this.getMethod().getExceptionTypes();
        for (int i = 0; i < classArray2.length; ++i) {
            this.exceptionString = this.exceptionString.length() > 0 ? this.exceptionString + "," : "\n    throws ";
            this.exceptionString = this.exceptionString + classArray2[i].getName();
        }
    }
}

