/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import weblogic.management.tools.DefaultValue;
import weblogic.management.tools.FileString;
import weblogic.management.tools.TaggedMethod;
import weblogic.utils.Debug;
import weblogic.utils.compiler.CodeGenerationException;

public class TagParser {
    private List m_listener = new ArrayList();
    private String m_fileName;
    private List m_classTags = new ArrayList();
    private List m_taggedMethods = new ArrayList();
    private HashMap m_defaultValues = new HashMap();

    public TagParser(String string) {
        this.m_fileName = string;
    }

    public static void main(String[] stringArray) {
        try {
            TaggedMethod[] taggedMethodArray;
            TagParser tagParser = new TagParser(stringArray[0]);
            tagParser.parse();
            TagParser.p("============= " + stringArray[0]);
            TagParser.p("CLASSTAGS:");
            Iterator iterator = tagParser.getClassTags();
            while (iterator.hasNext()) {
                TagParser.p("   " + iterator.next().toString());
            }
            TagParser.p("");
            TagParser.p("METHOD TAGS:");
            iterator = tagParser.getTaggedMethods();
            while (iterator.hasNext()) {
                taggedMethodArray = (TaggedMethod[])iterator.next();
                TagParser.p("   METHOD:" + taggedMethodArray.getMethodName());
                String[] stringArray2 = taggedMethodArray.getTags();
                for (int i = 0; i < stringArray2.length; ++i) {
                    TagParser.p("      " + stringArray2[i]);
                }
            }
            TagParser.p("");
            TagParser.p("METHODS WITH A DEFAULT TAG:");
            taggedMethodArray = tagParser.getMethodsWithTag("@default");
            for (int i = 0; i < taggedMethodArray.length; ++i) {
                TagParser.p("   " + taggedMethodArray[i].getMethodName());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void p(String string) {
        Debug.say((String)("@@@ " + string));
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getCurrentClassName() {
        int n = this.m_fileName.lastIndexOf("/") + 1;
        if (n <= 0) {
            n = this.m_fileName.lastIndexOf("\\") + 1;
        }
        if (n <= 0) {
            n = 0;
        }
        int n2 = this.m_fileName.indexOf(".java");
        return this.m_fileName.substring(n, n2);
    }

    public DefaultValue getDefaultValue(String string) {
        Debug.assertion((0 == string.indexOf("get") || 0 == string.indexOf("is") ? 1 : 0) != 0, (String)("Illegal getDefaultValue for non-getter:" + string + " file:" + this.m_fileName));
        return (DefaultValue)this.m_defaultValues.get(string);
    }

    public TaggedMethod[] getMethodsWithTag(String string) {
        Object[] objectArray;
        Object[] objectArray22;
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        if (-1 == string.indexOf("@")) {
            string = "@" + string;
        }
        for (Object[] objectArray22 : this.m_taggedMethods) {
            objectArray = objectArray22.getTags();
            for (int i = 0; i < objectArray.length; ++i) {
                if (-1 == ((String)objectArray[i]).indexOf(string) || null != hashMap.get(objectArray22.getMethodSignature())) continue;
                hashMap.put(objectArray22.getMethodSignature(), objectArray22);
            }
        }
        objectArray22 = hashMap.values().toArray();
        objectArray = new TaggedMethod[objectArray22.length];
        System.arraycopy(objectArray22, 0, objectArray, 0, objectArray22.length);
        return objectArray;
    }

    public Iterator getTaggedMethods() {
        return this.m_taggedMethods.iterator();
    }

    public Iterator getClassTags() {
        return this.m_classTags.iterator();
    }

    public void parse() throws IOException {
        FileString fileString = new FileString(this.m_fileName);
        this.parseClassTags(fileString);
        this.parseMethodTags(fileString);
        this.initDefaultValues();
        String[] stringArray = this.getSuperClassFileNames(this.m_fileName);
        for (int i = 0; i < stringArray.length; ++i) {
            fileString = new FileString(stringArray[i]);
            String string = fileString.readAndAdvance();
            while (-1 == string.indexOf("{")) {
                string = fileString.readAndAdvance();
            }
            this.parseMethodTags(fileString);
        }
        if (!this.isAbstractClass()) {
            this.validateMethodTags();
        }
    }

    public String locateFileFromPackage(String string) {
        String string2 = null;
        String string3 = string.replace('.', File.separatorChar) + ".java";
        File file = new File(string3);
        if (file.exists()) {
            string2 = string3;
        }
        return string2;
    }

    private String[] getSuperClassFileNames(String string) throws FileNotFoundException, IOException {
        Object object;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        FileString fileString = new FileString(string);
        String string2 = fileString.getSuperClassName();
        while (null != string2 && -1 != string2.indexOf("MBean") && -1 == string2.indexOf("WeblogicMBean")) {
            stringArray = fileString.getImportClass(string2);
            object = fileString.getPackageName();
            String string3 = null;
            if (null != stringArray) {
                string3 = this.locateFileFromPackage((String)stringArray);
            } else {
                string3 = this.locateFileFromPackage((String)object + "." + string2);
                if (null == string3) {
                    string3 = this.locateFileFromPackage(string2);
                }
            }
            if (null != string3) {
                arrayList.add(string3);
                fileString = new FileString(string3);
                string2 = fileString.getSuperClassName();
                continue;
            }
            string2 = null;
        }
        stringArray = new String[arrayList.size()];
        object = arrayList.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)object.next();
        }
        return stringArray;
    }

    private boolean isNewMethod(List list, TaggedMethod taggedMethod) {
        for (TaggedMethod taggedMethod2 : list) {
            if (!taggedMethod2.getMethodName().equals(taggedMethod.getMethodName())) continue;
            return false;
        }
        return true;
    }

    private boolean isAbstractClass() {
        for (String string : this.m_classTags) {
            if (!"@abstract".equals(string)) continue;
            return true;
        }
        return false;
    }

    private void parseMethodTags(FileString fileString) throws IOException {
        String string = fileString.readAndAdvance();
        int n = -1;
        while (!fileString.eof()) {
            while (!fileString.eof() && -1 == string.indexOf("(") && -1 == string.indexOf("/**")) {
                string = fileString.readAndAdvance();
            }
            if (!fileString.eof() && string.indexOf("/**") > 0) {
                n = fileString.getCurrentIndex();
            } else if (!fileString.eof() && string.indexOf("(") > 0 && string.indexOf("*") == -1 && -1 != n) {
                Object object;
                List list = this.parseTags(fileString, n, fileString.getCurrentIndex());
                String string2 = string;
                Iterator iterator = list.iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    object = iterator.next().toString();
                    arrayList.add((String)object);
                }
                object = new TaggedMethod(string2, arrayList);
                this.m_taggedMethods.add(object);
                n = -1;
            }
            if (fileString.eof()) continue;
            string = fileString.readAndAdvance();
        }
    }

    private void parseClassTags(FileString fileString) throws IOException {
        while (-1 == fileString.readCurrent().indexOf("interface") && -1 == fileString.readCurrent().indexOf("/**")) {
            fileString.advance();
        }
        if (-1 != fileString.readCurrent().indexOf("/**")) {
            this.m_classTags = this.parseTags(fileString);
            fileString.advance();
        }
    }

    private List parseTags(FileString fileString, int n, int n2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n; i < n2; ++i) {
            String string = fileString.readLine(i);
            int n3 = string.indexOf("@");
            if (n3 == -1) continue;
            arrayList.add(string.substring(n3));
        }
        return arrayList;
    }

    private List parseTags(FileString fileString) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = fileString.readAndAdvance();
        while (!fileString.eof() && -1 == string.indexOf("*/")) {
            int n = string.indexOf("@");
            if (n != -1) {
                arrayList.add(string.substring(n));
            }
            string = fileString.readAndAdvance();
        }
        return arrayList;
    }

    private void initDefaultValues() {
        try {
            TaggedMethod[] taggedMethodArray = this.getMethodsWithTag("@default");
            for (int i = 0; i < taggedMethodArray.length; ++i) {
                String string = taggedMethodArray[i].getTagValue("@default");
                String string2 = taggedMethodArray[i].getReturnType();
                String string3 = taggedMethodArray[i].getMethodName();
                DefaultValue defaultValue = null;
                if ("String".equals(string2) || "java.lang.String".equals(string2)) {
                    defaultValue = new DefaultValue(string, false);
                } else if ("boolean".equals(string2)) {
                    defaultValue = new DefaultValue(Boolean.valueOf(string).toString(), true);
                } else if ("int".equals(string2) || "Integer".equals(string2) || "java.lang.Integer".equals(string2)) {
                    try {
                        defaultValue = new DefaultValue(Integer.valueOf(string).toString(), true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CodeGenerationException("Error parsing int for " + taggedMethodArray[i].getMethodName());
                    }
                } else {
                    throw new CodeGenerationException("Can't set default value for " + taggedMethodArray[i].getMethodName() + ". Its type isn't supported");
                }
                this.m_defaultValues.put(string3, defaultValue);
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            codeGenerationException.printStackTrace();
        }
    }

    private void validateMethodTags() {
        int n;
        TaggedMethod[] taggedMethodArray = this.getMethodsWithTag("@dtd-order");
        TaggedMethod[] taggedMethodArray2 = new TaggedMethod[taggedMethodArray.length];
        int n2 = 0;
        for (n = 0; n < taggedMethodArray.length; ++n) {
            String string = taggedMethodArray[n].getTagValue("@dtd-order");
            int n3 = string.length();
            int n4 = string.indexOf("|");
            int n5 = string.indexOf("?");
            if (n4 != -1 && n5 != -1 && n4 > n5) {
                throw new RuntimeException(this.m_fileName + ": Error with dtd-order tag for method" + taggedMethodArray[n].getMethodName() + " tag:" + string + ". The | must always come before the ?");
            }
            if (n4 != -1) {
                n3 = n4;
            } else if (n5 != -1) {
                n3 = n5;
            }
            Debug.assertion((-1 != n3 ? 1 : 0) != 0, (String)(taggedMethodArray[n].getMethodName() + " tag:" + string));
            int n6 = new Integer(string.substring(0, n3));
            if (n6 > taggedMethodArray.length - 1) {
                throw new RuntimeException(this.m_fileName + ": The dtd-order for method " + taggedMethodArray[n].getMethodSignature() + " is too high.  Make sure the dtd-order in this interface is correct");
            }
            if (taggedMethodArray2[n] != null) {
                if (n4 == -1 || taggedMethodArray2[n].getTagValue("@dtd-order").indexOf("|") == -1) {
                    throw new RuntimeException(this.m_fileName + ": The dtd-order for method " + taggedMethodArray[n].getMethodSignature() + " is incorrect.  The method " + taggedMethodArray2[n].getMethodSignature() + "is also declared with a dtd-order of " + n6 + ".  You must fix the ordering of these methods or declare them with the '|' (or) tag.");
                }
                ++n2;
                continue;
            }
            taggedMethodArray2[n] = taggedMethodArray[n];
        }
        n = 0;
        for (int i = 0; i < taggedMethodArray2.length; ++i) {
            if (taggedMethodArray2[i] != null) continue;
            ++n;
        }
        if (n != n2) {
            throw new RuntimeException(this.m_fileName + ": The dtd-order values for some methods in this class are incorrect.");
        }
    }
}

