/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import weblogic.management.tools.ToXML;

public class TaggedMethod {
    public String[] m_tags;
    public String m_methodSignature;
    public String m_methodName;
    public String m_returnType;

    public TaggedMethod(String string, List list) {
        this.m_methodSignature = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.m_returnType = stringTokenizer.nextToken();
        if ("public".equals(this.m_returnType) || "private".equals(this.m_returnType) || "protected".equals(this.m_returnType)) {
            this.m_returnType = stringTokenizer.nextToken();
        }
        this.m_methodName = stringTokenizer.nextToken();
        this.m_tags = new String[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < this.m_tags.length; ++i) {
            this.m_tags[i] = iterator.next().toString();
        }
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String getMethodSignature() {
        return this.m_methodSignature;
    }

    public String getFieldName() {
        String string = this.trimAction();
        return ToXML.toElementName(string);
    }

    public String getGetMethodName() {
        String string = this.trimAction();
        return this.getGetPrefix() + string;
    }

    public String[] getTags() {
        return this.m_tags;
    }

    public String getTagValue(String string) {
        for (int i = 0; i < this.m_tags.length; ++i) {
            if (-1 == this.m_tags[i].indexOf(string)) continue;
            return this.m_tags[i].substring(1 + string.length());
        }
        return null;
    }

    public boolean containsTag(String string) {
        for (int i = 0; i < this.m_tags.length; ++i) {
            if (this.m_tags[i].indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[TaggedMethod:" + this.getMethodSignature() + "]";
    }

    String getGetPrefix() {
        if (this.m_methodName.startsWith("is")) {
            return "is";
        }
        return "get";
    }

    private String trimAction() {
        String string = this.m_methodName;
        if (this.m_methodName.startsWith("get")) {
            string = this.m_methodName.substring(3);
        } else if (this.m_methodName.startsWith("set")) {
            string = this.m_methodName.substring(3);
        } else if (this.m_methodName.startsWith("is")) {
            string = this.m_methodName.substring(2);
        } else if (this.m_methodName.startsWith("add")) {
            string = this.m_methodName.substring(3);
        } else if (this.m_methodName.startsWith("remove")) {
            string = this.m_methodName.substring(6);
        }
        string = string.substring(0, string.length() - 3);
        return string;
    }
}

