/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import weblogic.management.tools.DTDMethod;
import weblogic.management.tools.DefaultValue;
import weblogic.management.tools.TagParser;
import weblogic.management.tools.TaggedMethod;
import weblogic.utils.Debug;

public class ToXML {
    public static final String TAG_DTD_ORDER = "@dtd-order";
    public static final String TAG_EMPTY = "@empty";
    public static final String TAG_CDATA = "@cdata";
    public static final String TAG_ATTRIBUTE = "@attribute";
    public static final String TAG_NAME = "@name";
    private static final int TAG_NONE = 0;
    private static final int TAG_OR = 1;
    private static final int TAG_OPTIONAL = 2;
    private static final int TAG_MANDATORY = 3;
    private static final String sp1 = "  ";
    private static final String sp2 = "    ";
    private static TagParser m_parser;
    private static boolean verbose;
    private static StringBuffer[] m_indent;

    public static String toXML(TagParser tagParser) {
        Iterator iterator;
        Object object;
        Iterator iterator2;
        Object object2;
        int n;
        m_parser = tagParser;
        StringBuffer stringBuffer = new StringBuffer("  public String toXML(int indentLevel) {");
        stringBuffer.append("\n");
        stringBuffer.append("    StringBuffer result = new StringBuffer();");
        stringBuffer.append("\n");
        TaggedMethod[] taggedMethodArray = m_parser.getMethodsWithTag(TAG_DTD_ORDER);
        DTDMethod dTDMethod = new DTDMethod(m_parser.getCurrentClassName());
        stringBuffer.append("    result.append(ToXML.indent(indentLevel)).append(\"").append("<" + dTDMethod.toElementName() + "\");\n");
        TaggedMethod[] taggedMethodArray2 = m_parser.getMethodsWithTag(TAG_ATTRIBUTE);
        for (n = 0; n < taggedMethodArray2.length; ++n) {
            object2 = new StringBuffer();
            iterator2 = taggedMethodArray2[n].getTagValue(TAG_NAME);
            if (iterator2 == null) {
                iterator2 = taggedMethodArray2[n].getFieldName();
            }
            object = taggedMethodArray2[n].getGetMethodName();
            String string = taggedMethodArray2[n].getGetPrefix();
            ((StringBuffer)object2).append("    if (isSet_" + DTDMethod.getFieldName(((String)object).substring(string.length())) + ") {\n");
            object = (String)object + "()";
            iterator = taggedMethodArray2[n].getReturnType();
            if (((String)((Object)iterator)).indexOf("XMLName") != -1) {
                ((StringBuffer)object2).append("      result.append(\" xmlns:\").append(" + (String)object + ".getPrefix()).append(\"=\\\"\").append(" + (String)object + ".getNamespaceUri()).append(\"\\\" ");
                ((StringBuffer)object2).append((String)((Object)iterator2)).append("=\\\"\").append(" + (String)object + ".getQualifiedName()).append(\"\\\"\");\n");
            } else {
                ((StringBuffer)object2).append("      result.append(\" ").append((String)((Object)iterator2)).append("=\\\"\").append(String.valueOf(" + (String)object + ")).append(\"\\\"\");\n");
            }
            ((StringBuffer)object2).append("    }\n");
            stringBuffer.append((StringBuffer)object2);
        }
        stringBuffer.append("    result.append(\">\\n\");\n");
        for (n = 0; n < taggedMethodArray.length; ++n) {
            object2 = ToXML.getMethodsWithDTDOrder(taggedMethodArray, n);
            iterator2 = object2.iterator();
            if (iterator2.hasNext()) {
                object = (DTDMethod)iterator2.next();
                int n2 = ((DTDMethod)object).getDTDOrder();
                if (((DTDMethod)object).isMandatory()) {
                    iterator = object2.iterator();
                    DTDMethod dTDMethod2 = (DTDMethod)iterator.next();
                    if (dTDMethod2.isBoolean()) {
                        stringBuffer.append(dTDMethod2.toXML());
                        continue;
                    }
                    stringBuffer.append(dTDMethod2.toXMLIfNotNull("     "));
                    continue;
                }
                if (((DTDMethod)object).isOptional()) {
                    Debug.assertion((object2.size() > 0 ? 1 : 0) != 0, (String)("Not enough @dtd-order " + ((DTDMethod)object).getDTDOrder() + " tags in " + tagParser.getFileName()));
                    iterator = object2.iterator();
                    DTDMethod dTDMethod3 = (DTDMethod)iterator.next();
                    stringBuffer.append(dTDMethod3.toXMLIfNotNullAndNotDefault("     "));
                    continue;
                }
                Debug.assertion((object2.size() > 0 ? 1 : 0) != 0, (String)("Not enough @dtd-order " + ((DTDMethod)object).getDTDOrder() + " tags in " + tagParser.getFileName()));
                iterator = object2.iterator();
                int n3 = 0;
                DTDMethod dTDMethod4 = null;
                while (iterator.hasNext()) {
                    DTDMethod dTDMethod5 = (DTDMethod)iterator.next();
                    if (0 != n3++ && !dTDMethod4.isArray()) {
                        stringBuffer.append("    else /*@*/ ");
                    }
                    stringBuffer.append(dTDMethod5.toXMLForOr(sp1));
                    dTDMethod4 = dTDMethod5;
                }
                continue;
            }
            if (!verbose) continue;
            System.out.println("Warning:" + tagParser.getFileName() + ":  couldn't find a method with @dtd-order " + n);
        }
        stringBuffer.append("    result.append(ToXML.indent(indentLevel)).append(\"").append("</" + dTDMethod.toElementName() + ">\\n\");\n");
        stringBuffer.append("    return result.toString();\n");
        stringBuffer.append("  }\n");
        return stringBuffer.toString();
    }

    public static StringBuffer indent(int n) {
        if (n < m_indent.length * 2) {
            return m_indent[n / 2];
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n / 2; ++i) {
            stringBuffer.append(sp1);
        }
        return stringBuffer;
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"public void getSmallIconFileName()", "get-small-icon-file-name", "public void EJBJar()", "ejb-jar", "public void EJBQl()", "ejb-ql", "public void EJBJarMBean()", "ejb-jar", "public void providerURL()", "provider-url"};
        for (int i = 0; i < stringArray2.length; i += 2) {
            DTDMethod dTDMethod = new DTDMethod(null, stringArray2[i], "", null);
            Debug.assertion((boolean)dTDMethod.toElementName().equals(stringArray2[i + 1]), (String)(dTDMethod.toElementName() + " != " + stringArray2[i + 1]));
            Debug.say((String)dTDMethod.toElementName());
        }
    }

    public static String toElementName(String string) {
        return DTDMethod.toElementName(string);
    }

    private static Collection getMethodsWithDTDOrder(TaggedMethod[] taggedMethodArray, int n) {
        ArrayList<DTDMethod> arrayList = new ArrayList<DTDMethod>();
        for (int i = 0; i < taggedMethodArray.length; ++i) {
            TaggedMethod taggedMethod = taggedMethodArray[i];
            String string = taggedMethod.getTagValue(TAG_DTD_ORDER);
            DefaultValue defaultValue = m_parser.getDefaultValue(taggedMethod.getMethodName());
            DTDMethod dTDMethod = new DTDMethod(taggedMethodArray[i], taggedMethod.getMethodSignature(), string, defaultValue);
            if (n != dTDMethod.getDTDOrder()) continue;
            arrayList.add(dTDMethod);
        }
        return arrayList;
    }

    static {
        verbose = false;
        m_indent = new StringBuffer[]{new StringBuffer(""), new StringBuffer(sp1), new StringBuffer(sp2), new StringBuffer("      "), new StringBuffer("        "), new StringBuffer("          ")};
    }
}

