/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import weblogic.management.WebLogicMBean;
import weblogic.management.tools.AttributeInfo;
import weblogic.management.tools.MBeanReflector;
import weblogic.management.tools.TagParser;
import weblogic.management.tools.TaggedMethod;
import weblogic.management.tools.ToXML;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public class XMLElementMBeanImplGenerator
extends CodeGenerator {
    private static final String VERBOSE = "verbose";
    private static final String PACKAGE = "package";
    private boolean verbose;
    private Output m_currentOutput;
    private Method method;
    private MBeanReflector.Attribute attribute;
    private MBeanReflector m_reflector;
    private Set attributeSet;
    private String attributeName;
    private String attributeFieldName;
    private TagParser m_currentTagParser;

    public XMLElementMBeanImplGenerator(Getopt2 getopt2) {
        super(getopt2);
        getopt2.addFlag(VERBOSE, "Verbose output.");
        getopt2.setUsageArgs("[directory|file]");
    }

    public static String genDefaultValue(TagParser tagParser, Method method, Output output) throws CodeGenerationException {
        TaggedMethod[] taggedMethodArray = tagParser.getMethodsWithTag("@default");
        Class<Object> clazz = method.getReturnType();
        for (int i = 0; i < taggedMethodArray.length; ++i) {
            if (-1 == taggedMethodArray[i].getMethodSignature().indexOf(method.getName())) continue;
            String string = taggedMethodArray[i].getTagValue("@default");
            if (clazz.isAssignableFrom(String.class)) {
                return " = " + string;
            }
            if (clazz.isAssignableFrom(Boolean.TYPE)) {
                return " = " + Boolean.valueOf(string);
            }
            if (clazz.isAssignableFrom(Integer.TYPE)) {
                try {
                    return " = " + Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CodeGenerationException("Error parsing int for " + method + " of the " + output.getClassName() + " interface.", (Throwable)numberFormatException);
                }
            }
            throw new CodeGenerationException("Can't set default value for " + method + ". Its type isn't supported");
        }
        return "";
    }

    public String getterMethodName() {
        return "get" + this.attribute.getName();
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        try {
            Hashtable<Output, Output> hashtable = new Hashtable<Output, Output>();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < objectArray.length; ++i) {
                File file = new File((String)objectArray[i]);
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getPath());
                }
                if (file.isDirectory()) {
                    this.addSourceFilesFromDir(file, arrayList);
                    continue;
                }
                arrayList.add(file);
            }
            for (File file : arrayList) {
                String string = file.getPath().replace(File.separatorChar, '.');
                Class clazz = AttributeInfo.Helper.findClass(string = string.substring(0, string.length() - 5));
                if (Throwable.class.isAssignableFrom(clazz)) continue;
                int n = string.lastIndexOf(46);
                String string2 = n != -1 ? string.substring(0, n) : "";
                Output output = new Output(clazz, string2, file.getAbsolutePath());
                String string3 = output.getOutputFile().replace('/', File.separatorChar);
                File file2 = this.targetFile(string3, output.getPackage());
                this.verbose(file + " has changed, regenerating.");
                hashtable.put(output, output);
            }
            return hashtable.elements();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public String genAuthor() {
        return "@author";
    }

    public String genPackageDeclaration() {
        String string = this.m_currentOutput.getPackage();
        return string == null ? "" : "package " + string + ";";
    }

    public String genClassName() {
        return this.m_currentOutput.getClassName();
    }

    public String genInterfaceName() {
        return this.m_currentOutput.getInterface().getName();
    }

    public String genAttributes() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet hashSet = this.getAttributes();
        for (MBeanReflector.Attribute this.attribute : hashSet) {
            if (this.isAttributeArray()) {
                stringBuffer.append(this.parse(this.getProductionRule("attributeFieldArrayDeclaration")));
                continue;
            }
            stringBuffer.append(this.parse(this.getProductionRule("attributeFieldDeclaration")));
        }
        return stringBuffer.toString();
    }

    public String genAccessors() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet hashSet = this.getAttributes();
        for (MBeanReflector.Attribute this.attribute : hashSet) {
            this.method = this.m_reflector.getAttributeGetMethod(this.attribute);
            if (this.method != null) {
                if (this.isAttributeArray()) {
                    stringBuffer.append(this.parse(this.getProductionRule("arrayGetter")));
                } else if (this.isAttributeBoolean()) {
                    stringBuffer.append(this.parse(this.getProductionRule("isGetter")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("getter")));
                }
            }
            this.method = this.m_reflector.getAttributeSetMethod(this.attribute);
            if (this.method != null) {
                if (this.isAttributeArray()) {
                    stringBuffer.append(this.parse(this.getProductionRule("arraySetter")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("setter")));
                }
            }
            if (!this.isAttributeArray()) continue;
            try {
                this.method = this.m_reflector.getAttributeAddMethod(this.attribute);
            }
            catch (Exception exception) {
                throw new CodeGenerationException("Error getting add method", (Throwable)exception);
            }
            if (this.method != null) {
                stringBuffer.append(this.parse(this.getProductionRule("arrayAdder")));
            }
            try {
                this.method = this.m_reflector.getAttributeRemoveMethod(this.attribute);
            }
            catch (Exception exception) {
                throw new CodeGenerationException("Error getting remove method", (Throwable)exception);
            }
            if (this.method == null) continue;
            stringBuffer.append(this.parse(this.getProductionRule("arrayRemover")));
        }
        return stringBuffer.toString();
    }

    public String genChildrenRegistration() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet hashSet = this.getAttributes();
        for (MBeanReflector.Attribute this.attribute : hashSet) {
            if (!this.isAttributeMBean()) continue;
            if (this.isAttributeArray()) {
                stringBuffer.append(this.parse(this.getProductionRule("arrayRegister")));
                continue;
            }
            stringBuffer.append(this.parse(this.getProductionRule("childRegister")));
        }
        return stringBuffer.toString();
    }

    public String emptyStringCheck() {
        if (this.isAttributeString()) {
            return "if (value != null && value.trim().length() == 0) value = null;\n";
        }
        return "";
    }

    public String attributeIsSetExpression() {
        if (!this.isAttributePrimitive()) {
            return "(value != null)";
        }
        if (this.isAttributeBoolean()) {
            return "true";
        }
        return "(value != " + this.unsetNumberLiteral() + ")";
    }

    public String genOperations() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        MBeanReflector.Operation[] operationArray = this.m_reflector.getOperations();
        for (int i = 0; i < operationArray.length; ++i) {
            this.method = operationArray[i].getMethod();
            stringBuffer.append(this.parse(this.getProductionRule("operation")));
        }
        return stringBuffer.toString();
    }

    public String genAttributeName() {
        return this.attribute.getName();
    }

    public String genAttributeFieldName() {
        return this.attribute.getFieldName();
    }

    public String genAttributeFieldSetTesterName() {
        String string = this.genAttributeFieldName();
        return "isSet_" + this.genAttributeFieldName();
    }

    public String genDefaultValue() throws CodeGenerationException {
        Method method = this.m_reflector.getAttributeGetMethod(this.attribute);
        return XMLElementMBeanImplGenerator.genDefaultValue(this.m_currentTagParser, method, this.m_currentOutput);
    }

    public String genAttributeType() {
        return this.prettyPrintType(this.attribute.getType());
    }

    public String genAttributeTypeMinusArrayBrackets() {
        return this.attribute.getType().getComponentType().getName();
    }

    public String genMethodName() {
        return this.method.getName();
    }

    public String genReturnType() {
        return this.prettyPrintType(this.method.getReturnType());
    }

    public String genThrowsClause() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getExceptionTypes();
        if (classArray.length != 0) {
            stringBuffer.append("throws ");
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[i].getName());
            }
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        String string = null;
        try {
            string = ToXML.toXML(this.m_currentTagParser);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        this.verbose = getopt2.hasOption(VERBOSE);
    }

    protected void prepare(CodeGenerator.Output output) throws BadOutputException {
        this.m_currentOutput = (Output)output;
        Output output2 = (Output)output;
        this.m_currentTagParser = new TagParser(output2.getAbsolutePath());
        try {
            this.m_currentTagParser.parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_reflector = new MBeanReflector(this.m_currentOutput.getInterface());
    }

    private boolean isAttributeString() {
        return this.attribute.getType().getName().equals("java.lang.String");
    }

    private boolean isAttributePrimitive() {
        if (this.isAttributeArray()) {
            return false;
        }
        String string = this.attribute.getType().getName();
        return "boolean".equals(string) || "byte".equals(string) || "short".equals(string) || "char".equals(string) || "int".equals(string) || "float".equals(string) || "long".equals(string) || "double".equals(string);
    }

    private boolean isAttributeMBean() {
        if (this.isAttributeArray()) {
            return this.genAttributeTypeMinusArrayBrackets().endsWith("MBean");
        }
        return this.attribute.getType().getName().endsWith("MBean");
    }

    private boolean isAttributeArray() {
        return this.attribute.getType().isArray();
    }

    private boolean isAttributeBoolean() {
        return this.attribute.getType().getName().equals("boolean");
    }

    private HashSet getAttributes() {
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList((Object[])this.m_reflector.getAttributes()));
        MBeanReflector mBeanReflector = new MBeanReflector(WebLogicMBean.class);
        List<Object> list = Arrays.asList((Object[])mBeanReflector.getAttributes());
        hashSet.removeAll(list);
        return hashSet;
    }

    private void addSourceFilesFromDir(File file, List list) throws Exception {
        this.verbose("Looking in " + file.getCanonicalPath());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase(Locale.US).endsWith("mbean.java")) continue;
            File file2 = new File(file, stringArray[i]);
            list.add(file2);
        }
    }

    private String unsetNumberLiteral() {
        String string = this.attribute.getType().getName();
        if ("byte".equals(string) || "short".equals(string) || "int".equals(string)) {
            return "-1";
        }
        if ("char".equals(string)) {
            return "0xffff";
        }
        if ("float".equals(string)) {
            return "-1.0";
        }
        if ("long".equals(string)) {
            return "-1L";
        }
        if ("double".equals(string)) {
            return "-1.0D";
        }
        return "__FIXME__THIS__IS__BROKEN__!!!";
    }

    private String prettyPrintType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType().getName() + "[]";
        }
        return clazz.getName();
    }

    private void verbose(String string) {
        if (this.verbose) {
            this.info(string);
        }
    }

    private void info(String string) {
        System.out.println("<MBean Compiler>" + string);
    }

    private static class Output
    extends CodeGenerator.Output {
        private Class ifc;
        private String clazz;
        private String absolutePath;

        public Output(Class clazz, String string, String string2) {
            super(Output.getFileName(clazz), "XMLElementMBeanImpl.j", string);
            this.ifc = clazz;
            this.absolutePath = string2;
        }

        public static String getClassName(Class clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            if (n > -1) {
                return string.substring(n + 1) + "Impl";
            }
            return string + "Impl";
        }

        private static String getFileName(Class clazz) {
            return Output.getClassName(clazz) + ".java";
        }

        public String getClassName() {
            return Output.getClassName(this.ifc);
        }

        public Class getInterface() {
            return this.ifc;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }
    }
}

