/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.upgrade;

import com.bea.xml.XmlValidationError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.VersionConstants;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.ManagementService;
import weblogic.management.upgrade.ConfigFileHelperConstants;
import weblogic.management.utils.PDevHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.version;

public class ConfigFileHelper
implements ConfigFileHelperConstants {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static int configurationVersion;
    private static boolean productionModeEnabled;
    private static byte[] old_format_version;
    private static byte[] new_format_version;
    private static byte[] old_format_mode;
    private static byte[] new_format_mode;
    private static int UTF8_ZERO;
    private static int UTF8_NINE;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUpgradeNeeded() throws ConfigFileException {
        if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
            return false;
        }
        File file = new File(DomainDir.getRootDir());
        boolean bl = ConfigFileHelper.isUpgradeNeeded(file);
        if (!bl) {
            return false;
        }
        boolean bl2 = false;
        if (System.getProperty("weblogic.ForceImplicitUpgradeIfNeeded") != null) {
            bl2 = Boolean.getBoolean("weblogic.ForceImplicitUpgradeIfNeeded");
        }
        if (bl2) {
            return true;
        }
        try {
            Serializable serializable;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader2 = PDevHelper.getPDevClassLoader(ConfigFileHelper.class.getClassLoader());
                Thread.currentThread().setContextClassLoader(classLoader2);
                serializable = classLoader2.loadClass("com.oracle.cie.domain.DomainTypeDetector");
                Method method = ((Class)serializable).getMethod("inspectDomain", File.class);
                Object object = method.invoke((Object)serializable, file);
                if (object == null) {
                    boolean bl3 = true;
                    return bl3;
                }
                Class<?> clazz = classLoader2.loadClass("com.oracle.cie.domain.PlatformDomainInfo");
                Method method2 = clazz.getMethod("isPureWLS", new Class[0]);
                Object object2 = method2.invoke(object, new Object[0]);
                if (object2 == null || !(object2 instanceof Boolean) || !((Boolean)object2).booleanValue()) {
                    ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
                    throw new ConfigFileException(managementTextTextFormatter.getNotPureWLSDomainText(file.getPath()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                serializable = invocationTargetException.getTargetException();
                throw new ConfigFileException(((Throwable)serializable).getMessage(), (Throwable)serializable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            boolean bl4 = ConfigFileHelper.getResponseFromUser();
            if (bl4) return true;
            throw new UpgradeNotWantedException(ManagementLogger.logUpgradeCancelledByUserLoggable().getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ConfigFileException(ManagementLogger.logUpgradeClassNotFoundLoggable((Throwable)noClassDefFoundError).getMessage());
        }
    }

    public static boolean isUpgradeNeeded(File file) throws ConfigFileException {
        boolean bl = false;
        ConfigFileHelper.ensureOneOrFewerConfigFiles(file);
        File file2 = new File(file, "config");
        File file3 = new File(file2, "config.xml");
        File file4 = new File(file, BootStrap.getConfigFileName());
        if (file3.exists()) {
            BufferedReader bufferedReader = ConfigFileHelper.getBufferedReader(file3);
            if (bufferedReader != null) {
                int n;
                configurationVersion = n = ConfigFileHelper.getConfigVersion(bufferedReader);
                if (n < 9) {
                    ConfigFileHelper.ensureClosed(bufferedReader);
                    bufferedReader = ConfigFileHelper.getBufferedReader(file3);
                    if (ConfigFileHelper.isOldFormat(bufferedReader)) {
                        String string = ManagementLogger.logExpectedVersion9Loggable((int)n).getMessage();
                        throw new ConfigFileException(string);
                    }
                }
                ConfigFileHelper.ensureClosed(bufferedReader);
            }
            if ((bufferedReader = ConfigFileHelper.getBufferedReader(file3)) != null) {
                productionModeEnabled = ConfigFileHelper.getProductionMode(bufferedReader);
                ConfigFileHelper.ensureClosed(bufferedReader);
            }
            return false;
        }
        if (file4.exists()) {
            BufferedReader bufferedReader = ConfigFileHelper.getBufferedReader(file4);
            if (bufferedReader != null) {
                productionModeEnabled = ConfigFileHelper.getProductionMode(bufferedReader);
                ConfigFileHelper.ensureClosed(bufferedReader);
            }
            bufferedReader = ConfigFileHelper.getBufferedReader(file4);
            int n = -1;
            if (bufferedReader != null) {
                configurationVersion = n = ConfigFileHelper.getConfigVersion(bufferedReader);
                ConfigFileHelper.ensureClosed(bufferedReader);
                if (n == 9) {
                    String string = ManagementLogger.logExpectedPreVersion9Loggable((int)n).getMessage();
                    throw new ConfigFileException(string);
                }
            }
            if (n >= 6 && n <= 8) {
                return true;
            }
            String string = file4.getAbsolutePath();
            String string2 = ManagementLogger.logUnexpectedConfigVersionLoggable((int)n, (String)string).getMessage();
            throw new ConfigFileException(string2);
        }
        if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
            return false;
        }
        throw new ConfigFileException("Unable to locate config.xml.");
    }

    public static int getConfigurationVersion() {
        return configurationVersion;
    }

    public static boolean getProductionModeEnabled() {
        return productionModeEnabled;
    }

    public static int getConfigurationVersionFromNewFormat(File file) throws ConfigFileException {
        BufferedReader bufferedReader = ConfigFileHelper.getBufferedReader(file);
        int n = -1;
        if (bufferedReader != null) {
            n = ConfigFileHelper.getConfigVersion(bufferedReader);
            ConfigFileHelper.ensureClosed(bufferedReader);
            return n;
        }
        throw new ConfigFileException("Unable to locate config.xml.");
    }

    private static BufferedReader getBufferedReader(File file) {
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        return bufferedReader;
    }

    private static int getConfigVersion(BufferedReader bufferedReader) throws ConfigFileException {
        boolean bl = ConfigFileHelper.isNewFormat(bufferedReader);
        try {
            int n = -1;
            int n2 = bufferedReader.read();
            int n3 = 0;
            int n4 = 0;
            while (n2 != -1) {
                n3 = n2 == old_format_version[n3] ? ++n3 : 0;
                if (n3 >= old_format_version.length) {
                    n = ConfigFileHelper.readInt(bufferedReader);
                    break;
                }
                n4 = n2 == new_format_version[n4] ? ++n4 : 0;
                if (n4 >= new_format_version.length) {
                    n = ConfigFileHelper.readInt(bufferedReader);
                    break;
                }
                n2 = bufferedReader.read();
            }
            if (n == -1) {
                return bl ? 9 : 8;
            }
            if (n >= 9 && bl) {
                return n;
            }
            if (n < 9 && !bl) {
                return n;
            }
            if (n == 9 && !bl) {
                return 8;
            }
            String string = bl ? "new format" : "old format";
            String string2 = "Found " + string + " config with invalid version: " + n;
            throw new ConfigFileException(string2);
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Error searching for config version", iOException);
        }
    }

    private static boolean getProductionMode(BufferedReader bufferedReader) throws ConfigFileException {
        boolean bl = ConfigFileHelper.isNewFormat(bufferedReader);
        try {
            boolean bl2 = false;
            int n = bufferedReader.read();
            int n2 = 0;
            int n3 = 0;
            while (n != -1) {
                n2 = n == old_format_mode[n2] ? ++n2 : 0;
                if (n2 >= old_format_mode.length) {
                    bl2 = ConfigFileHelper.readBoolean(bufferedReader);
                    break;
                }
                n3 = n == new_format_mode[n3] ? ++n3 : 0;
                if (n3 >= new_format_mode.length) {
                    bl2 = ConfigFileHelper.readBoolean(bufferedReader);
                    break;
                }
                n = bufferedReader.read();
            }
            return bl2;
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Error searching for config version", iOException);
        }
    }

    private static boolean isNewFormat(BufferedReader bufferedReader) throws ConfigFileException {
        try {
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                for (n = 0; n < VersionConstants.KNOWN_NAMESPACE_PREFIXES.length; ++n) {
                    if (!string.contains(VersionConstants.KNOWN_NAMESPACE_PREFIXES[n])) continue;
                    bl = true;
                    break;
                }
                for (n = 0; n < VersionConstants.NAMESPACE_DOMAIN_SUPPORTED_VERSIONS.length; ++n) {
                    if (!string.contains(VersionConstants.NAMESPACE_DOMAIN_SUPPORTED_VERSIONS[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            return bl;
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Unable to determine config file format", iOException);
        }
    }

    private static int readInt(BufferedReader bufferedReader) throws ConfigFileException {
        int n = -1;
        try {
            int n2 = bufferedReader.read();
            while (n2 != -1 && n2 >= UTF8_ZERO && n2 <= UTF8_NINE) {
                if (n < 0) {
                    n = n2 - UTF8_ZERO;
                } else {
                    n *= 10;
                    n += n2 - UTF8_ZERO;
                }
                n2 = bufferedReader.read();
            }
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Error reading config file version", iOException);
        }
        if (n == -1) {
            throw new ConfigFileException("Unable to read config file version number.");
        }
        return n;
    }

    private static boolean readBoolean(BufferedReader bufferedReader) throws ConfigFileException {
        boolean bl = false;
        try {
            int n = bufferedReader.read();
            if (n == 34 || n == 70 || n == 102) {
                bl = false;
            } else if (n == 84 || n == 116) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Error reading config file version", iOException);
        }
        return bl;
    }

    private static void ensureClosed(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void ensureOneOrFewerConfigFiles(File file) throws ConfigFileException {
        File file2 = new File(file, "config");
        File file3 = new File(file, BootStrap.getConfigFileName());
        File file4 = ConfigFileHelper.findParentConfig(file);
        File file5 = new File(file2, "config.xml");
        if (file3.exists()) {
            // empty if block
        }
    }

    private static File findParentConfig(File file) {
        File file2 = null;
        String string = file.getParent();
        if (string != null) {
            file2 = new File(string, BootStrap.getConfigFileName());
        }
        return file2;
    }

    private static boolean getResponseFromUser() {
        ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
        String string = managementTextTextFormatter.getAffirmitaveGenerateConfigText();
        String string2 = managementTextTextFormatter.getNegativeGenerateConfigText();
        for (int i = 1; i < 4; ++i) {
            String string3 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("\n" + managementTextTextFormatter.getImplicitUpgradePrompt(string, string2, version.getReleaseBuildVersion()) + ": ");
                string3 = bufferedReader.readLine();
                if (string3 != null && string3.equalsIgnoreCase(string)) {
                    return true;
                }
                if (string3 != null && string3.equalsIgnoreCase(string2)) {
                    return false;
                }
                System.out.println("\n" + managementTextTextFormatter.getPleaseConfirmDeny(string, string2));
                continue;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    private static boolean isOldFormat(BufferedReader bufferedReader) throws ConfigFileException {
        try {
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains("<Domain")) {
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            return bl;
        }
        catch (IOException iOException) {
            throw new ConfigFileException("Unable to determine config file format", iOException);
        }
    }

    public static boolean isAcceptableXmlValidationError(XmlValidationError xmlValidationError) {
        String string = xmlValidationError.getMessage();
        if (string != null && string.contains("is not derived from")) {
            String[] stringArray = string.split("is not derived from");
            for (int i = 0; i < VersionConstants.NAMESPACE_MAPPING.length; ++i) {
                if (stringArray.length <= 1 || !stringArray[1].contains(VersionConstants.NAMESPACE_MAPPING[i][1])) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        if (ConfigFileHelper.isUpgradeNeeded()) {
            System.out.println("NEED TO UPDATE");
        } else {
            System.out.println("config/config.xml is up to date");
        }
    }

    static {
        old_format_version = "ConfigurationVersion=\"".getBytes();
        new_format_version = "configuration-version>".getBytes();
        old_format_mode = "ProductionModeEnabled=\"".getBytes();
        new_format_mode = "production-mode-enabled>".getBytes();
        UTF8_ZERO = 48;
        UTF8_NINE = 57;
    }

    public static class UpgradeNotWantedException
    extends ConfigFileException {
        public UpgradeNotWantedException(String string) {
            super(string);
        }
    }

    static class ConfigFileException
    extends ManagementException {
        public ConfigFileException(String string) {
            super(string);
        }

        public ConfigFileException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

