/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.upgrade;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import javax.management.InvalidAttributeValueException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.descriptor.BasicDescriptorManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.mbean.MBeanBinderFactoryHelper;
import weblogic.management.internal.mbean.ReadOnlyMBeanBinder;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.security.internal.compatibility.SecurityDataInUserConfigMigrationProcessor;
import weblogic.management.upgrade.ConfigFileHelperConstants;
import weblogic.management.upgrade.ConfigTransformer;
import weblogic.management.upgrade.LogHandler;
import weblogic.utils.codegen.AttributeBinder;
import weblogic.utils.codegen.AttributeBinderFactory;
import weblogic.utils.codegen.AttributeBinderFactoryHelper;
import weblogic.version;

public class ConfigParser {
    private static Class BINDER_FACTORY_HELPER_CLASS = MBeanBinderFactoryHelper.class;
    private AttributeBinder root;
    private File config;
    private InputStream is;
    private AttributeBinderFactoryHelper helper;
    private String rootTag;
    private AttributeBinder top;
    private Stack stack = new Stack();
    private LogHandler logHandler;
    public static final String ALLOW_90_ATTRIBUTES = "weblogic.configuration.upgrade.Allow90Attributes";
    private static final boolean allow90Attributes = ConfigParser.getBooleanProperty("weblogic.configuration.upgrade.Allow90Attributes", false);
    private static final String[] transformScripts = ConfigFileHelperConstants.UPGRADE_XSLT_SCRIPTS;
    private static String[] ignoredElements = new String[]{"Administrator", "ApplicationConfiguration", "JTARecoveryService", "ApplicationManager"};
    private static final VersionInfo lastEight = new VersionInfo("8.9.9.9");
    String[][] skipList = new String[][]{{"SecurityConfiguration", "EnforceStrictURLPattern"}, {"SecurityConfiguration", "CompatibilityConnectionFiltersEnabled"}, {"SecurityConfiguration", "ConnectionFilter"}, {"SecurityConfiguration", "ConnectionFilterRules"}, {"SecurityConfiguration", "ConnectionLoggerEnabled"}, {"weblogic.management.security.Realm", "CombinedRoleMappingEnabled"}};
    private static final boolean isTransformEnabled = true;

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public ConfigParser(File file) {
        this.config = file;
    }

    public ConfigParser(File file, LogHandler logHandler) {
        this.config = file;
        this.logHandler = logHandler;
    }

    public ConfigParser(InputStream inputStream) {
        this.is = inputStream;
    }

    private boolean is70Domain() {
        if (this.config == null) {
            return false;
        }
        File file = this.config.getParentFile();
        File file2 = new File(file + "/userConfig");
        return file2.exists();
    }

    private InputStream insert70SecurityData(InputStream inputStream) throws IOException {
        if (this.config != null && this.is70Domain()) {
            File file = this.config.getParentFile();
            SecurityDataInUserConfigMigrationProcessor securityDataInUserConfigMigrationProcessor = new SecurityDataInUserConfigMigrationProcessor();
            inputStream = securityDataInUserConfigMigrationProcessor.updateConfiguration(inputStream, file);
        }
        return inputStream;
    }

    public void parse() throws ManagementException {
        this.parse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(boolean bl) throws ManagementException {
        EditableDescriptorManager editableDescriptorManager;
        XMLReader xMLReader = null;
        try {
            editableDescriptorManager = Class.forName("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            if (editableDescriptorManager != null) {
                xMLReader = (XMLReader)editableDescriptorManager.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)("Unexpected exception: " + instantiationException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)("Unexpected exception: " + illegalAccessException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                throw new AssertionError((Object)("Unable to create SAX parser " + sAXException));
            }
        }
        try {
            this.helper = (AttributeBinderFactoryHelper)BINDER_FACTORY_HELPER_CLASS.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)("Unexpected exception: " + instantiationException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)("Unexpected exception: " + illegalAccessException));
        }
        xMLReader.setContentHandler(new DefaultHandler(){

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if (ConfigParser.isIgnoredElement(string2)) {
                    return;
                }
                try {
                    ReadOnlyMBeanBinder readOnlyMBeanBinder;
                    AttributeBinderFactory attributeBinderFactory = ConfigParser.this.helper.getAttributeBinderFactory(string2);
                    AttributeBinder attributeBinder = attributeBinderFactory.getAttributeBinder();
                    ConfigParser.this.stack.push(ConfigParser.this.top);
                    if (ConfigParser.this.top == null) {
                        if (attributeBinder == null) {
                            throw new ManagementException("Unable to get binder for " + string2);
                        }
                        ConfigParser.this.root = attributeBinder;
                        ConfigParser.this.rootTag = string2;
                        if ("Domain".equals(string2) && (readOnlyMBeanBinder = ((ReadOnlyMBeanBinder)attributeBinder).getBean()) instanceof DomainMBean) {
                            DomainMBean domainMBean = (DomainMBean)readOnlyMBeanBinder;
                            domainMBean.setConfigurationVersion("8.1.0.0");
                            String string4 = version.getReleaseBuildVersion();
                            if (string4 != null) {
                                domainMBean.setDomainVersion(string4);
                            } else {
                                domainMBean.setDomainVersion("9.0.0.0");
                            }
                        }
                    }
                    if ((readOnlyMBeanBinder = (ReadOnlyMBeanBinder)ConfigParser.this.top) != null) {
                        attributeBinder.bindAttribute("Parent", (Object)readOnlyMBeanBinder.getBean());
                    }
                    ConfigParser.this.top = attributeBinder;
                    for (int i = attributes.getLength() - 1; i >= 0; --i) {
                        ConfigParser.this.logIf90((ReadOnlyMBeanBinder)attributeBinder, string2, attributes.getQName(i));
                        attributeBinder.bindAttribute(attributes.getQName(i), (Object)attributes.getValue(i));
                    }
                    this.logDeprecationInfo((ReadOnlyMBeanBinder)attributeBinder);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ManagementLogger.logOldSecurityProvidersFound();
                    throw new AssertionError((Object)classNotFoundException);
                }
                catch (Throwable throwable) {
                    throw new AssertionError((Object)throwable);
                }
            }

            public void endElement(String string, String string2, String string3) {
                if (ConfigParser.isIgnoredElement(string2)) {
                    return;
                }
                try {
                    AttributeBinder attributeBinder = (AttributeBinder)ConfigParser.this.stack.pop();
                    if (attributeBinder != null) {
                        ConfigParser.this.logIf90((ReadOnlyMBeanBinder)attributeBinder, string2, string3);
                        attributeBinder.bindAttribute(string2, (Object)ConfigParser.this.top);
                    }
                    ConfigParser.this.top = attributeBinder;
                }
                catch (Throwable throwable) {
                    throw new AssertionError((Object)throwable);
                }
            }

            public void characters(char[] cArray, int n, int n2) {
                String string = new String(cArray, n, n2).trim();
                if (string.length() > 0) {
                    ManagementLogger.logExtraneousConfigText((String)string);
                }
            }

            private void logDeprecationInfo(ReadOnlyMBeanBinder readOnlyMBeanBinder) {
                List list = readOnlyMBeanBinder.getDeprecationInfo();
                for (ReadOnlyMBeanBinder.DeprecationInfo deprecationInfo : list) {
                    ManagementLogger.logDeprecatedConfigurationProperty((String)deprecationInfo.getName(), (String)deprecationInfo.getType(), (String)deprecationInfo.getVersion(), (String)deprecationInfo.getMessage());
                }
            }
        });
        try {
            editableDescriptorManager = bl ? EDITABLE_DESCRIPTOR_MANAGER_SINGLETON.instance : READONLY_DESCRIPTOR_MANAGER_SINGLETON.instance;
            DescriptorImpl.beginConstruction((boolean)bl, (BasicDescriptorManager)editableDescriptorManager);
            DescriptorImpl descriptorImpl = null;
            if (this.config != null) {
                this.is = new FileInputStream(this.config);
                this.is = this.insert70SecurityData(this.is);
            }
            this.is = this.transform(this.is);
            try {
                xMLReader.parse(new InputSource(this.is));
            }
            finally {
                descriptorImpl = (DescriptorImpl)DescriptorImpl.endConstruction((DescriptorBean)this.getRoot());
            }
            this.fixupRoot();
            descriptorImpl.validate();
            descriptorImpl.setModified(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = new File(".").getAbsolutePath();
            throw new ManagementException("The configuration file " + this.config + " does not exist. (pwd=" + string + ")", (Throwable)fileNotFoundException);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            if (throwable instanceof AssertionError && ((Throwable)((Object)((AssertionError)((Object)throwable)))).getCause() instanceof ClassNotFoundException) {
                throw new ManagementException(ManagementLogger.logOldSecurityProvidersFoundLoggable().getMessage(), throwable);
            }
            String string = "Error parsing the configuration file " + this.config + ": " + throwable.getMessage();
            throw new ManagementException(string, throwable);
        }
    }

    private void logIf90(ReadOnlyMBeanBinder readOnlyMBeanBinder, String string, String string2) throws ManagementException {
        BeanInfoAccess beanInfoAccess = ManagementServiceClient.getBeanInfoAccess();
        BeanInfo beanInfo = null;
        if (beanInfoAccess != null) {
            beanInfo = beanInfoAccess.getBeanInfoForDescriptorBean(readOnlyMBeanBinder.getBean());
        }
        if (beanInfo == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = beanInfoAccess.getPropertyDescriptor(beanInfo, string2);
        if (propertyDescriptor == null) {
            string2 = this.pluralize(string2);
            propertyDescriptor = beanInfoAccess.getPropertyDescriptor(beanInfo, string2);
        }
        if (propertyDescriptor != null) {
            String string3 = (String)propertyDescriptor.getValue("since");
            this.checkVersion(string3, string, string2);
        }
    }

    private String pluralize(String string) {
        if (string == null) {
            return string;
        }
        if (string.endsWith("s")) {
            string = string + "es";
        } else if (string.endsWith("y")) {
            string = string.substring(0, string.length() - 1);
            string = string + "ies";
        } else {
            string = string + "s";
        }
        return string;
    }

    private void checkVersion(String string, String string2, String string3) throws ManagementException {
        VersionInfo versionInfo;
        if (string == null) {
            return;
        }
        if (string != null && (versionInfo = new VersionInfo(string)).laterThan((PackageInfo)lastEight) && !this.skipVersionCheck(string2, string3)) {
            String string4 = ManagementLogger.logAttributeNotValidBefore90Loggable((String)string2, (String)string3).getMessage();
            if (this.logHandler == null) {
                ManagementLogger.logAttributeNotValidBefore90((String)string2, (String)string3);
            } else {
                this.logHandler.log(string4);
            }
            if (!allow90Attributes) {
                throw new ManagementException(string4);
            }
        }
    }

    private boolean skipVersionCheck(String string, String string2) {
        for (int i = 0; i < this.skipList.length; ++i) {
            if (!this.skipList[i][0].equals(string) || !this.skipList[i][1].equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void fixupRoot() {
        DomainMBean domainMBean = this.getRoot();
        if (domainMBean == null) {
            return;
        }
        if (domainMBean.getName() == null) {
            try {
                String string = BootStrap.getDomainName();
                if (string == null) {
                    string = "mydomain";
                }
                domainMBean.setName(string);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
        }
    }

    private InputStream transform(InputStream inputStream) throws ManagementException {
        ConfigTransformer configTransformer = new ConfigTransformer(transformScripts);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        configTransformer.transform(inputStream, byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public DomainMBean getRoot() {
        if (this.root == null) {
            return null;
        }
        return (DomainMBean)((ReadOnlyMBeanBinder)this.root).getBean();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("java " + ConfigParser.class.getName() + " <filename>");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        ConfigParser configParser = new ConfigParser(file);
        configParser.parse(false);
    }

    private static boolean isIgnoredElement(String string) {
        if (string == null || ignoredElements == null) {
            return false;
        }
        for (int i = 0; i < ignoredElements.length; ++i) {
            if (!string.equals(ignoredElements[i])) continue;
            return true;
        }
        return false;
    }

    private class InputStreamWrapper
    extends InputStream {
        InputStream is;

        public InputStreamWrapper(InputStream inputStream) {
            this.is = inputStream;
        }

        public int read() throws IOException {
            int n = this.is.read();
            System.err.print(",");
            if (n > 127 || n <= 0) {
                System.err.print("<" + n + ">");
            }
            System.err.write(n);
            return n;
        }

        public void close() throws IOException {
            this.is.close();
            super.close();
        }
    }

    private static class EDITABLE_DESCRIPTOR_MANAGER_SINGLETON {
        static EditableDescriptorManager instance = new EditableDescriptorManager();

        private EDITABLE_DESCRIPTOR_MANAGER_SINGLETON() {
        }
    }

    private static class READONLY_DESCRIPTOR_MANAGER_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_DESCRIPTOR_MANAGER_SINGLETON() {
        }
    }
}

