/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.upgrade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import weblogic.management.ManagementException;
import weblogic.management.upgrade.ConfigFileHelperConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class ConfigTransformer
implements ErrorListener {
    private static String[] XSLT_SCRIPT = ConfigFileHelperConstants.UPGRADE_XSLT_SCRIPTS;
    private String[] scriptNames;
    private Transformer[] transformer;

    ConfigTransformer() throws ManagementException {
        this(XSLT_SCRIPT);
    }

    ConfigTransformer(String[] stringArray) throws ManagementException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(this);
        this.scriptNames = new String[stringArray.length];
        this.transformer = new Transformer[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Source source = ConfigTransformer.getXSLTSource(stringArray[i]);
                this.scriptNames[i] = stringArray[i];
                this.transformer[i] = transformerFactory.newTransformer(source);
                this.transformer[i].setErrorListener(this);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ManagementException("Error creating transformer", (Throwable)transformerConfigurationException);
        }
    }

    private static Source getXSLTSource(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            throw new AssertionError((Object)("failed to find " + string + " in classpath"));
        }
        return new SAXSource(new InputSource(inputStream));
    }

    public void transform(InputStream inputStream, OutputStream outputStream) throws ManagementException {
        ByteArrayOutputStream byteArrayOutputStream;
        for (int i = 0; i < this.transformer.length; ++i) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            StreamSource streamSource = new StreamSource(inputStream);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            try {
                this.transformer[i].transform(streamSource, streamResult);
            }
            catch (TransformerException transformerException) {
                throw new ManagementException("Error during transformation: " + this.scriptNames[i], (Throwable)transformerException);
            }
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        try {
            XMLInputStream xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream(inputStream);
            byteArrayOutputStream = XMLOutputStreamFactory.newInstance().newCanonicalOutputStream(outputStream);
            byteArrayOutputStream.add(xMLInputStream);
            byteArrayOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ManagementException(xMLStreamException.getMessage(), (Throwable)xMLStreamException);
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("java " + ConfigTransformer.class.getName() + " <configFile> [<outFile>]");
            System.exit(1);
        } else {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            OutputStream outputStream = System.out;
            if (stringArray.length > 1) {
                outputStream = new FileOutputStream(stringArray[1]);
            }
            new ConfigTransformer().transform(fileInputStream, outputStream);
        }
    }
}

