/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class AppDeploymentHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private AppDeploymentHelper() {
    }

    public static AppDeploymentMBean[] getAppsAndLibs(DomainMBean domainMBean) {
        ArrayList<AppDeploymentMBean> arrayList = new ArrayList<AppDeploymentMBean>();
        AppDeploymentMBean[] appDeploymentMBeanArray = domainMBean.getInternalLibraries();
        if (appDeploymentMBeanArray != null) {
            arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
        }
        if ((appDeploymentMBeanArray = domainMBean.getInternalAppDeployments()) != null) {
            arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
        }
        if ((appDeploymentMBeanArray = domainMBean.getLibraries()) != null) {
            arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
        }
        if ((appDeploymentMBeanArray = domainMBean.getAppDeployments()) != null) {
            arrayList.addAll(Arrays.asList(appDeploymentMBeanArray));
        }
        return arrayList.toArray(new AppDeploymentMBean[arrayList.size()]);
    }

    public static AppDeploymentMBean lookupAppOrLib(String string, DomainMBean domainMBean) {
        AppDeploymentMBean appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        if (appDeploymentMBean != null) {
            return appDeploymentMBean;
        }
        appDeploymentMBean = domainMBean.lookupLibrary(string);
        if (appDeploymentMBean != null) {
            return appDeploymentMBean;
        }
        appDeploymentMBean = domainMBean.lookupInternalAppDeployment(string);
        if (appDeploymentMBean != null) {
            return appDeploymentMBean;
        }
        return domainMBean.lookupInternalLibrary(string);
    }

    public static void destroyAppOrLib(AppDeploymentMBean appDeploymentMBean, DomainMBean domainMBean) {
        if (appDeploymentMBean.isInternalApp()) {
            return;
        }
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(appDeploymentMBean.getName());
        if (applicationMBean != null) {
            domainMBean.destroyApplication(applicationMBean);
        }
        if (appDeploymentMBean instanceof LibraryMBean) {
            domainMBean.destroyLibrary((LibraryMBean)appDeploymentMBean);
        } else {
            domainMBean.destroyAppDeployment(appDeploymentMBean);
        }
    }

    public static BasicDeploymentMBean lookupBasicDeployment(String string, DomainMBean domainMBean) {
        if (string == null) {
            return null;
        }
        if (domainMBean == null) {
            return null;
        }
        BasicDeploymentMBean[] basicDeploymentMBeanArray = domainMBean.getBasicDeployments();
        for (int i = 0; i < basicDeploymentMBeanArray.length; ++i) {
            if (!string.equals(basicDeploymentMBeanArray[i].getName())) continue;
            return basicDeploymentMBeanArray[i];
        }
        return null;
    }

    public static BasicDeploymentMBean lookupBasicDeployment(String string, long l) {
        BasicDeploymentMBean basicDeploymentMBean = null;
        DomainMBean domainMBean = DeploymentManager.getInstance(kernelId).getEditableDomainMBean(l);
        if (domainMBean != null) {
            basicDeploymentMBean = AppDeploymentHelper.lookupBasicDeployment(string, domainMBean);
        }
        if (basicDeploymentMBean == null) {
            basicDeploymentMBean = AppDeploymentHelper.lookupBasicDeployment(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return basicDeploymentMBean;
    }
}

