/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.utils.MBeanInfoLocalizationHelper;
import weblogic.management.utils.MessageLocalizationHelper;
import weblogic.management.utils.ModelMBeanInfoLocalizationHelper;
import weblogic.management.utils.OpenMBeanInfoLocalizationHelper;

class GenericMBeanInfoLocalizationHelper {
    public static final String DESCRIPTION_RESOURCE_BUNDLE_BASE_NAME = "descriptionResourceBundleBaseName";
    public static final String DESCRIPTION_RESOURCE_KEY = "descriptionResourceKey";
    public static final String DESCRIPTION_DISPLAY_NAME_KEY = "descriptionDisplayNameKey";
    private static DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugMBeanLocalization");

    GenericMBeanInfoLocalizationHelper() {
    }

    static String localizeDescription(Descriptor descriptor, Locale locale, String string, String string2) {
        String string3;
        block10: {
            string3 = null;
            if (descriptor != null) {
                String string4 = (String)descriptor.getFieldValue(DESCRIPTION_RESOURCE_BUNDLE_BASE_NAME);
                String string5 = (String)descriptor.getFieldValue(DESCRIPTION_RESOURCE_KEY);
                if (string4 == null || string4.length() == 0) {
                    string4 = string;
                }
                if (string5 == null || string5.length() == 0) {
                    string5 = string2;
                }
                if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
                    MessageLocalizationHelper messageLocalizationHelper;
                    block9: {
                        messageLocalizationHelper = null;
                        try {
                            messageLocalizationHelper = new MessageLocalizationHelper(string4, locale);
                        }
                        catch (MissingResourceException missingResourceException) {
                            if (!DEBUG_LOGGER.isDebugEnabled()) break block9;
                            DEBUG_LOGGER.debug("GenericMBeanInfoLocalizationHelper.localizeDescription(): : no resource bundle can be found for the specified base name " + string4);
                        }
                    }
                    if (messageLocalizationHelper != null) {
                        try {
                            string3 = messageLocalizationHelper.getLocalizedMessage(string5);
                        }
                        catch (MissingResourceException missingResourceException) {
                            if (!DEBUG_LOGGER.isDebugEnabled()) break block10;
                            DEBUG_LOGGER.debug("GenericMBeanInfoLocalizationHelper.localizeDescription(): : no object can be found for the given key " + string5);
                        }
                    }
                }
            }
        }
        return string3;
    }

    static Descriptor localizeDescriptor(DescriptorRead descriptorRead, Locale locale, String string) {
        String string2;
        Descriptor descriptor;
        block12: {
            MessageLocalizationHelper messageLocalizationHelper;
            String string3;
            block11: {
                descriptor = descriptorRead.getDescriptor();
                string3 = (String)descriptor.getFieldValue(DESCRIPTION_DISPLAY_NAME_KEY);
                if (string3 == null || string3.length() == 0) {
                    return descriptor;
                }
                String string4 = (String)descriptor.getFieldValue(DESCRIPTION_RESOURCE_BUNDLE_BASE_NAME);
                if (string4 == null || string4.length() == 0) {
                    string4 = string;
                }
                if (string == null || string.length() == 0) {
                    return descriptor;
                }
                messageLocalizationHelper = null;
                try {
                    messageLocalizationHelper = new MessageLocalizationHelper(string4, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block11;
                    DEBUG_LOGGER.debug("MBeanInfoLocalizationHelper.localizeDescriptor(): : no resource bundle can be found for the specified base name " + string4);
                }
            }
            string2 = null;
            if (messageLocalizationHelper != null) {
                try {
                    string2 = messageLocalizationHelper.getLocalizedMessage(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block12;
                    DEBUG_LOGGER.debug("MBeanInfoLocalizationHelper.localizeDescriptor(): : no object can be found for the given key " + string3);
                }
            }
        }
        String[] stringArray = descriptor.getFieldNames();
        if (string2 != null && descriptor.getFieldValue("displayName") == null && descriptor.getFieldValue("displayname") == null) {
            stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = "displayName";
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = descriptor.getFieldValue(stringArray[i]);
            if ("displayname".equals(stringArray[i])) {
                stringArray[i] = "displayName";
            }
            if (string2 == null || !"displayName".equals(stringArray[i])) continue;
            objectArray[i] = string2;
        }
        Descriptor descriptor2 = null;
        descriptor2 = descriptor instanceof ImmutableDescriptor ? new ImmutableDescriptor(stringArray, objectArray) : new DescriptorSupport(stringArray, objectArray);
        return descriptor2;
    }

    static MBeanInfo localizeGenericMBeanInfo(MBeanInfo mBeanInfo, Locale locale) {
        Descriptor descriptor = mBeanInfo.getDescriptor();
        String string = (String)descriptor.getFieldValue(DESCRIPTION_RESOURCE_BUNDLE_BASE_NAME);
        if ((string == null || string.length() == 0) && MBeanInfoLocalizationHelper.getDefaultResourceBundle(mBeanInfo, locale) != null) {
            string = MBeanInfoLocalizationHelper.getDefaultResourceBundleName(mBeanInfo);
        }
        String string2 = MBeanInfoLocalizationHelper.getBaseDefaultResourceKey(mBeanInfo);
        String string3 = string2 + "mbean";
        String string4 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanInfo.getDescriptor(), locale, string, string3);
        if (string4 == null) {
            string4 = mBeanInfo.getDescription();
        }
        descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanInfo, locale, string);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeAttributes(mBeanAttributeInfoArray, locale, string, string2 + "attribute.");
        MBeanConstructorInfo[] mBeanConstructorInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeConstructors(mBeanConstructorInfoArray, locale, string, string2 + "constructor.");
        MBeanOperationInfo[] mBeanOperationInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeOperations(mBeanOperationInfoArray, locale, string, string2 + "operation.");
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeNotifications(mBeanNotificationInfoArray, locale, string, string2 + "notification.");
        return new MBeanInfo(mBeanInfo.getClassName(), string4, mBeanAttributeInfoArray2, mBeanConstructorInfoArray2, mBeanOperationInfoArray2, mBeanNotificationInfoArray2, descriptor);
    }

    private static MBeanAttributeInfo[] localizeAttributes(MBeanAttributeInfo[] mBeanAttributeInfoArray, Locale locale, String string, String string2) {
        if (mBeanAttributeInfoArray == null) {
            return null;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = new MBeanAttributeInfo[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
            mBeanAttributeInfoArray2[i] = mBeanAttributeInfo instanceof ModelMBeanAttributeInfo ? ModelMBeanInfoLocalizationHelper.localizeModelMBeanAttribute((ModelMBeanAttributeInfo)ModelMBeanAttributeInfo.class.cast(mBeanAttributeInfo), locale, string, string2) : (mBeanAttributeInfo instanceof OpenMBeanAttributeInfoSupport ? OpenMBeanInfoLocalizationHelper.localizeOpenMBeanAttribute((OpenMBeanAttributeInfoSupport)OpenMBeanAttributeInfoSupport.class.cast(mBeanAttributeInfo), locale, string, string2) : GenericMBeanInfoLocalizationHelper.localizeMBeanAttribute(mBeanAttributeInfo, locale, string, string2));
        }
        return mBeanAttributeInfoArray2;
    }

    private static MBeanAttributeInfo localizeMBeanAttribute(MBeanAttributeInfo mBeanAttributeInfo, Locale locale, String string, String string2) {
        if (mBeanAttributeInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanAttributeInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanAttributeInfo.getDescriptor(), locale, string, string2 + mBeanAttributeInfo.getName());
        if (string3 == null) {
            string3 = mBeanAttributeInfo.getDescription();
        }
        return new MBeanAttributeInfo(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), string3, mBeanAttributeInfo.isReadable(), mBeanAttributeInfo.isWritable(), mBeanAttributeInfo.isIs(), descriptor);
    }

    private static MBeanConstructorInfo[] localizeConstructors(MBeanConstructorInfo[] mBeanConstructorInfoArray, Locale locale, String string, String string2) {
        if (mBeanConstructorInfoArray == null) {
            return null;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray2 = new MBeanConstructorInfo[mBeanConstructorInfoArray.length];
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            MBeanConstructorInfo mBeanConstructorInfo = mBeanConstructorInfoArray[i];
            mBeanConstructorInfoArray2[i] = mBeanConstructorInfo instanceof ModelMBeanConstructorInfo ? ModelMBeanInfoLocalizationHelper.localizeModelMBeanConstructor((ModelMBeanConstructorInfo)ModelMBeanConstructorInfo.class.cast(mBeanConstructorInfo), locale, string, string2) : (mBeanConstructorInfo instanceof OpenMBeanConstructorInfoSupport ? OpenMBeanInfoLocalizationHelper.localizeOpenMBeanConstructor((OpenMBeanConstructorInfoSupport)OpenMBeanConstructorInfoSupport.class.cast(mBeanConstructorInfo), locale, string, string2) : GenericMBeanInfoLocalizationHelper.localizeMBeanConstructor(mBeanConstructorInfo, locale, string, string2));
        }
        return mBeanConstructorInfoArray2;
    }

    static MBeanConstructorInfo localizeMBeanConstructor(MBeanConstructorInfo mBeanConstructorInfo, Locale locale, String string, String string2) {
        if (mBeanConstructorInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanConstructorInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanConstructorInfo.getDescriptor(), locale, string, string2 + mBeanConstructorInfo.getName());
        if (string3 == null) {
            string3 = mBeanConstructorInfo.getDescription();
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanConstructorInfo.getSignature();
        MBeanParameterInfo[] mBeanParameterInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeParameters(mBeanParameterInfoArray, locale, string, string2 + mBeanConstructorInfo.getName() + ".");
        return new MBeanConstructorInfo(mBeanConstructorInfo.getName(), string3, mBeanParameterInfoArray2, descriptor);
    }

    private static MBeanOperationInfo[] localizeOperations(MBeanOperationInfo[] mBeanOperationInfoArray, Locale locale, String string, String string2) {
        if (mBeanOperationInfoArray == null) {
            return null;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray2 = new MBeanOperationInfo[mBeanOperationInfoArray.length];
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            MBeanOperationInfo mBeanOperationInfo = mBeanOperationInfoArray[i];
            mBeanOperationInfoArray2[i] = mBeanOperationInfo instanceof ModelMBeanOperationInfo ? ModelMBeanInfoLocalizationHelper.localizeModelMBeanOperation((ModelMBeanOperationInfo)ModelMBeanOperationInfo.class.cast(mBeanOperationInfo), locale, string, string2) : (mBeanOperationInfo instanceof OpenMBeanOperationInfoSupport ? OpenMBeanInfoLocalizationHelper.localizeOpenMBeanOperation((OpenMBeanOperationInfoSupport)OpenMBeanOperationInfoSupport.class.cast(mBeanOperationInfo), locale, string, string2) : GenericMBeanInfoLocalizationHelper.localizeMBeanOperation(mBeanOperationInfo, locale, string, string2));
        }
        return mBeanOperationInfoArray2;
    }

    static MBeanOperationInfo localizeMBeanOperation(MBeanOperationInfo mBeanOperationInfo, Locale locale, String string, String string2) {
        if (mBeanOperationInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanOperationInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanOperationInfo.getDescriptor(), locale, string, string2 + mBeanOperationInfo.getName());
        if (string3 == null) {
            string3 = mBeanOperationInfo.getDescription();
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        MBeanParameterInfo[] mBeanParameterInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeParameters(mBeanParameterInfoArray, locale, string, string2 + mBeanOperationInfo.getName() + ".");
        return new MBeanOperationInfo(mBeanOperationInfo.getName(), string3, mBeanParameterInfoArray2, mBeanOperationInfo.getReturnType(), mBeanOperationInfo.getImpact(), descriptor);
    }

    static MBeanNotificationInfo[] localizeNotifications(MBeanNotificationInfo[] mBeanNotificationInfoArray, Locale locale, String string, String string2) {
        if (mBeanNotificationInfoArray == null) {
            return null;
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            MBeanNotificationInfo mBeanNotificationInfo = mBeanNotificationInfoArray[i];
            mBeanNotificationInfoArray2[i] = mBeanNotificationInfo instanceof ModelMBeanNotificationInfo ? ModelMBeanInfoLocalizationHelper.localizeModelMBeanNotification((ModelMBeanNotificationInfo)ModelMBeanNotificationInfo.class.cast(mBeanNotificationInfo), locale, string, string2) : GenericMBeanInfoLocalizationHelper.localizeMBeanNotification(mBeanNotificationInfo, locale, string, string2);
        }
        return mBeanNotificationInfoArray2;
    }

    private static MBeanNotificationInfo localizeMBeanNotification(MBeanNotificationInfo mBeanNotificationInfo, Locale locale, String string, String string2) {
        if (mBeanNotificationInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanNotificationInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanNotificationInfo.getDescriptor(), locale, string, string2 + mBeanNotificationInfo.getName());
        if (string3 == null) {
            string3 = mBeanNotificationInfo.getDescription();
        }
        return new MBeanNotificationInfo(mBeanNotificationInfo.getNotifTypes(), mBeanNotificationInfo.getName(), string3, descriptor);
    }

    static MBeanParameterInfo[] localizeParameters(MBeanParameterInfo[] mBeanParameterInfoArray, Locale locale, String string, String string2) {
        if (mBeanParameterInfoArray == null) {
            return null;
        }
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray[i];
            mBeanParameterInfoArray2[i] = mBeanParameterInfo instanceof OpenMBeanParameterInfoSupport ? OpenMBeanInfoLocalizationHelper.localizeOpenMBeanParameter((OpenMBeanParameterInfoSupport)OpenMBeanParameterInfoSupport.class.cast(mBeanParameterInfo), locale, string, string2) : GenericMBeanInfoLocalizationHelper.localizeMBeanParameter(mBeanParameterInfo, locale, string, string2);
        }
        return mBeanParameterInfoArray2;
    }

    private static MBeanParameterInfo localizeMBeanParameter(MBeanParameterInfo mBeanParameterInfo, Locale locale, String string, String string2) {
        if (mBeanParameterInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(mBeanParameterInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(mBeanParameterInfo.getDescriptor(), locale, string, string2 + mBeanParameterInfo.getName());
        if (string3 == null) {
            string3 = mBeanParameterInfo.getDescription();
        }
        return new MBeanParameterInfo(mBeanParameterInfo.getName(), mBeanParameterInfo.getType(), string3, descriptor);
    }
}

