/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.jms.deployer.BEAdminHandler;
import weblogic.jms.saf.SAFAgentDeployer;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.server.ServiceFailureException;

public class GenericManagedService {
    private Class mBeanClass;
    private String mBeanName;
    private Class handlerClass;
    private final Map handlers = new HashMap();
    private volatile boolean started;
    private boolean handleMigration;
    private static final boolean debug = System.getProperty("weblogic.management.utils.debug") != null;

    GenericManagedService(Class clazz, Class clazz2, boolean bl) {
        this.mBeanClass = clazz;
        this.mBeanName = clazz.getName();
        this.handlerClass = clazz2;
        this.handleMigration = bl;
    }

    Class getMBeanClass() {
        return this.mBeanClass;
    }

    Class getHandlerClass() {
        return this.handlerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServiceFailureException {
        ArrayList arrayList;
        if (this.started) {
            return;
        }
        this.started = true;
        if (debug) {
            this.logDebug("Subsystem called start");
        }
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.handlers.values());
        }
        object = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ManagedDeployment managedDeployment;
            ManagedDeployment managedDeployment2 = managedDeployment = (ManagedDeployment)iterator.next();
            synchronized (managedDeployment2) {
                if (managedDeployment.activated && managedDeployment.migrated && !managedDeployment.active) {
                    try {
                        if (debug) {
                            this.logDebug("Calling activate for " + managedDeployment);
                        }
                        managedDeployment.handler.activate(managedDeployment.bean);
                        managedDeployment.active = true;
                    }
                    catch (DeploymentException deploymentException) {
                        object = deploymentException;
                    }
                }
            }
        }
        if (object != null) {
            throw new ServiceFailureException((Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceFailureException {
        ArrayList arrayList;
        if (!this.started) {
            return;
        }
        this.started = false;
        if (debug) {
            this.logDebug("Subsystem called stop");
        }
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.handlers.values());
        }
        object = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ManagedDeployment managedDeployment;
            ManagedDeployment managedDeployment2 = managedDeployment = (ManagedDeployment)iterator.next();
            synchronized (managedDeployment2) {
                if (managedDeployment.active) {
                    try {
                        if (debug) {
                            this.logDebug("Calling deactivate for " + managedDeployment);
                        }
                        managedDeployment.handler.deactivate(managedDeployment.bean);
                        managedDeployment.active = false;
                    }
                    catch (UndeploymentException undeploymentException) {
                        object = undeploymentException;
                    }
                }
            }
        }
        if (object != null) {
            throw new ServiceFailureException((Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareDeployment(DeploymentMBean deploymentMBean) throws DeploymentException {
        ManagedDeployment managedDeployment;
        if (debug) {
            this.logDebug("Got prepareDeployment for " + deploymentMBean);
        }
        if ((managedDeployment = this.findDeployment(deploymentMBean)) == null) {
            managedDeployment = new ManagedDeployment(deploymentMBean);
            this.addDeployment(deploymentMBean, managedDeployment);
        }
        ManagedDeployment managedDeployment2 = managedDeployment;
        synchronized (managedDeployment2) {
            boolean bl = false;
            managedDeployment.bean = deploymentMBean;
            if (this.handleMigration) {
                TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
                for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
                    if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
                    if (debug) {
                        this.logDebug("Calling registerMigratableTarget for " + managedDeployment);
                    }
                    managedDeployment.registerMigratableTarget((MigratableTargetMBean)targetMBeanArray[i]);
                    bl = true;
                }
            }
            if (!bl) {
                if (debug) {
                    this.logDebug("Calling prepare for " + managedDeployment);
                }
                managedDeployment.handler.prepare(deploymentMBean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateDeployment(DeploymentMBean deploymentMBean) throws DeploymentException {
        ManagedDeployment managedDeployment;
        if (debug) {
            this.logDebug("Got activateDeployment for " + deploymentMBean);
        }
        if ((managedDeployment = this.findDeployment(deploymentMBean)) == null) {
            throw new DeploymentException("Deployment " + deploymentMBean + " was never prepared");
        }
        ManagedDeployment managedDeployment2 = managedDeployment;
        synchronized (managedDeployment2) {
            if (debug) {
                this.logDebug("Deployment for " + managedDeployment + " activated=" + managedDeployment.activated + " active=" + managedDeployment.active + "migrated=" + managedDeployment.migrated + "started=" + this.started);
            }
            managedDeployment.bean = deploymentMBean;
            managedDeployment.activated = true;
            if (this.started && managedDeployment.migrated && !managedDeployment.active) {
                if (debug) {
                    this.logDebug("Calling activate for " + managedDeployment);
                }
                managedDeployment.handler.activate(deploymentMBean);
                managedDeployment.active = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivateDeployment(DeploymentMBean deploymentMBean) throws UndeploymentException {
        ManagedDeployment managedDeployment;
        if (debug) {
            this.logDebug("Got deactivateDeployment for " + deploymentMBean);
        }
        if ((managedDeployment = this.findDeployment(deploymentMBean)) == null) {
            throw new UndeploymentException("Deployment " + deploymentMBean + " was never prepared");
        }
        ManagedDeployment managedDeployment2 = managedDeployment;
        synchronized (managedDeployment2) {
            managedDeployment.bean = deploymentMBean;
            managedDeployment.activated = false;
            if (managedDeployment.active) {
                if (debug) {
                    this.logDebug("Calling deactivate for " + managedDeployment);
                }
                managedDeployment.handler.deactivate(deploymentMBean);
                managedDeployment.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprepareDeployment(DeploymentMBean deploymentMBean) throws UndeploymentException {
        ManagedDeployment managedDeployment;
        if (debug) {
            this.logDebug("Got unprepareDeployment for " + deploymentMBean);
        }
        if ((managedDeployment = this.findDeployment(deploymentMBean)) == null) {
            throw new UndeploymentException("Deployment " + deploymentMBean + " was never prepared");
        }
        ManagedDeployment managedDeployment2 = managedDeployment;
        synchronized (managedDeployment2) {
            managedDeployment.bean = deploymentMBean;
            if (this.handleMigration) {
                ManagedDeployment managedDeployment3 = managedDeployment;
                synchronized (managedDeployment3) {
                    TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
                    for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
                        if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
                        if (debug) {
                            this.logDebug("Unregistering migratableTarget for " + managedDeployment);
                        }
                        managedDeployment.unregisterMigratableTarget((MigratableTargetMBean)targetMBeanArray[i]);
                    }
                }
            }
            if (managedDeployment.migrated) {
                if (debug) {
                    this.logDebug("Calling unprepare for " + managedDeployment);
                }
                managedDeployment.handler.unprepare(deploymentMBean);
            }
        }
        this.removeDeployment(deploymentMBean);
    }

    private synchronized ManagedDeployment findDeployment(DeploymentMBean deploymentMBean) {
        return (ManagedDeployment)this.handlers.get(deploymentMBean.getName());
    }

    private synchronized void addDeployment(DeploymentMBean deploymentMBean, ManagedDeployment managedDeployment) {
        this.handlers.put(deploymentMBean.getName(), managedDeployment);
    }

    private synchronized void removeDeployment(DeploymentMBean deploymentMBean) {
        this.handlers.remove(deploymentMBean.getName());
    }

    private void logDebug(String string) {
        System.out.println("GenericManagedService " + this.mBeanName + ": " + string);
    }

    private final class ManagedDeployment
    implements Migratable {
        private DeploymentMBean bean;
        private GenericAdminHandler handler;
        private boolean activated;
        private boolean migrated;
        private boolean active;
        private int skew = 0;

        ManagedDeployment(DeploymentMBean deploymentMBean) throws DeploymentException {
            this.bean = deploymentMBean;
            if (deploymentMBean instanceof FileStoreMBean) {
                this.skew = -100;
            }
            if (deploymentMBean instanceof JMSServerMBean) {
                this.skew = 100;
            }
            try {
                this.handler = (GenericAdminHandler)GenericManagedService.this.handlerClass.newInstance();
                this.migrated = true;
            }
            catch (Exception exception) {
                throw new DeploymentException("Can't instantiate handler class: " + exception, exception);
            }
        }

        public String getName() {
            return this.bean.getName();
        }

        synchronized void registerMigratableTarget(MigratableTargetMBean migratableTargetMBean) throws DeploymentException {
            this.migrated = false;
            try {
                MigrationManager.singleton().register(this, migratableTargetMBean);
            }
            catch (MigrationException migrationException) {
                throw new DeploymentException(migrationException);
            }
        }

        void unregisterMigratableTarget(MigratableTargetMBean migratableTargetMBean) throws UndeploymentException {
            try {
                MigrationManager.singleton().unregister(this, migratableTargetMBean);
            }
            catch (MigrationException migrationException) {
                throw new UndeploymentException(migrationException);
            }
        }

        public void migratableInitialize() {
        }

        public synchronized void migratableActivate() throws MigrationException {
            if (debug) {
                GenericManagedService.this.logDebug("Got migratableActivate for " + this);
            }
            this.migrated = true;
            try {
                block7: {
                    try {
                        if (debug) {
                            GenericManagedService.this.logDebug("Calling prepare for " + this);
                        }
                        this.setMigrationStatus(true);
                        this.handler.prepare(this.bean);
                        if (!this.activated || !GenericManagedService.this.started || this.active) break block7;
                        if (debug) {
                            GenericManagedService.this.logDebug("Calling activate for " + this);
                        }
                        this.handler.activate(this.bean);
                        this.active = true;
                    }
                    catch (DeploymentException deploymentException) {
                        throw new MigrationException((Exception)((Object)deploymentException));
                    }
                }
                Object var3_1 = null;
                this.setMigrationStatus(false);
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.setMigrationStatus(false);
                throw throwable;
            }
        }

        public synchronized void migratableDeactivate() throws MigrationException {
            if (debug) {
                GenericManagedService.this.logDebug("Got migratableDeactivate for " + this);
            }
            this.migrated = false;
            try {
                try {
                    this.setMigrationStatus(true);
                    if (this.active) {
                        if (debug) {
                            GenericManagedService.this.logDebug("Calling deactivate for " + this);
                        }
                        this.handler.deactivate(this.bean);
                        this.active = false;
                    }
                    if (debug) {
                        GenericManagedService.this.logDebug("Calling unprepare for " + this);
                    }
                    this.handler.unprepare(this.bean);
                }
                catch (UndeploymentException undeploymentException) {
                    throw new MigrationException((Exception)((Object)undeploymentException));
                }
                Object var3_1 = null;
                this.setMigrationStatus(false);
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.setMigrationStatus(false);
                throw throwable;
            }
        }

        private void setMigrationStatus(boolean bl) {
            if (this.handler instanceof BEAdminHandler) {
                ((BEAdminHandler)this.handler).setMigrationInProgress(bl);
            } else if (this.handler instanceof SAFAgentDeployer) {
                ((SAFAgentDeployer)this.handler).setMigrationInProgress(bl);
            }
        }

        public String toString() {
            return "[Handler for " + this.bean.getType() + " " + this.bean.getName() + "]";
        }

        public int getOrder() {
            return -1900 + this.skew;
        }
    }
}

