/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.util.ArrayList;
import java.util.List;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.management.utils.GenericManagedService;

public class GenericServiceManager
implements DeploymentHandler {
    private static final GenericServiceManager myself = new GenericServiceManager();
    private boolean initialized;
    private final List handlerList = new ArrayList();

    private GenericServiceManager() {
    }

    public static GenericServiceManager getManager() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericManagedService register(Class clazz, Class clazz2, boolean bl) {
        if (!DeploymentMBean.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not implement DeploymentMBean");
        }
        if (!GenericAdminHandler.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("The class " + clazz2.getName() + " does not implement GenericAdminHandler");
        }
        GenericManagedService genericManagedService = new GenericManagedService(clazz, clazz2, bl);
        GenericServiceManager genericServiceManager = this;
        synchronized (genericServiceManager) {
            this.handlerList.add(genericManagedService);
            if (!this.initialized) {
                DeploymentHandlerHome.addDeploymentHandler(this);
                this.initialized = true;
            }
        }
        return genericManagedService;
    }

    private synchronized GenericManagedService findService(DeploymentMBean deploymentMBean) {
        for (GenericManagedService genericManagedService : this.handlerList) {
            if (!genericManagedService.getMBeanClass().isAssignableFrom(deploymentMBean.getClass())) continue;
            return genericManagedService;
        }
        return null;
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        GenericManagedService genericManagedService = this.findService(deploymentMBean);
        if (genericManagedService != null) {
            genericManagedService.prepareDeployment(deploymentMBean);
        }
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        GenericManagedService genericManagedService = this.findService(deploymentMBean);
        if (genericManagedService != null) {
            genericManagedService.activateDeployment(deploymentMBean);
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        GenericManagedService genericManagedService = this.findService(deploymentMBean);
        if (genericManagedService != null) {
            genericManagedService.deactivateDeployment(deploymentMBean);
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        GenericManagedService genericManagedService = this.findService(deploymentMBean);
        if (genericManagedService != null) {
            genericManagedService.unprepareDeployment(deploymentMBean);
        }
    }
}

