/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.AbstractSchemaHelper2;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.commo.AbstractCommoConfigurationBean;
import weblogic.management.utils.LDAPServerMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class LDAPServerMBeanImpl
extends AbstractCommoConfigurationBean
implements LDAPServerMBean,
Serializable {
    private boolean _BindAnonymouslyOnReferrals;
    private boolean _CacheEnabled;
    private int _CacheSize;
    private int _CacheTTL;
    private int _ConnectTimeout;
    private int _ConnectionPoolSize;
    private int _ConnectionRetryLimit;
    private String _Credential;
    private byte[] _CredentialEncrypted;
    private boolean _FollowReferrals;
    private String _Host;
    private int _ParallelConnectDelay;
    private int _Port;
    private String _Principal;
    private int _ResultsTimeLimit;
    private boolean _SSLEnabled;
    private static SchemaHelper2 _schemaHelper;

    public LDAPServerMBeanImpl() {
        this._initializeProperty(-1);
    }

    public LDAPServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getHost() {
        return this._Host;
    }

    public boolean isHostSet() {
        return this._isSet(2);
    }

    public void setHost(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Host;
        this._Host = string;
        this._postSet(2, string2, string);
    }

    public int getPort() {
        return this._Port;
    }

    public boolean isPortSet() {
        return this._isSet(3);
    }

    public void setPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"Port", (long)n, (long)1L, (long)65534L);
        int n2 = this._Port;
        this._Port = n;
        this._postSet(3, n2, n);
    }

    public boolean isSSLEnabled() {
        return this._SSLEnabled;
    }

    public boolean isSSLEnabledSet() {
        return this._isSet(4);
    }

    public void setSSLEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._SSLEnabled;
        this._SSLEnabled = bl;
        this._postSet(4, bl2, bl);
    }

    public String getPrincipal() {
        return this._Principal;
    }

    public boolean isPrincipalSet() {
        return this._isSet(5);
    }

    public void setPrincipal(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Principal;
        this._Principal = string;
        this._postSet(5, string2, string);
    }

    public String getCredential() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : this._decrypt("Credential", byArray);
    }

    public boolean isCredentialSet() {
        return this.isCredentialEncryptedSet();
    }

    public void setCredential(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setCredentialEncrypted(string == null ? null : this._encrypt("Credential", string));
    }

    public byte[] getCredentialEncrypted() {
        return this._getHelper()._cloneArray(this._CredentialEncrypted);
    }

    public String getCredentialEncryptedAsString() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCredentialEncryptedSet() {
        return this._isSet(7);
    }

    public void setCredentialEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCredentialEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isCacheEnabled() {
        return this._CacheEnabled;
    }

    public boolean isCacheEnabledSet() {
        return this._isSet(8);
    }

    public void setCacheEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._CacheEnabled;
        this._CacheEnabled = bl;
        this._postSet(8, bl2, bl);
    }

    public int getCacheSize() {
        return this._CacheSize;
    }

    public boolean isCacheSizeSet() {
        return this._isSet(9);
    }

    public void setCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"CacheSize", (int)n, (int)0);
        int n2 = this._CacheSize;
        this._CacheSize = n;
        this._postSet(9, n2, n);
    }

    public int getCacheTTL() {
        return this._CacheTTL;
    }

    public boolean isCacheTTLSet() {
        return this._isSet(10);
    }

    public void setCacheTTL(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"CacheTTL", (int)n, (int)0);
        int n2 = this._CacheTTL;
        this._CacheTTL = n;
        this._postSet(10, n2, n);
    }

    public boolean isFollowReferrals() {
        return this._FollowReferrals;
    }

    public boolean isFollowReferralsSet() {
        return this._isSet(11);
    }

    public void setFollowReferrals(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._FollowReferrals;
        this._FollowReferrals = bl;
        this._postSet(11, bl2, bl);
    }

    public boolean isBindAnonymouslyOnReferrals() {
        return this._BindAnonymouslyOnReferrals;
    }

    public boolean isBindAnonymouslyOnReferralsSet() {
        return this._isSet(12);
    }

    public void setBindAnonymouslyOnReferrals(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._BindAnonymouslyOnReferrals;
        this._BindAnonymouslyOnReferrals = bl;
        this._postSet(12, bl2, bl);
    }

    public int getResultsTimeLimit() {
        return this._ResultsTimeLimit;
    }

    public boolean isResultsTimeLimitSet() {
        return this._isSet(13);
    }

    public void setResultsTimeLimit(int n) throws InvalidAttributeValueException {
        int n2 = this._ResultsTimeLimit;
        this._ResultsTimeLimit = n;
        this._postSet(13, n2, n);
    }

    public int getConnectTimeout() {
        return this._ConnectTimeout;
    }

    public boolean isConnectTimeoutSet() {
        return this._isSet(14);
    }

    public void setConnectTimeout(int n) throws InvalidAttributeValueException {
        int n2 = this._ConnectTimeout;
        this._ConnectTimeout = n;
        this._postSet(14, n2, n);
    }

    public int getParallelConnectDelay() {
        return this._ParallelConnectDelay;
    }

    public boolean isParallelConnectDelaySet() {
        return this._isSet(15);
    }

    public void setParallelConnectDelay(int n) throws InvalidAttributeValueException {
        int n2 = this._ParallelConnectDelay;
        this._ParallelConnectDelay = n;
        this._postSet(15, n2, n);
    }

    public int getConnectionRetryLimit() {
        return this._ConnectionRetryLimit;
    }

    public boolean isConnectionRetryLimitSet() {
        return this._isSet(16);
    }

    public void setConnectionRetryLimit(int n) throws InvalidAttributeValueException {
        int n2 = this._ConnectionRetryLimit;
        this._ConnectionRetryLimit = n;
        this._postSet(16, n2, n);
    }

    public int getConnectionPoolSize() {
        return this._ConnectionPoolSize;
    }

    public boolean isConnectionPoolSizeSet() {
        return this._isSet(17);
    }

    public void setConnectionPoolSize(int n) throws InvalidAttributeValueException {
        int n2 = this._ConnectionPoolSize;
        this._ConnectionPoolSize = n;
        this._postSet(17, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setCredentialEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CredentialEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CredentialEncrypted of LDAPServerMBean");
        }
        this._getHelper()._clearArray(this._CredentialEncrypted);
        this._CredentialEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(7, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 6) {
                this._markSet(7, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._CacheSize = 32;
                    if (bl) break;
                }
                case 10: {
                    this._CacheTTL = 60;
                    if (bl) break;
                }
                case 14: {
                    this._ConnectTimeout = 0;
                    if (bl) break;
                }
                case 17: {
                    this._ConnectionPoolSize = 6;
                    if (bl) break;
                }
                case 16: {
                    this._ConnectionRetryLimit = 1;
                    if (bl) break;
                }
                case 6: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 7: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 2: {
                    this._Host = "localhost";
                    if (bl) break;
                }
                case 15: {
                    this._ParallelConnectDelay = 0;
                    if (bl) break;
                }
                case 3: {
                    this._Port = 389;
                    if (bl) break;
                }
                case 5: {
                    this._Principal = null;
                    if (bl) break;
                }
                case 13: {
                    this._ResultsTimeLimit = 0;
                    if (bl) break;
                }
                case 12: {
                    this._BindAnonymouslyOnReferrals = false;
                    if (bl) break;
                }
                case 8: {
                    this._CacheEnabled = true;
                    if (bl) break;
                }
                case 11: {
                    this._FollowReferrals = true;
                    if (bl) break;
                }
                case 4: {
                    this._SSLEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/security";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String wls_getInterfaceClassName() {
        return "weblogic.management.utils.LDAPServerMBean";
    }

    public static class SchemaHelper2
    extends AbstractSchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 10: {
                    if (string.equals("cache-size")) {
                        return 9;
                    }
                    if (!string.equals("credential")) break;
                    return 6;
                }
                case 8: {
                    if (!string.equals("cachettl")) break;
                    return 10;
                }
                case 15: {
                    if (!string.equals("connect-timeout")) break;
                    return 14;
                }
                case 20: {
                    if (string.equals("connection-pool-size")) {
                        return 17;
                    }
                    if (!string.equals("credential-encrypted")) break;
                    return 7;
                }
                case 22: {
                    if (string.equals("connection-retry-limit")) {
                        return 16;
                    }
                    if (!string.equals("parallel-connect-delay")) break;
                    return 15;
                }
                case 4: {
                    if (string.equals("host")) {
                        return 2;
                    }
                    if (!string.equals("port")) break;
                    return 3;
                }
                case 9: {
                    if (!string.equals("principal")) break;
                    return 5;
                }
                case 18: {
                    if (!string.equals("results-time-limit")) break;
                    return 13;
                }
                case 29: {
                    if (!string.equals("bind-anonymously-on-referrals")) break;
                    return 12;
                }
                case 13: {
                    if (!string.equals("cache-enabled")) break;
                    return 8;
                }
                case 16: {
                    if (!string.equals("follow-referrals")) break;
                    return 11;
                }
                case 11: {
                    if (!string.equals("ssl-enabled")) break;
                    return 4;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "cache-size";
                }
                case 10: {
                    return "cachettl";
                }
                case 14: {
                    return "connect-timeout";
                }
                case 17: {
                    return "connection-pool-size";
                }
                case 16: {
                    return "connection-retry-limit";
                }
                case 6: {
                    return "credential";
                }
                case 7: {
                    return "credential-encrypted";
                }
                case 2: {
                    return "host";
                }
                case 15: {
                    return "parallel-connect-delay";
                }
                case 3: {
                    return "port";
                }
                case 5: {
                    return "principal";
                }
                case 13: {
                    return "results-time-limit";
                }
                case 12: {
                    return "bind-anonymously-on-referrals";
                }
                case 8: {
                    return "cache-enabled";
                }
                case 11: {
                    return "follow-referrals";
                }
                case 4: {
                    return "ssl-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }
    }

    protected static class Helper
    extends AbstractCommoConfigurationBean.Helper {
        private LDAPServerMBeanImpl bean;

        protected Helper(LDAPServerMBeanImpl lDAPServerMBeanImpl) {
            super((AbstractCommoConfigurationBean)lDAPServerMBeanImpl);
            this.bean = lDAPServerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "CacheSize";
                }
                case 10: {
                    return "CacheTTL";
                }
                case 14: {
                    return "ConnectTimeout";
                }
                case 17: {
                    return "ConnectionPoolSize";
                }
                case 16: {
                    return "ConnectionRetryLimit";
                }
                case 6: {
                    return "Credential";
                }
                case 7: {
                    return "CredentialEncrypted";
                }
                case 2: {
                    return "Host";
                }
                case 15: {
                    return "ParallelConnectDelay";
                }
                case 3: {
                    return "Port";
                }
                case 5: {
                    return "Principal";
                }
                case 13: {
                    return "ResultsTimeLimit";
                }
                case 12: {
                    return "BindAnonymouslyOnReferrals";
                }
                case 8: {
                    return "CacheEnabled";
                }
                case 11: {
                    return "FollowReferrals";
                }
                case 4: {
                    return "SSLEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CacheSize")) {
                return 9;
            }
            if (string.equals("CacheTTL")) {
                return 10;
            }
            if (string.equals("ConnectTimeout")) {
                return 14;
            }
            if (string.equals("ConnectionPoolSize")) {
                return 17;
            }
            if (string.equals("ConnectionRetryLimit")) {
                return 16;
            }
            if (string.equals("Credential")) {
                return 6;
            }
            if (string.equals("CredentialEncrypted")) {
                return 7;
            }
            if (string.equals("Host")) {
                return 2;
            }
            if (string.equals("ParallelConnectDelay")) {
                return 15;
            }
            if (string.equals("Port")) {
                return 3;
            }
            if (string.equals("Principal")) {
                return 5;
            }
            if (string.equals("ResultsTimeLimit")) {
                return 13;
            }
            if (string.equals("BindAnonymouslyOnReferrals")) {
                return 12;
            }
            if (string.equals("CacheEnabled")) {
                return 8;
            }
            if (string.equals("FollowReferrals")) {
                return 11;
            }
            if (string.equals("SSLEnabled")) {
                return 4;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCacheSizeSet()) {
                    stringBuffer.append("CacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getCacheSize()));
                }
                if (this.bean.isCacheTTLSet()) {
                    stringBuffer.append("CacheTTL");
                    stringBuffer.append(String.valueOf(this.bean.getCacheTTL()));
                }
                if (this.bean.isConnectTimeoutSet()) {
                    stringBuffer.append("ConnectTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getConnectTimeout()));
                }
                if (this.bean.isConnectionPoolSizeSet()) {
                    stringBuffer.append("ConnectionPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPoolSize()));
                }
                if (this.bean.isConnectionRetryLimitSet()) {
                    stringBuffer.append("ConnectionRetryLimit");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionRetryLimit()));
                }
                if (this.bean.isCredentialSet()) {
                    stringBuffer.append("Credential");
                    stringBuffer.append(String.valueOf(this.bean.getCredential()));
                }
                if (this.bean.isCredentialEncryptedSet()) {
                    stringBuffer.append("CredentialEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCredentialEncrypted())));
                }
                if (this.bean.isHostSet()) {
                    stringBuffer.append("Host");
                    stringBuffer.append(String.valueOf(this.bean.getHost()));
                }
                if (this.bean.isParallelConnectDelaySet()) {
                    stringBuffer.append("ParallelConnectDelay");
                    stringBuffer.append(String.valueOf(this.bean.getParallelConnectDelay()));
                }
                if (this.bean.isPortSet()) {
                    stringBuffer.append("Port");
                    stringBuffer.append(String.valueOf(this.bean.getPort()));
                }
                if (this.bean.isPrincipalSet()) {
                    stringBuffer.append("Principal");
                    stringBuffer.append(String.valueOf(this.bean.getPrincipal()));
                }
                if (this.bean.isResultsTimeLimitSet()) {
                    stringBuffer.append("ResultsTimeLimit");
                    stringBuffer.append(String.valueOf(this.bean.getResultsTimeLimit()));
                }
                if (this.bean.isBindAnonymouslyOnReferralsSet()) {
                    stringBuffer.append("BindAnonymouslyOnReferrals");
                    stringBuffer.append(String.valueOf(this.bean.isBindAnonymouslyOnReferrals()));
                }
                if (this.bean.isCacheEnabledSet()) {
                    stringBuffer.append("CacheEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCacheEnabled()));
                }
                if (this.bean.isFollowReferralsSet()) {
                    stringBuffer.append("FollowReferrals");
                    stringBuffer.append(String.valueOf(this.bean.isFollowReferrals()));
                }
                if (this.bean.isSSLEnabledSet()) {
                    stringBuffer.append("SSLEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSSLEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                LDAPServerMBeanImpl lDAPServerMBeanImpl = (LDAPServerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CacheSize", this.bean.getCacheSize(), lDAPServerMBeanImpl.getCacheSize(), false);
                this.computeDiff("CacheTTL", this.bean.getCacheTTL(), lDAPServerMBeanImpl.getCacheTTL(), false);
                this.computeDiff("ConnectTimeout", this.bean.getConnectTimeout(), lDAPServerMBeanImpl.getConnectTimeout(), false);
                this.computeDiff("ConnectionPoolSize", this.bean.getConnectionPoolSize(), lDAPServerMBeanImpl.getConnectionPoolSize(), true);
                this.computeDiff("ConnectionRetryLimit", this.bean.getConnectionRetryLimit(), lDAPServerMBeanImpl.getConnectionRetryLimit(), false);
                this.computeDiff("CredentialEncrypted", this.bean.getCredentialEncrypted(), lDAPServerMBeanImpl.getCredentialEncrypted(), false);
                this.computeDiff("Host", this.bean.getHost(), lDAPServerMBeanImpl.getHost(), false);
                this.computeDiff("ParallelConnectDelay", this.bean.getParallelConnectDelay(), lDAPServerMBeanImpl.getParallelConnectDelay(), false);
                this.computeDiff("Port", this.bean.getPort(), lDAPServerMBeanImpl.getPort(), false);
                this.computeDiff("Principal", this.bean.getPrincipal(), lDAPServerMBeanImpl.getPrincipal(), false);
                this.computeDiff("ResultsTimeLimit", this.bean.getResultsTimeLimit(), lDAPServerMBeanImpl.getResultsTimeLimit(), false);
                this.computeDiff("BindAnonymouslyOnReferrals", this.bean.isBindAnonymouslyOnReferrals(), lDAPServerMBeanImpl.isBindAnonymouslyOnReferrals(), false);
                this.computeDiff("CacheEnabled", this.bean.isCacheEnabled(), lDAPServerMBeanImpl.isCacheEnabled(), false);
                this.computeDiff("FollowReferrals", this.bean.isFollowReferrals(), lDAPServerMBeanImpl.isFollowReferrals(), false);
                this.computeDiff("SSLEnabled", this.bean.isSSLEnabled(), lDAPServerMBeanImpl.isSSLEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                LDAPServerMBeanImpl lDAPServerMBeanImpl = (LDAPServerMBeanImpl)beanUpdateEvent.getSourceBean();
                LDAPServerMBeanImpl lDAPServerMBeanImpl2 = (LDAPServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CacheSize")) {
                    lDAPServerMBeanImpl.setCacheSize(lDAPServerMBeanImpl2.getCacheSize());
                    lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("CacheTTL")) {
                    lDAPServerMBeanImpl.setCacheTTL(lDAPServerMBeanImpl2.getCacheTTL());
                    lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ConnectTimeout")) {
                    lDAPServerMBeanImpl.setConnectTimeout(lDAPServerMBeanImpl2.getConnectTimeout());
                    lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("ConnectionPoolSize")) {
                    lDAPServerMBeanImpl.setConnectionPoolSize(lDAPServerMBeanImpl2.getConnectionPoolSize());
                    lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ConnectionRetryLimit")) {
                    lDAPServerMBeanImpl.setConnectionRetryLimit(lDAPServerMBeanImpl2.getConnectionRetryLimit());
                    lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (!string.equals("Credential")) {
                    if (string.equals("CredentialEncrypted")) {
                        lDAPServerMBeanImpl.setCredentialEncrypted(lDAPServerMBeanImpl2.getCredentialEncrypted());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("Host")) {
                        lDAPServerMBeanImpl.setHost(lDAPServerMBeanImpl2.getHost());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("ParallelConnectDelay")) {
                        lDAPServerMBeanImpl.setParallelConnectDelay(lDAPServerMBeanImpl2.getParallelConnectDelay());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("Port")) {
                        lDAPServerMBeanImpl.setPort(lDAPServerMBeanImpl2.getPort());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                    } else if (string.equals("Principal")) {
                        lDAPServerMBeanImpl.setPrincipal(lDAPServerMBeanImpl2.getPrincipal());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 5);
                    } else if (string.equals("ResultsTimeLimit")) {
                        lDAPServerMBeanImpl.setResultsTimeLimit(lDAPServerMBeanImpl2.getResultsTimeLimit());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("BindAnonymouslyOnReferrals")) {
                        lDAPServerMBeanImpl.setBindAnonymouslyOnReferrals(lDAPServerMBeanImpl2.isBindAnonymouslyOnReferrals());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("CacheEnabled")) {
                        lDAPServerMBeanImpl.setCacheEnabled(lDAPServerMBeanImpl2.isCacheEnabled());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("FollowReferrals")) {
                        lDAPServerMBeanImpl.setFollowReferrals(lDAPServerMBeanImpl2.isFollowReferrals());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("SSLEnabled")) {
                        lDAPServerMBeanImpl.setSSLEnabled(lDAPServerMBeanImpl2.isSSLEnabled());
                        lDAPServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                LDAPServerMBeanImpl lDAPServerMBeanImpl = (LDAPServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy((AbstractDescriptorBean)lDAPServerMBeanImpl, bl, list);
                if ((list == null || !list.contains("CacheSize")) && this.bean.isCacheSizeSet()) {
                    lDAPServerMBeanImpl.setCacheSize(this.bean.getCacheSize());
                }
                if ((list == null || !list.contains("CacheTTL")) && this.bean.isCacheTTLSet()) {
                    lDAPServerMBeanImpl.setCacheTTL(this.bean.getCacheTTL());
                }
                if ((list == null || !list.contains("ConnectTimeout")) && this.bean.isConnectTimeoutSet()) {
                    lDAPServerMBeanImpl.setConnectTimeout(this.bean.getConnectTimeout());
                }
                if ((list == null || !list.contains("ConnectionPoolSize")) && this.bean.isConnectionPoolSizeSet()) {
                    lDAPServerMBeanImpl.setConnectionPoolSize(this.bean.getConnectionPoolSize());
                }
                if ((list == null || !list.contains("ConnectionRetryLimit")) && this.bean.isConnectionRetryLimitSet()) {
                    lDAPServerMBeanImpl.setConnectionRetryLimit(this.bean.getConnectionRetryLimit());
                }
                if ((list == null || !list.contains("CredentialEncrypted")) && this.bean.isCredentialEncryptedSet()) {
                    byte[] byArray = this.bean.getCredentialEncrypted();
                    lDAPServerMBeanImpl.setCredentialEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Host")) && this.bean.isHostSet()) {
                    lDAPServerMBeanImpl.setHost(this.bean.getHost());
                }
                if ((list == null || !list.contains("ParallelConnectDelay")) && this.bean.isParallelConnectDelaySet()) {
                    lDAPServerMBeanImpl.setParallelConnectDelay(this.bean.getParallelConnectDelay());
                }
                if ((list == null || !list.contains("Port")) && this.bean.isPortSet()) {
                    lDAPServerMBeanImpl.setPort(this.bean.getPort());
                }
                if ((list == null || !list.contains("Principal")) && this.bean.isPrincipalSet()) {
                    lDAPServerMBeanImpl.setPrincipal(this.bean.getPrincipal());
                }
                if ((list == null || !list.contains("ResultsTimeLimit")) && this.bean.isResultsTimeLimitSet()) {
                    lDAPServerMBeanImpl.setResultsTimeLimit(this.bean.getResultsTimeLimit());
                }
                if ((list == null || !list.contains("BindAnonymouslyOnReferrals")) && this.bean.isBindAnonymouslyOnReferralsSet()) {
                    lDAPServerMBeanImpl.setBindAnonymouslyOnReferrals(this.bean.isBindAnonymouslyOnReferrals());
                }
                if ((list == null || !list.contains("CacheEnabled")) && this.bean.isCacheEnabledSet()) {
                    lDAPServerMBeanImpl.setCacheEnabled(this.bean.isCacheEnabled());
                }
                if ((list == null || !list.contains("FollowReferrals")) && this.bean.isFollowReferralsSet()) {
                    lDAPServerMBeanImpl.setFollowReferrals(this.bean.isFollowReferrals());
                }
                if ((list == null || !list.contains("SSLEnabled")) && this.bean.isSSLEnabledSet()) {
                    lDAPServerMBeanImpl.setSSLEnabled(this.bean.isSSLEnabled());
                }
                return lDAPServerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

