/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import weblogic.management.utils.GenericMBeanInfoLocalizationHelper;
import weblogic.management.utils.ModelMBeanInfoLocalizationHelper;
import weblogic.management.utils.OpenMBeanInfoLocalizationHelper;

public class MBeanInfoLocalizationHelper {
    public static MBeanInfo localizeMBeanInfo(MBeanInfo mBeanInfo, Locale locale) {
        Descriptor descriptor = mBeanInfo.getDescriptor();
        if (descriptor == null) {
            return mBeanInfo;
        }
        String string = (String)descriptor.getFieldValue("descriptionResourceBundleBaseName");
        if (string == null && MBeanInfoLocalizationHelper.getDefaultResourceBundle(mBeanInfo, locale) == null) {
            return mBeanInfo;
        }
        if (mBeanInfo instanceof ModelMBeanInfo) {
            return ModelMBeanInfoLocalizationHelper.localizeModelMBeanInfo((ModelMBeanInfo)ModelMBeanInfo.class.cast(mBeanInfo), locale);
        }
        if (mBeanInfo instanceof OpenMBeanInfoSupport) {
            return OpenMBeanInfoLocalizationHelper.localizeOpenMBeanInfo((OpenMBeanInfoSupport)OpenMBeanInfoSupport.class.cast(mBeanInfo), locale);
        }
        return GenericMBeanInfoLocalizationHelper.localizeGenericMBeanInfo(mBeanInfo, locale);
    }

    static String getDefaultResourceBundleName(MBeanInfo mBeanInfo) {
        Descriptor descriptor = mBeanInfo.getDescriptor();
        String string = (String)descriptor.getFieldValue("interfaceClassName");
        if (string == null) {
            string = mBeanInfo.getClassName();
        }
        String string2 = string.substring(0, string.lastIndexOf(46) + 1);
        String string3 = string2 + "MBeanDescriptions";
        return string3;
    }

    static String getBaseDefaultResourceKey(MBeanInfo mBeanInfo) {
        Descriptor descriptor = mBeanInfo.getDescriptor();
        String string = (String)descriptor.getFieldValue("interfaceClassName");
        if (string == null) {
            string = mBeanInfo.getClassName();
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1) + ".";
        return string2;
    }

    static ResourceBundle getDefaultResourceBundle(MBeanInfo mBeanInfo, Locale locale) {
        try {
            return ResourceBundle.getBundle(MBeanInfoLocalizationHelper.getDefaultResourceBundleName(mBeanInfo), locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

