/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageLocalizationHelper {
    private Locale locale_ = null;
    private ResourceBundle resourceBundle_ = null;

    public MessageLocalizationHelper(String string, Locale locale) {
        this(string, locale, null);
    }

    public MessageLocalizationHelper(String string, Locale locale, ClassLoader classLoader) {
        this.locale_ = locale;
        this.resourceBundle_ = classLoader != null ? ResourceBundle.getBundle(string, locale, classLoader) : ResourceBundle.getBundle(string, locale, Thread.currentThread().getContextClassLoader());
    }

    public MessageLocalizationHelper(String string) {
        this(string, Locale.getDefault());
    }

    public MessageLocalizationHelper(ResourceBundle resourceBundle, Locale locale) {
        this.locale_ = locale;
        this.resourceBundle_ = resourceBundle;
    }

    public MessageLocalizationHelper(ResourceBundle resourceBundle) {
        this(resourceBundle, Locale.getDefault());
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public final String getLocalizedMessage(String string) {
        return this.resourceBundle_.getString(string);
    }

    public final String getLocalizedMessage(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return this.getLocalizedMessage(string, stringArray);
    }

    public final String getLocalizedMessage(String string, String string2, String string3) {
        String[] stringArray = new String[]{string2, string3};
        return this.getLocalizedMessage(string, stringArray);
    }

    public final String getLocalizedMessage(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string2, string3, string4};
        return this.getLocalizedMessage(string, stringArray);
    }

    public final String getLocalizedMessage(String string, String[] stringArray) {
        String string2 = this.resourceBundle_.getString(string);
        return MessageFormat.format(string2, stringArray);
    }
}

