/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.util.Locale;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.utils.GenericMBeanInfoLocalizationHelper;
import weblogic.management.utils.MBeanInfoLocalizationHelper;

public class ModelMBeanInfoLocalizationHelper {
    private static DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugMBeanLocalization");

    static MBeanInfo localizeModelMBeanInfo(ModelMBeanInfo modelMBeanInfo, Locale locale) {
        String string;
        String string2;
        String string3;
        Descriptor descriptor = null;
        try {
            descriptor = modelMBeanInfo.getMBeanDescriptor();
        }
        catch (MBeanException mBeanException) {
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("ModelMBeanInfoLocalizationHelper.localizeModelMBeanInfo(): : Error getting ModelMBeanInfo Descriptor for:" + modelMBeanInfo);
            }
            return (MBeanInfo)MBeanInfo.class.cast(modelMBeanInfo);
        }
        String string4 = (String)descriptor.getFieldValue("descriptionResourceBundleBaseName");
        if ((string4 == null || string4.length() == 0) && MBeanInfoLocalizationHelper.getDefaultResourceBundle((MBeanInfo)MBeanInfo.class.cast(modelMBeanInfo), locale) != null) {
            string4 = MBeanInfoLocalizationHelper.getDefaultResourceBundleName((MBeanInfo)MBeanInfo.class.cast(modelMBeanInfo));
        }
        if ((string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(descriptor, locale, string4, string2 = (string = MBeanInfoLocalizationHelper.getBaseDefaultResourceKey((MBeanInfo)MBeanInfo.class.cast(modelMBeanInfo))) + "mbean")) == null) {
            string3 = modelMBeanInfo.getDescription();
        }
        descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor((DescriptorRead)DescriptorRead.class.cast(modelMBeanInfo), locale, string4);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = modelMBeanInfo.getAttributes();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = modelMBeanInfo.getConstructors();
        MBeanOperationInfo[] mBeanOperationInfoArray = modelMBeanInfo.getOperations();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = modelMBeanInfo.getNotifications();
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = ModelMBeanInfoLocalizationHelper.localizeModelMBeanAttributes(mBeanAttributeInfoArray, locale, string4, string + "attribute.");
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = ModelMBeanInfoLocalizationHelper.localizeModelMBeanConstructors(mBeanConstructorInfoArray, locale, string4, string + "constructor.");
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = ModelMBeanInfoLocalizationHelper.localizeModelMBeanOperations(mBeanOperationInfoArray, locale, string4, string + "operation.");
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = ModelMBeanInfoLocalizationHelper.localizeModelMBeanNotifications(mBeanNotificationInfoArray, locale, string4, string + "notification.");
        return new ModelMBeanInfoSupport(modelMBeanInfo.getClassName(), string3, modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray, descriptor);
    }

    private static ModelMBeanAttributeInfo[] localizeModelMBeanAttributes(MBeanAttributeInfo[] mBeanAttributeInfoArray, Locale locale, String string, String string2) {
        if (mBeanAttributeInfoArray == null) {
            return null;
        }
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            modelMBeanAttributeInfoArray[i] = ModelMBeanInfoLocalizationHelper.localizeModelMBeanAttribute((ModelMBeanAttributeInfo)ModelMBeanAttributeInfo.class.cast(mBeanAttributeInfoArray[i]), locale, string, string2);
        }
        return modelMBeanAttributeInfoArray;
    }

    static ModelMBeanAttributeInfo localizeModelMBeanAttribute(ModelMBeanAttributeInfo modelMBeanAttributeInfo, Locale locale, String string, String string2) {
        if (modelMBeanAttributeInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(modelMBeanAttributeInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(modelMBeanAttributeInfo.getDescriptor(), locale, string, string2 + modelMBeanAttributeInfo.getName());
        if (string3 == null) {
            string3 = modelMBeanAttributeInfo.getDescription();
        }
        return new ModelMBeanAttributeInfo(modelMBeanAttributeInfo.getName(), modelMBeanAttributeInfo.getType(), string3, modelMBeanAttributeInfo.isReadable(), modelMBeanAttributeInfo.isWritable(), modelMBeanAttributeInfo.isIs(), descriptor);
    }

    private static ModelMBeanConstructorInfo[] localizeModelMBeanConstructors(MBeanConstructorInfo[] mBeanConstructorInfoArray, Locale locale, String string, String string2) {
        if (mBeanConstructorInfoArray == null) {
            return null;
        }
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[mBeanConstructorInfoArray.length];
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            modelMBeanConstructorInfoArray[i] = ModelMBeanInfoLocalizationHelper.localizeModelMBeanConstructor((ModelMBeanConstructorInfo)ModelMBeanConstructorInfo.class.cast(mBeanConstructorInfoArray[i]), locale, string, string2);
        }
        return modelMBeanConstructorInfoArray;
    }

    static ModelMBeanConstructorInfo localizeModelMBeanConstructor(ModelMBeanConstructorInfo modelMBeanConstructorInfo, Locale locale, String string, String string2) {
        if (modelMBeanConstructorInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(modelMBeanConstructorInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(modelMBeanConstructorInfo.getDescriptor(), locale, string, string2 + modelMBeanConstructorInfo.getName());
        if (string3 == null) {
            string3 = modelMBeanConstructorInfo.getDescription();
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = modelMBeanConstructorInfo.getSignature();
        MBeanParameterInfo[] mBeanParameterInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeParameters(mBeanParameterInfoArray, locale, string, string2 + modelMBeanConstructorInfo.getName() + ".");
        return new ModelMBeanConstructorInfo(modelMBeanConstructorInfo.getName(), string3, mBeanParameterInfoArray2, descriptor);
    }

    private static ModelMBeanOperationInfo[] localizeModelMBeanOperations(MBeanOperationInfo[] mBeanOperationInfoArray, Locale locale, String string, String string2) {
        if (mBeanOperationInfoArray == null) {
            return null;
        }
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[mBeanOperationInfoArray.length];
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            modelMBeanOperationInfoArray[i] = ModelMBeanInfoLocalizationHelper.localizeModelMBeanOperation((ModelMBeanOperationInfo)ModelMBeanOperationInfo.class.cast(mBeanOperationInfoArray[i]), locale, string, string2);
        }
        return modelMBeanOperationInfoArray;
    }

    static ModelMBeanOperationInfo localizeModelMBeanOperation(ModelMBeanOperationInfo modelMBeanOperationInfo, Locale locale, String string, String string2) {
        if (modelMBeanOperationInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(modelMBeanOperationInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(modelMBeanOperationInfo.getDescriptor(), locale, string, string2 + modelMBeanOperationInfo.getName());
        if (string3 == null) {
            string3 = modelMBeanOperationInfo.getDescription();
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = modelMBeanOperationInfo.getSignature();
        MBeanParameterInfo[] mBeanParameterInfoArray2 = GenericMBeanInfoLocalizationHelper.localizeParameters(mBeanParameterInfoArray, locale, string, string2 + modelMBeanOperationInfo.getName() + ".");
        return new ModelMBeanOperationInfo(modelMBeanOperationInfo.getName(), string3, mBeanParameterInfoArray2, modelMBeanOperationInfo.getReturnType(), modelMBeanOperationInfo.getImpact(), descriptor);
    }

    private static ModelMBeanNotificationInfo[] localizeModelMBeanNotifications(MBeanNotificationInfo[] mBeanNotificationInfoArray, Locale locale, String string, String string2) {
        if (mBeanNotificationInfoArray == null) {
            return null;
        }
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[mBeanNotificationInfoArray.length];
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            modelMBeanNotificationInfoArray[i] = ModelMBeanInfoLocalizationHelper.localizeModelMBeanNotification((ModelMBeanNotificationInfo)ModelMBeanNotificationInfo.class.cast(mBeanNotificationInfoArray[i]), locale, string, string2);
        }
        return modelMBeanNotificationInfoArray;
    }

    static ModelMBeanNotificationInfo localizeModelMBeanNotification(ModelMBeanNotificationInfo modelMBeanNotificationInfo, Locale locale, String string, String string2) {
        if (modelMBeanNotificationInfo == null) {
            return null;
        }
        Descriptor descriptor = GenericMBeanInfoLocalizationHelper.localizeDescriptor(modelMBeanNotificationInfo, locale, string);
        String string3 = GenericMBeanInfoLocalizationHelper.localizeDescription(modelMBeanNotificationInfo.getDescriptor(), locale, string, string2 + modelMBeanNotificationInfo.getName());
        if (string3 == null) {
            string3 = modelMBeanNotificationInfo.getDescription();
        }
        return new ModelMBeanNotificationInfo(modelMBeanNotificationInfo.getNotifTypes(), modelMBeanNotificationInfo.getName(), string3, descriptor);
    }
}

