/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import weblogic.Home;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.utils.FileUtils;

public final class PDevHelper {
    private static final String UTILS_CONFIG_DIR = "utils" + File.separator + "config";
    private static final String UPGRADE_LAUNCH_JAR = "upgrade-launch.jar";

    public static ClassLoader getPDevClassLoader(ClassLoader classLoader) {
        try {
            File file = new File(PDevHelper.getUpgradeLaunchLocation());
            URL uRL = file.toURI().toURL();
            URL[] uRLArray = new URL[]{uRL};
            return new URLClassLoader(uRLArray, classLoader);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static String addPDevLibraryToClasspath(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2 + System.getProperty("path.separator") + PDevHelper.getUpgradeLaunchLocation();
        return string2;
    }

    private static String getUpgradeLaunchLocation() {
        String string = new File(Home.getFile().getParentFile().getParentFile().getAbsolutePath()).getAbsolutePath();
        String string2 = string + File.separator + UTILS_CONFIG_DIR;
        String string3 = PDevHelper.findUpgradeLaunchJarLocation(string2);
        if (string3 != null) {
            return string3;
        }
        String string4 = new File(Home.getMiddlewareHomePath()).getAbsolutePath();
        string2 = string4 + File.separator + UTILS_CONFIG_DIR;
        string3 = PDevHelper.findUpgradeLaunchJarLocation(string2);
        if (string3 != null) {
            return string3;
        }
        string3 = System.getenv("FMWLAUNCH_CLASSPATH");
        if (string3 != null) {
            return string3;
        }
        return UPGRADE_LAUNCH_JAR;
    }

    private static String findUpgradeLaunchJarLocation(String string) {
        File file = new File(string);
        if (!file.exists() || file.isFile()) {
            return null;
        }
        File file2 = new File(string + File.separator + VersionInfoFactory.getVersionInfo().getMajor() + "." + VersionInfo.theOne().getMinor() + File.separator + UPGRADE_LAUNCH_JAR);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        File[] fileArray = FileUtils.find((File)file, (FileFilter)new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().equals(PDevHelper.UPGRADE_LAUNCH_JAR);
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0].getAbsolutePath();
        }
        return null;
    }
}

