/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.ddinit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.descriptors.Encoding;
import weblogic.marathon.ddinit.ModuleInit;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.FSUtils;

public class EarInit
extends ModuleInit {
    private Descriptor earRoot;
    private ApplicationBean std_dd;
    private Descriptor wlEarRoot;
    private WeblogicApplicationBean wlDD;

    public EarInit(FS fS) {
        super(fS);
    }

    protected void searchForComponents() {
    }

    protected void initDescriptors() {
    }

    private static void printUsage() {
        System.out.println("usage: java weblogic.marathon.ddinit.EarInit <base-directory or jar>");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            EarInit.printUsage();
            System.exit(0);
        }
        String string = stringArray[0];
        FS fS = FS.mount(new File(string));
        EarInit earInit = new EarInit(fS);
        earInit.setVerbose(true);
        earInit.doCmdLineEarInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCmdLineEarInit() throws IOException {
        Object object;
        this.inform("Loading content");
        String[] stringArray = FSUtils.getPaths(this.baseFS, "", "");
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        this.earRoot = editableDescriptorManager.createDescriptorRoot(ApplicationBean.class);
        this.std_dd = (ApplicationBean)this.earRoot.getRootBean();
        this.wlEarRoot = editableDescriptorManager.createDescriptorRoot(WeblogicApplicationBean.class);
        this.wlDD = (WeblogicApplicationBean)this.wlEarRoot.getRootBean();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            object = stringArray[i];
            String string = object;
            if (((String)object).endsWith("/")) continue;
            int n = ((String)object).lastIndexOf(47);
            if (n != -1) {
                string = ((String)object).substring(n + 1);
            }
            if (string.endsWith(".war")) {
                this.verbose("Found WAR archive '" + (String)object + "'");
                object2 = string;
                int n2 = ((String)object2).lastIndexOf(46);
                object2 = ((String)object2).substring(0, n2);
                this.webModule((String)object, (String)object2);
                continue;
            }
            if (string.endsWith(".jar")) {
                object2 = null;
                object2 = this.baseFS.mountNested((String)object);
                try {
                    if (((FS)object2).exists("META-INF/ejb-jar.xml")) {
                        this.verbose("Found EJB archive '" + (String)object + "'");
                        ModuleBean moduleBean = this.std_dd.createModule();
                        moduleBean.setEjb((String)object);
                        continue;
                    }
                    this.baseFS.unmountNested((String)object);
                    continue;
                }
                finally {
                    ((FS)object2).close();
                }
            }
            if (string.endsWith(".rar")) {
                object2 = null;
                object2 = this.baseFS.mountNested((String)object);
                try {
                    if (!((FS)object2).exists("META-INF/ra.xml")) continue;
                    this.verbose("Found JCA archive '" + (String)object + "'");
                    ModuleBean moduleBean = this.std_dd.createModule();
                    moduleBean.setConnector((String)object);
                    continue;
                }
                finally {
                    ((FS)object2).close();
                }
            }
            if (string.equals("ejb-jar.xml") && this.parentPath((String)object, 1).endsWith("META-INF")) {
                object2 = this.parentPath((String)object, 2);
                this.verbose("Found exploded EJB module '" + (String)object2 + "'");
                ModuleBean moduleBean = this.std_dd.createModule();
                moduleBean.setEjb((String)object2);
                continue;
            }
            if (string.equals("web.xml") && this.parentPath((String)object, 1).endsWith("WEB-INF")) {
                object2 = this.parentPath((String)object, 2);
                this.verbose("Found exploded WAR module '" + (String)object2 + "'");
                this.webModule((String)object2, (String)object2);
                continue;
            }
            if (!string.equals("ra.xml") || !this.parentPath((String)object, 1).endsWith("META-INF")) continue;
            object2 = this.parentPath((String)object, 2);
            this.verbose("Found exploded JCA module '" + (String)object2 + "'");
            ModuleBean moduleBean = this.std_dd.createModule();
            moduleBean.setConnector((String)object2);
        }
        FS fS = this.getBaseFS();
        object = new ByteArrayOutputStream();
        this.earRoot.toXML((OutputStream)object);
        fS.put("META-INF/application.xml", ((ByteArrayOutputStream)object).toByteArray());
        ((ByteArrayOutputStream)object).reset();
        this.wlEarRoot.toXML((OutputStream)object);
        fS.put("META-INF/weblogic-application.xml", ((ByteArrayOutputStream)object).toByteArray());
        fS.save();
    }

    private void webModule(String string, String string2) {
        ModuleBean moduleBean = this.std_dd.createModule();
        WebBean webBean = moduleBean.createWeb();
        webBean.setWebUri(string);
        webBean.setContextRoot(string2);
    }

    private String parentPath(String string, int n) {
        int n2;
        if (n <= 0 || string.equals("/") || string.equals("")) {
            return string;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n2 = string.lastIndexOf(47)) < 0) {
            return string;
        }
        string = string.substring(0, n2);
        return this.parentPath(string, --n);
    }

    private String mime2java(String string) {
        String string2 = null;
        string2 = string != null ? Encoding.getIANA2JavaMapping(string) : "UTF8";
        return string2;
    }

    private static void ppp(String string) {
        System.out.println("[EarInit] " + string);
    }
}

