/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.ddinit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.FSFinder;
import weblogic.marathon.fs.FSUtils;
import weblogic.tools.ui.progress.ProgressEvent;
import weblogic.tools.ui.progress.ProgressListener;
import weblogic.tools.ui.progress.ProgressProducer;
import weblogic.utils.classfile.ClassFileBean;
import weblogic.utils.classfile.ClassFileLoader;
import weblogic.utils.classfile.MethodBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;

public abstract class ModuleInit
implements ProgressProducer {
    protected boolean m_verbose = false;
    protected boolean m_silentMode = false;
    protected FS baseFS;
    protected ClassFinder classFinder;
    protected ClassFileLoader cfLoader;
    private GenericClassLoader m_classLoader;
    protected List filesystems = new ArrayList();
    protected List m_classes = new ArrayList();
    private boolean modulesFound;
    protected ProgressListener listener;
    protected ProgressEvent event = new ProgressEvent();
    protected boolean executionCancelled = false;
    private Collection m_errors = new ArrayList();
    private Collection m_smartCompErrors = new ArrayList();

    protected ModuleInit(FS fS) {
        this(fS, true);
    }

    protected ModuleInit(FS fS, boolean bl) {
        this.setBaseFS(fS);
        this.classFinder = this.makeFinder();
        this.cfLoader = new ClassFileLoader(this.classFinder);
        this.cfLoader.setParent(ClassFileLoader.getSystem());
        this.m_classLoader = new GenericClassLoader(this.classFinder);
        this.setProgressListener(new CmdLineListener());
        if (bl) {
            this.loadClasses();
        }
    }

    protected abstract void searchForComponents();

    protected abstract void initDescriptors();

    public void execute() throws Exception {
        this.searchForComponents();
        if (this.getFound()) {
            this.initDescriptors();
            this.writeDescriptors();
        }
    }

    public ClassFileBean getModuleClass(String string) {
        ClassFileBean classFileBean = null;
        for (ClassFileBean classFileBean2 : this.getClasses()) {
            if (!classFileBean2.getName().equals(string)) continue;
            classFileBean = classFileBean2;
            break;
        }
        return classFileBean;
    }

    protected void writeDescriptors() throws IOException {
    }

    protected void warn(String string) {
        if (this.listener != null) {
            this.listener.update(string, 0);
        }
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setSilentMode(boolean bl) {
        this.m_silentMode = bl;
    }

    public boolean isSilentMode() {
        return this.m_silentMode;
    }

    public void setFound(boolean bl) {
        this.modulesFound = bl;
    }

    public boolean getFound() {
        return this.modulesFound;
    }

    public FS getBaseFS() {
        return this.baseFS;
    }

    public void setBaseFS(FS fS) {
        if (this.baseFS != null) {
            try {
                this.baseFS.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.baseFS = fS;
    }

    public List getClasses() {
        return this.m_classes;
    }

    public void setClasses(List list) {
        this.m_classes = list;
    }

    protected String getClassPrefixPath() {
        return "";
    }

    protected ClassFinder makeFinder() {
        this.classFinder = new FSFinder(this.baseFS);
        return this.classFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClasses() {
        if (this.getClasses().size() > 0) {
            return;
        }
        this.m_classes = new ArrayList();
        String[] stringArray = new String[]{};
        try {
            stringArray = FSUtils.getPaths(this.baseFS, this.getClassPrefixPath(), ".class");
        }
        catch (IOException iOException) {
            this.inform("Error while searching for class files in " + this.baseFS.getPath());
            this.inform(iOException.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ClassFileBean classFileBean = null;
            try {
                object = this.baseFS.getEntry(stringArray[i]);
                InputStream inputStream = ((Entry)object).getInputStream();
                try {
                    classFileBean = ClassFileBean.load((InputStream)inputStream);
                    if (classFileBean.getName().indexOf("CMP_RDBMS") > -1 || classFileBean.getName().endsWith("Impl") && classFileBean.getName().indexOf("_") > -1) {
                        continue;
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            object = stringArray[i].substring(0, stringArray[i].indexOf("."));
            if (!((String)(object = ((String)object).replace('/', '.'))).equals(classFileBean.getName())) continue;
            this.m_classes.add(classFileBean);
        }
    }

    private void purgeClasses(List list) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (Class clazz : list) {
            String string = clazz.getName();
            if (-1 == string.indexOf("CMP_RDBMS") && !string.endsWith("Impl")) continue;
            arrayList.add(clazz);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            list.remove(iterator.next());
        }
    }

    private void removeBaseClasses(List list) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (Class clazz : list) {
            for (Class clazz2 : list) {
                if (clazz == clazz2 || !clazz2.isAssignableFrom(clazz)) continue;
                arrayList.add(clazz2);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            list.remove(iterator.next());
        }
    }

    private void dumpList(String string, List list) {
        ModuleInit.ppp("===\n" + string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ModuleInit.ppp("  " + iterator.next());
        }
        ModuleInit.ppp("===");
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public void cancelExecution() {
        this.executionCancelled = true;
    }

    private static void ppp(String string) {
        System.out.println("[ModuleInit] " + string);
    }

    protected void verbose(String string) {
        if (this.m_verbose) {
            this.inform(string);
        }
    }

    public Collection getErrors() {
        return this.m_errors;
    }

    protected void addErrors(Collection collection) {
        this.m_errors.addAll(collection);
    }

    protected void inform(String string) {
        if (!this.m_silentMode) {
            if (this.listener != null) {
                this.listener.update(string);
            } else {
                System.out.println("[ModuleInit]: " + string);
            }
        }
    }

    protected boolean hasMethod(ClassFileBean classFileBean, MethodBean methodBean) {
        MethodBean[] methodBeanArray = classFileBean.getPublicMethods();
        for (int i = 0; i < methodBeanArray.length; ++i) {
            if (!methodBean.equals((Object)methodBeanArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasInterface(ClassFileBean classFileBean, String string) {
        ClassFileBean classFileBean2;
        if (classFileBean == null) {
            return false;
        }
        String[] stringArray = classFileBean.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.equals(stringArray[i])) {
                return true;
            }
            try {
                classFileBean2 = this.cfLoader.loadClass(stringArray[i]);
                if (!this.hasInterface(classFileBean2, string)) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        String string2 = classFileBean.getSuperName();
        if (string2.equals("java.lang.Object")) {
            return false;
        }
        try {
            classFileBean2 = this.cfLoader.loadClass(string2);
            if (classFileBean2 != null) {
                return this.hasInterface(classFileBean2, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private class CmdLineListener
    implements ProgressListener {
        private CmdLineListener() {
        }

        public void updateProgress(ProgressEvent progressEvent) {
        }

        public void update(String string) {
            System.out.println(string);
        }

        public void update(String string, int n) {
        }

        public void setProgressProducer(ProgressProducer progressProducer) {
        }
    }
}

