/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.ddinit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ErrorPageBean;
import weblogic.j2ee.descriptor.FilterBean;
import weblogic.j2ee.descriptor.FilterMappingBean;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WelcomeFileListBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.management.descriptors.webapp.AttributeMBean;
import weblogic.management.descriptors.webapp.TagMBean;
import weblogic.marathon.ddinit.ModuleInit;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.FSUtils;
import weblogic.servlet.internal.dd.TaglibDescriptor;
import weblogic.servlet.jsp.dd.AttributeDescriptor;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.servlet.jsp.dd.TagDescriptor;
import weblogic.utils.StringUtils;
import weblogic.utils.classfile.ClassFileBean;
import weblogic.utils.classfile.MethodBean;

public class WebInit
extends ModuleInit {
    private ArrayList servlets = new ArrayList();
    private List filters = new ArrayList();
    private List listeners = new ArrayList();
    private ArrayList tags = new ArrayList();
    TLDDescriptor tld;
    TaglibDescriptor tagdesc;
    private Descriptor webAppRoot;
    private Descriptor wlWebAppRoot;
    private WebAppBean webApp;
    private WeblogicWebAppBean wlWebApp;
    private static final String SERVLET = "javax.servlet.Servlet";
    private static final String HTTP_SERVLET = "javax.servlet.http.HttpServlet";
    private static final String CONTEXT_LISTENER = "javax.servlet.ServletContextListener";
    private static final String TAG = "javax.servlet.jsp.tagext.Tag";
    private static final String BODY_TAG = "javax.servlet.jsp.tagext.BodyTag";
    private static final String ITER_TAG = "javax.servlet.jsp.tagext.IterationTag";
    private static final String TCF_TAG = "javax.servlet.jsp.tagext.TryCatchFinally";
    private static final String FILTER = "javax.servlet.Filter";
    private static final String TAG_SUPPORT = "javax.servlet.jsp.tagext.TagSupport";
    private static final String BODY_SUPPORT = "javax.servlet.jsp.tagext.BodyTagSupport";

    public WebInit(FS fS) {
        super(fS);
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        this.webAppRoot = editableDescriptorManager.createDescriptorRoot(WebAppBean.class);
        this.webApp = (WebAppBean)this.webAppRoot.getRootBean();
        this.wlWebAppRoot = editableDescriptorManager.createDescriptorRoot(WeblogicWebAppBean.class);
        this.wlWebApp = (WeblogicWebAppBean)this.wlWebAppRoot.getRootBean();
    }

    protected String getClassPrefixPath() {
        return "WEB-INF/classes/";
    }

    private ServletBean getServletDesc(String string) {
        ServletBean servletBean = this.webApp.createServlet();
        servletBean.setServletClass(string);
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)".");
        string = stringArray[stringArray.length - 1];
        servletBean.setServletName(string);
        return servletBean;
    }

    public ServletBean getServletDesc(ClassFileBean classFileBean) {
        String string = classFileBean.getName();
        return this.getServletDesc(string);
    }

    public ServletMappingBean getServletMapping(ServletBean servletBean) {
        ServletMappingBean servletMappingBean = this.webApp.createServletMapping();
        servletMappingBean.setServletName(servletBean.getServletName());
        servletMappingBean.setUrlPatterns(new String[]{"/" + servletBean.getServletName() + "/*"});
        return servletMappingBean;
    }

    protected void initDescriptors() {
        String string;
        int n;
        for (n = 0; n < this.servlets.size(); ++n) {
            string = (String)this.servlets.get(n);
            ServletBean servletBean = this.getServletDesc(string);
            this.getServletMapping(servletBean);
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            string = (String)this.listeners.get(n);
            this.webApp.createListener().setListenerClass(string);
        }
        for (n = 0; n < this.filters.size(); ++n) {
            FilterBean filterBean = this.webApp.createFilter();
            string = (String)this.filters.get(n);
            filterBean.setFilterClass(string);
            int n2 = string.lastIndexOf(46);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            filterBean.setFilterName(string);
            FilterMappingBean filterMappingBean = this.webApp.createFilterMapping();
            filterMappingBean.setFilterName(filterBean.getFilterName());
            filterMappingBean.setUrlPatterns(new String[]{'/' + string + "/*"});
        }
        if (this.tags.size() > 0) {
            this.initTaglib();
        }
        WelcomeFileListBean welcomeFileListBean = this.webApp.createWelcomeFileList();
        welcomeFileListBean.addWelcomeFile("index.jsp");
        welcomeFileListBean.addWelcomeFile("index.html");
        welcomeFileListBean.addWelcomeFile("index.htm");
        if (this.baseFS.exists("error.jsp")) {
            ErrorPageBean errorPageBean = this.webApp.createErrorPage();
            errorPageBean.setExceptionType("java.lang.Exception");
            errorPageBean.setLocation("/error.jsp");
        }
        LoginConfigBean loginConfigBean = this.webApp.createLoginConfig();
        loginConfigBean.setRealmName("WebApp");
        if (this.baseFS.exists("login.jsp")) {
            loginConfigBean.setAuthMethod("FORM");
            loginConfigBean.getFormLoginConfig().setFormLoginPage("/login.jsp");
            loginConfigBean.getFormLoginConfig().setFormErrorPage("/error.jsp");
        } else {
            loginConfigBean.setAuthMethod("BASIC");
        }
    }

    protected void writeDescriptors() throws IOException {
        FS fS = this.getBaseFS();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.webAppRoot.toXML((OutputStream)byteArrayOutputStream);
        fS.put("WEB-INF/web.xml", byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.reset();
        this.wlWebAppRoot.toXML((OutputStream)byteArrayOutputStream);
        fS.put("WEB-INF/weblogic.xml", byteArrayOutputStream.toByteArray());
    }

    public boolean hasJSPsInRoot(FS fS) {
        boolean bl = false;
        try {
            String[] stringArray = FSUtils.getPaths(fS, "", ".jsp", false, true);
            bl = this.hasAPathInRoot(stringArray);
            if (!bl) {
                stringArray = FSUtils.getPaths(fS, "", ".html", false, true);
                bl = this.hasAPathInRoot(stringArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private boolean hasAPathInRoot(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                boolean bl2 = bl = string.indexOf("/") == -1;
                if (bl) break;
            }
        }
        return bl;
    }

    public boolean hasWebInfInRoot(FS fS) {
        boolean bl = false;
        try {
            String[] stringArray = FSUtils.getPaths(fS, "WEB-INF/", "");
            bl = this.hasAPathInRoot(stringArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public boolean hasJSPs(FS fS) {
        boolean bl = false;
        try {
            String[] stringArray = FSUtils.getPaths(fS, "", ".jsp");
            if (stringArray.length != 0) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClasses() {
        if (this.m_classes.size() > 0) {
            return;
        }
        String[] stringArray = new String[]{};
        try {
            this.inform("Searching for classes in " + this.getClassPrefixPath());
            stringArray = FSUtils.getPaths(this.baseFS, this.getClassPrefixPath(), ".class");
        }
        catch (IOException iOException) {
            this.inform("Error while searching for class files in " + this.baseFS.getPath());
            this.inform(iOException.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ClassFileBean classFileBean = null;
            try {
                Entry entry = this.baseFS.getEntry(stringArray[i]);
                InputStream inputStream = entry.getInputStream();
                try {
                    classFileBean = ClassFileBean.load((InputStream)inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            this.m_classes.add(classFileBean);
        }
    }

    private boolean isServlet(ClassFileBean classFileBean) {
        return this.hasInterface(classFileBean, SERVLET);
    }

    private boolean isTag(ClassFileBean classFileBean) {
        return this.hasInterface(classFileBean, TAG);
    }

    protected void searchForComponents() {
        this.setFound(this.hasWebInfInRoot(this.baseFS));
        if (!this.getFound()) {
            this.setFound(this.hasJSPsInRoot(this.baseFS));
        }
        List list = this.getClasses();
        for (ClassFileBean classFileBean : list) {
            if (classFileBean.isAbstract() || !classFileBean.isPublic()) continue;
            if (this.isServlet(classFileBean)) {
                this.verbose("found servlet class: '" + classFileBean.getName() + "'");
                this.servlets.add(classFileBean.getName());
                this.setFound(true);
            }
            if (this.hasInterface(classFileBean, CONTEXT_LISTENER)) {
                this.verbose("found servlet context listener class: '" + classFileBean.getName() + "'");
                this.listeners.add(classFileBean.getName());
                this.setFound(true);
            }
            if (this.isTag(classFileBean)) {
                this.verbose("found JSP tag class: '" + classFileBean.getName() + "'");
                this.tags.add(classFileBean);
                this.setFound(true);
            }
            if (!this.hasInterface(classFileBean, FILTER)) continue;
            this.verbose("found filter class: '" + classFileBean.getName() + "'");
            this.filters.add(classFileBean.getName());
            this.setFound(true);
        }
    }

    private void initTaglib() {
        if (this.tags.size() == 0) {
            return;
        }
        TaglibDescriptor taglibDescriptor = this.tagdesc = new TaglibDescriptor();
        taglibDescriptor.setURI("tags");
        taglibDescriptor.setLocation("/WEB-INF/taglib.tld");
        this.tld = new TLDDescriptor();
        this.tld.set12(true);
        this.tld.setJspVersion("1.2");
        this.tld.setTaglibVersion("1.0.0");
        this.tld.setDisplayName("automatic tags");
        this.tld.setDescription("taglib automatically generated by WebLogic DDInit");
        ClassFileBean[] classFileBeanArray = new ClassFileBean[this.tags.size()];
        this.tags.toArray(classFileBeanArray);
        ArrayList<TagDescriptor> arrayList = new ArrayList<TagDescriptor>();
        for (int i = 0; i < classFileBeanArray.length; ++i) {
            try {
                TagDescriptor tagDescriptor = this.initTD(classFileBeanArray[i]);
                if (tagDescriptor == null) continue;
                arrayList.add(tagDescriptor);
                continue;
            }
            catch (Exception exception) {
                this.verbose("failure analyzing tag class: " + exception);
            }
        }
        TagMBean[] tagMBeanArray = new TagDescriptor[arrayList.size()];
        arrayList.toArray(tagMBeanArray);
        this.tld.setTags(tagMBeanArray);
    }

    private TagDescriptor initTD(ClassFileBean classFileBean) throws Exception {
        int n = classFileBean.getModifiers();
        if (classFileBean.isAbstract()) {
            return null;
        }
        TagDescriptor tagDescriptor = new TagDescriptor();
        tagDescriptor.set12(true);
        String string = classFileBean.getName();
        tagDescriptor.setClassname(string);
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        string = string.toLowerCase();
        tagDescriptor.setName(string);
        ArrayList<AttributeDescriptor> arrayList = new ArrayList<AttributeDescriptor>();
        MethodBean[] methodBeanArray = classFileBean.getPublicMethods();
        for (int i = 0; i < methodBeanArray.length; ++i) {
            String[] stringArray;
            MethodBean methodBean = methodBeanArray[i];
            String string2 = methodBean.getName();
            if (!string2.startsWith("set") || !methodBean.getReturnType().equals("void") || (stringArray = methodBean.getParams()).length != 1 || string2.equals("setPageContext") || string2.equals("setParent") || string2.equals("setBodyContent")) continue;
            AttributeDescriptor attributeDescriptor = new AttributeDescriptor();
            attributeDescriptor.setName(string2.substring(3).toLowerCase());
            attributeDescriptor.setType(stringArray[0]);
            attributeDescriptor.setRequired(false);
            attributeDescriptor.setRtexpr(true);
            arrayList.add(attributeDescriptor);
        }
        AttributeMBean[] attributeMBeanArray = new AttributeDescriptor[arrayList.size()];
        arrayList.toArray(attributeMBeanArray);
        tagDescriptor.setAtts(attributeMBeanArray);
        return tagDescriptor;
    }

    private static void printUsage() {
        System.out.println("usage: java weblogic.marathon.ddinit.WebInit <base-directory or jar>");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            WebInit.printUsage();
            System.exit(0);
        }
        String string = stringArray[0];
        FS fS = FS.mount(new File(string));
        WebInit webInit = new WebInit(fS);
        webInit.execute();
        fS.save();
        fS.close();
        System.out.println("filters=" + webInit.filters.size() + " servlets=" + webInit.servlets.size() + " tags=" + webInit.tags.size());
        for (ClassFileBean classFileBean : webInit.tags) {
            System.err.println(" tag class: " + classFileBean.getName());
        }
    }
}

