/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.IOException;
import java.io.InputStream;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.EntryAddable;
import weblogic.marathon.fs.ZU;

class DirEntry
extends Entry
implements EntryAddable {
    Entry[] children = new Entry[0];

    public String toString() {
        return "[DirEntry path=" + this.getPath() + "]";
    }

    public DirEntry(String string) {
        super(string);
    }

    public Entry[] list() {
        return this.children;
    }

    public void addEntry(Entry entry) {
        if (ZU.containsEntry(this, entry)) {
            return;
        }
        Entry[] entryArray = new Entry[this.children.length + 1];
        System.arraycopy(this.children, 0, entryArray, 0, this.children.length);
        entryArray[this.children.length] = entry;
        this.children = entryArray;
    }

    public InputStream getInputStream() throws IOException {
        throw new IllegalArgumentException("no inputstream from directory");
    }

    public long getTime() {
        return System.currentTimeMillis();
    }
}

