/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.JarFile;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.SplitDirectoryFS;
import weblogic.marathon.fs.StdFS;
import weblogic.marathon.fs.ZipFS;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.JarFileUtils;

public abstract class FS {
    static File marathonTmpDir;
    File root;
    FS parent;
    String path;
    protected Hashtable children = new Hashtable();

    private static void cleanTempArea() {
        String[] stringArray = marathonTmpDir.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(marathonTmpDir, stringArray[i]);
            FileUtils.remove((File)file);
        }
    }

    private static void p(String string) {
        System.err.println("[FS]: " + string);
    }

    protected FS(File file, FS fS, String string) {
        this.root = file;
        this.parent = fS;
        this.path = string;
    }

    public abstract URL getURL(String var1) throws IOException;

    public abstract Entry getEntry(String var1) throws IOException;

    public abstract boolean exists(String var1);

    public FS getParent() {
        return this.parent;
    }

    public File getRoot() {
        return this.root;
    }

    protected void setRoot(File file) {
        this.root = file;
    }

    public String getPath() {
        return this.path;
    }

    public abstract FS mountNested(String var1) throws IOException;

    public void unmountNested(String string) {
    }

    public abstract void put(String var1, byte[] var2) throws IOException;

    public abstract Entry getRootEntry() throws IOException;

    public abstract void save() throws IOException;

    public abstract void close() throws IOException;

    public static FS mount(File file, boolean bl) throws IOException {
        return FS.mountInteral(file, null, bl);
    }

    public static FS mount(File file) throws IOException {
        return FS.mountInteral(file, null, false);
    }

    private static boolean isSplitDir(File file) {
        return new File(file, ".beabuild.txt").exists();
    }

    protected static FS mountInteral(File file, FS fS) throws IOException {
        return FS.mountInteral(file, fS, false);
    }

    protected static FS mountInteral(File file, FS fS, boolean bl) throws IOException {
        Object object;
        String string = null;
        if (fS != null) {
            object = fS.getRoot().getAbsolutePath();
            String string2 = file.getAbsolutePath();
            string = string2.substring(((String)object).length());
        } else {
            string = file.getAbsolutePath();
        }
        if (file.isDirectory()) {
            if (FS.isSplitDir(file)) {
                return new SplitDirectoryFS(file, fS, string);
            }
            return new StdFS(file, fS, string);
        }
        if (FS.isZip(file)) {
            if (file.getPath().endsWith(".ear") && bl) {
                object = FS.explodeEar(file);
                return new StdFS((File)object, null, ((File)object).getAbsolutePath());
            }
            return new ZipFS(file, fS, string);
        }
        throw new IOException(file.getAbsolutePath() + " is neither " + "directory nor zip file");
    }

    private static File explodeEar(File file) throws IOException {
        File file2 = FileUtils.createTempDir((String)"ear", (File)marathonTmpDir);
        JarFile jarFile = new JarFile(file);
        JarFileUtils.extract((JarFile)jarFile, (File)file2);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZip(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = new byte[4];
            if (((InputStream)fileInputStream).read(byArray) != 4) {
                boolean bl = false;
                return bl;
            }
            boolean bl = byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
            return bl;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        switch (Integer.parseInt(stringArray[0])) {
            case 1: {
                FS.test1();
                break;
            }
            case 2: {
                FS.test2();
                break;
            }
            case 3: {
                FS.test3();
                break;
            }
            case 4: {
                FS.test4();
                break;
            }
            case 5: {
                FS.test5();
                break;
            }
            case 6: {
                FS.test6();
                break;
            }
            case 7: {
                FS.test7();
            }
        }
        System.exit(0);
    }

    private static void test1() throws Exception {
        File file = null;
        file = new File("c:/weblogic/dev/sandbox/brown/broken/ear/broken.jar");
        if (!file.exists()) {
            FS.p(file.getAbsolutePath() + " doesn't exist!");
        }
        FS fS = FS.mount(file);
        fS.getEntry("META-INF/");
        FS.recurse(fS.getRootEntry());
    }

    private static void test2() throws Exception {
        int n;
        File file = null;
        file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.jar");
        FS fS = FS.mount(file);
        System.err.println("META-INF/ejb-jar.xml:");
        Entry entry = fS.getEntry("META-INF/ejb-jar.xml");
        InputStream inputStream = entry.getInputStream();
        while ((n = inputStream.read()) != -1) {
            System.err.write(n);
        }
        inputStream.close();
        System.err.flush();
    }

    private static void test3() throws Exception {
        int n;
        File file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.jar");
        FS fS = FS.mount(file);
        String string = "this is some random data\n";
        fS.put("META-INF/subdir/blah.txt", string.getBytes());
        Entry entry = fS.getEntry("META-INF/subdir/blah.txt");
        InputStream inputStream = entry.getInputStream();
        while ((n = inputStream.read()) != -1) {
            System.err.write(n);
        }
        inputStream.close();
        System.err.flush();
        fS.save();
        entry = fS.getEntry("META-INF/subdir/blah.txt");
        inputStream = entry.getInputStream();
        while ((n = inputStream.read()) != -1) {
            System.err.write(n);
        }
        inputStream.close();
        System.err.flush();
        fS.save();
    }

    private static void test4() throws Exception {
        File file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.ear");
        FS fS = FS.mount(file);
        FS fS2 = fS.mountNested("web.war");
        FS.recurse(fS2.getRootEntry());
    }

    private static void test5() throws Exception {
        int n;
        File file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.ear");
        FS fS = FS.mount(file);
        FS fS2 = fS.mountNested("web.war");
        Entry entry = fS2.getEntry("WEB-INF/weblogic.xml");
        InputStream inputStream = entry.getInputStream();
        while ((n = inputStream.read()) != -1) {
            System.err.write(n);
        }
        inputStream.close();
        System.err.flush();
    }

    private static void test6() throws Exception {
        int n;
        File file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.ear");
        FS fS = FS.mount(file);
        FS fS2 = fS.mountNested("web.war");
        fS2.put("WEB-INF/sub/gumby.txt", "Gumby and Pokey sittin' in a tree...".getBytes());
        Entry entry = fS2.getEntry("WEB-INF/sub/gumby.txt");
        System.err.println("before save, type=" + entry.getClass().getName());
        fS.save();
        entry = fS2.getEntry("WEB-INF/sub/gumby.txt");
        System.err.println("after save, type=" + entry.getClass().getName());
        InputStream inputStream = entry.getInputStream();
        while ((n = inputStream.read()) != -1) {
            System.err.write(n);
        }
        inputStream.close();
        System.err.flush();
    }

    private static void test7() throws Exception {
        File file = new File("c:/weblogic/dev/sandbox/brown/broken/broken.ear");
        FS fS = FS.mount(file);
        FS fS2 = fS.mountNested("web.war");
        FS fS3 = fS.mountNested("broken.jar");
        fS.save();
    }

    static void recurse(Entry entry) throws Exception {
        Entry[] entryArray = entry.list();
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        for (int i = 0; i < entryArray.length; ++i) {
            System.err.println(entryArray[i].getPath());
            FS.recurse(entryArray[i]);
        }
    }

    static {
        String string = System.getProperty("marathon.tmpdir");
        if (string == null) {
            String string2;
            string = System.getProperty("java.io.tempdir");
            if (string == null) {
                string = System.getProperty("java.io.tmpdir");
            }
            if (string == null) {
                string2 = System.getProperty("os.name");
                string = string2 != null && string2.toLowerCase().indexOf("windows") != -1 ? "C:\\TEMP" : "/tmp";
            }
            if ((string2 = System.getProperty("user.name")) != null) {
                string = new File(string, string2).getPath();
            }
            marathonTmpDir = new File(string);
            marathonTmpDir = new File(marathonTmpDir, "_wl_mara_tmp");
            marathonTmpDir.mkdirs();
        } else {
            marathonTmpDir = new File(string);
            marathonTmpDir.mkdirs();
        }
        FS.cleanTempArea();
    }
}

