/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.FSSource;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;

public class FSFinder
implements ClassFinder {
    FS[] fs;

    public FSFinder(FS[] fSArray) {
        this.fs = (FS[])fSArray.clone();
    }

    public FSFinder(FS fS) {
        this.fs = new FS[1];
        this.fs[0] = fS;
    }

    public void addFS(FS fS) {
        FS[] fSArray = new FS[this.fs.length + 1];
        System.arraycopy(this.fs, 0, fSArray, 0, this.fs.length);
        fSArray[this.fs.length] = fS;
        this.fs = fSArray;
    }

    public String getClassPath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.fs.length; ++i) {
            stringBuffer.append(this.fs[i].getRoot().getAbsolutePath());
            if (i == this.fs.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public Source getClassSource(String string) {
        String string2 = string.replace('.', '/') + ".class";
        return this.getSource(string2);
    }

    public ClassFinder getManifestFinder() {
        throw new Error("NYI");
    }

    public Enumeration entries() {
        return EmptyEnumerator.EMPTY;
    }

    protected String getPrefixPath() {
        return "";
    }

    public Source getSource(String string) {
        return this.getSourcesInternal(string, null);
    }

    public Enumeration getSources(String string) {
        ArrayList arrayList = new ArrayList();
        this.getSourcesInternal(string, arrayList);
        return new IteratorEnumerator(arrayList.iterator());
    }

    public Source getSourcesInternal(String string, List list) {
        string = string.replace(File.separatorChar, '/');
        string = this.getPrefixPath() + string;
        for (int i = 0; i < this.fs.length; ++i) {
            if (!this.fs[i].exists(string)) continue;
            try {
                Entry entry = this.fs[i].getEntry(string);
                if (list == null) {
                    return new FSSource(this.fs[i], entry);
                }
                list.add(new FSSource(this.fs[i], entry));
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("nested: " + iOException);
            }
        }
        return null;
    }

    public void close() {
    }
}

