/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.EntryAddable;
import weblogic.marathon.fs.ZU;

class JarEntry
extends Entry
implements EntryAddable {
    ZipEntry ze;
    ZipFile zf;
    Entry[] children;

    public String toString() {
        return "[JarEntry path=" + this.getPath() + "]";
    }

    public long getTime() {
        return this.ze.getTime();
    }

    public JarEntry(String string, ZipFile zipFile, ZipEntry zipEntry) {
        super(string);
        this.zf = zipFile;
        this.ze = zipEntry;
        this.children = new Entry[0];
    }

    public void addEntry(Entry entry) {
        if (ZU.containsEntry(this, entry)) {
            return;
        }
        Entry[] entryArray = new Entry[this.children.length + 1];
        System.arraycopy(this.children, 0, entryArray, 0, this.children.length);
        entryArray[this.children.length] = entry;
        this.children = entryArray;
    }

    public String getPath() {
        return ZU.fixPath(super.getPath());
    }

    public Entry[] list() {
        return this.children;
    }

    public InputStream getInputStream() throws IOException {
        return this.zf.getInputStream(this.ze);
    }
}

