/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.NestedZipEntry;
import weblogic.marathon.fs.ZipFS;

class NestedZipFS
extends FS {
    ZipFS parentFS;
    String path;
    Entry root;

    NestedZipFS(File file, ZipFS zipFS, String string, Entry entry) {
        super(file, zipFS, string);
        this.path = string;
        this.parentFS = zipFS;
        this.root = new NestedZipEntry(entry, string);
        if (string.endsWith("/")) {
            this.path = string.substring(0, string.length() - 1);
        }
    }

    static String constructDelegatePath(String string, String string2) {
        if (string2.startsWith("/")) {
            return string + string2;
        }
        return string + "/" + string2;
    }

    public URL getURL(String string) throws IOException {
        String string2 = NestedZipFS.constructDelegatePath(this.path, string);
        return this.parentFS.getURL(string2);
    }

    public Entry getEntry(String string) throws IOException {
        String string2 = NestedZipFS.constructDelegatePath(this.path, string);
        return this.parentFS.getEntry(string2);
    }

    public boolean exists(String string) {
        String string2 = NestedZipFS.constructDelegatePath(this.path, string);
        return this.parentFS.exists(string2);
    }

    public FS mountNested(String string) throws IOException {
        if (!this.exists(string)) {
            throw new IOException("no such path: \"" + string + "\"");
        }
        String string2 = NestedZipFS.constructDelegatePath(this.path, string);
        return this.parentFS.mountNested(string2);
    }

    public void put(String string, byte[] byArray) throws IOException {
        String string2 = NestedZipFS.constructDelegatePath(this.path, string);
        this.parentFS.put(string2, byArray);
    }

    public Entry getRootEntry() throws IOException {
        return this.root;
    }

    public void save() throws IOException {
        if (!this.parentFS.inSave) {
            this.parentFS.save();
        }
    }

    public void close() throws IOException {
        this.parentFS.close();
    }
}

