/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import weblogic.application.SplitDirectoryInfo;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.StdFS;

public final class SplitDirectoryFS
extends FS {
    private final File srcDir;
    private final File outDir;
    private final FS srcFS;
    private final FS outFS;
    private Map links;

    protected SplitDirectoryFS(File file, FS fS, String string) throws IOException {
        super(file, fS, string);
        this.outDir = file;
        File file2 = new File(file, ".beabuild.txt");
        SplitDirectoryInfo splitDirectoryInfo = new SplitDirectoryInfo(file, file2);
        this.srcDir = splitDirectoryInfo.getSrcDir();
        this.srcFS = new StdFS(this.srcDir, fS, string);
        this.outFS = new StdFS(file, fS, string);
        this.links = splitDirectoryInfo.getUriLinks();
    }

    private SplitDirectoryFS(File file, File file2, FS fS, String string) throws IOException {
        super(file2, fS, string);
        this.srcDir = file;
        this.outDir = file2;
        this.srcFS = new StdFS(file, fS, string);
        this.outFS = new StdFS(file2, fS, string);
    }

    public URL getURL(String string) throws IOException {
        String string2 = string.replace('/', File.separatorChar);
        if (this.srcFS.exists(string2)) {
            return new File(this.srcDir, string2).toURL();
        }
        if (this.outFS.exists(string2)) {
            return new File(this.outDir, string2).toURL();
        }
        return null;
    }

    public Entry getEntry(String string) throws IOException {
        if (this.srcFS.exists(string)) {
            return this.srcFS.getEntry(string);
        }
        if (this.outFS.exists(string)) {
            return this.outFS.getEntry(string);
        }
        throw new FileNotFoundException(string);
    }

    public boolean exists(String string) {
        return this.srcFS.exists(string) || this.outFS.exists(string);
    }

    public FS mountNested(String string) throws IOException {
        File file = this.srcDir;
        File file2 = this.outDir;
        String string2 = string.replace('/', File.separatorChar);
        if (!this.exists(string2)) {
            String string3 = this.getLinkedUri(string2);
            if (string3 != null) {
                return new SplitDirectoryFS(new File(string2), new File(string2), this, string3);
            }
            throw new FileNotFoundException(string2);
        }
        return new SplitDirectoryFS(new File(file, string2), new File(file2, string2), this, string);
    }

    private String getLinkedUri(String string) {
        if (this.links == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        for (String string2 : this.links.keySet()) {
            List list = (List)this.links.get(string2);
            if (list == null || !list.contains(file)) continue;
            return string2;
        }
        return null;
    }

    public void put(String string, byte[] byArray) throws IOException {
        if (this.srcFS.exists(string)) {
            this.srcFS.put(string, byArray);
        } else if (this.outFS.exists(string)) {
            this.outFS.put(string, byArray);
        } else {
            this.srcFS.put(string, byArray);
        }
    }

    public Entry getRootEntry() throws IOException {
        return this.outFS.getRootEntry();
    }

    public void save() throws IOException {
        this.srcFS.save();
        this.outFS.save();
    }

    public void close() throws IOException {
        IOException iOException = null;
        try {
            this.srcFS.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.outFS.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

