/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.FileEntry;
import weblogic.marathon.fs.MemoryEntry;

public class StdFS
extends FS {
    private Map memEntries = new HashMap();

    protected StdFS(File file, FS fS, String string) {
        super(file, fS, string);
    }

    public void close() {
    }

    public Entry getEntry(String string) throws IOException {
        Entry entry = (Entry)this.memEntries.get(string = string.replace('/', File.separatorChar));
        if (entry != null) {
            return entry;
        }
        File file = new File(this.getRoot(), string);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return new FileEntry(string, file);
    }

    public URL getURL(String string) throws IOException {
        if (!this.exists(string)) {
            return null;
        }
        string = string.replace('/', File.separatorChar);
        File file = new File(this.getRoot(), string);
        return new URL("file:" + file.getAbsolutePath());
    }

    public boolean exists(String string) {
        if (this.memEntries.get(string = string.replace('/', File.separatorChar)) != null) {
            return true;
        }
        File file = new File(this.getRoot(), string);
        return file.exists();
    }

    public FS mountNested(String string) throws IOException {
        FS fS = (FS)this.children.get(string);
        if (fS != null) {
            return fS;
        }
        File file = new File(this.getRoot(), string);
        return StdFS.mountInteral(file, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Map map = this.memEntries;
        this.memEntries = new HashMap();
        for (String string : map.keySet()) {
            MemoryEntry memoryEntry = (MemoryEntry)map.get(string);
            File file = new File(this.getRoot(), memoryEntry.getPath());
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                ((OutputStream)fileOutputStream).write(memoryEntry.data);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public void put(String string, byte[] byArray) throws IOException {
        string = string.replace('/', File.separatorChar);
        this.memEntries.put(string, new MemoryEntry(string, byArray));
    }

    public Entry getRootEntry() throws IOException {
        return new FileEntry("", this.getRoot());
    }
}

