/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.marathon.fs.DelTree;
import weblogic.marathon.fs.DirEntry;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.EntryAddable;
import weblogic.marathon.fs.FS;
import weblogic.marathon.fs.JarEntry;
import weblogic.marathon.fs.MemoryEntry;
import weblogic.marathon.fs.NestedZipFS;
import weblogic.marathon.fs.ZipRootEntry;
import weblogic.utils.StringUtils;
import weblogic.utils.jars.JarFileUtils;

public class ZipFS
extends FS {
    ZipFile zf;
    ZipRootEntry zre;
    private int myTmpNum;
    private File jarFile;
    private boolean isInternal;
    boolean inSave = false;
    static int tmpcnt;

    protected void finalize() throws Throwable {
        this.close();
    }

    private ZipFS(File file, FS fS, String string, int n) throws IOException {
        super(file, fS, string);
        this.jarFile = file;
        this.isInternal = true;
        this.myTmpNum = n;
        this.init();
    }

    public ZipFS(File file, FS fS, String string) throws IOException {
        super(file, fS, string);
        this.updateTmpNum();
        this.isInternal = false;
        this.copyFile(file, this.jarFile);
        this.init();
    }

    private void updateTmpNum() {
        File file;
        this.myTmpNum = ZipFS.nextTmpNum();
        this.jarFile = file = new File(marathonTmpDir, this.myTmpNum + ".jar");
        if (this.getParent() != null) {
            this.setRoot(this.jarFile);
        }
    }

    private void init() throws IOException {
        ZipEntry[] zipEntryArray;
        long l = System.currentTimeMillis();
        this.zf = new ZipFile(this.jarFile);
        l = System.currentTimeMillis();
        ArrayList<ZipEntry[]> arrayList = new ArrayList<ZipEntry[]>();
        Enumeration<? extends ZipEntry> enumeration = this.zf.entries();
        while (enumeration.hasMoreElements()) {
            zipEntryArray = enumeration.nextElement();
            arrayList.add(zipEntryArray);
        }
        zipEntryArray = new ZipEntry[arrayList.size()];
        arrayList.toArray(zipEntryArray);
        l = System.currentTimeMillis();
        this.populate(zipEntryArray);
        long l2 = System.currentTimeMillis() - l;
    }

    public URL getURL(String string) throws IOException {
        if (!this.exists(string)) {
            return null;
        }
        String string2 = this.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = '/' + string;
        }
        String string3 = string2 + '!' + string;
        return new URL("zip", "", string3);
    }

    public File getJarFile() {
        return this.jarFile;
    }

    private void populate(ZipEntry[] zipEntryArray) throws IOException {
        int n = zipEntryArray.length;
        boolean[] blArray = new boolean[n];
        this.zre = new ZipRootEntry(this.zf);
        HashMap<String, ZipRootEntry> hashMap = new HashMap<String, ZipRootEntry>();
        hashMap.put("", this.zre);
        for (int i = 0; i < n; ++i) {
            ZipEntry zipEntry = zipEntryArray[i];
            String string = zipEntry.getName();
            EntryAddable entryAddable = ZipFS.getParent(string, hashMap);
            Entry entry = null;
            boolean bl = false;
            if (string.endsWith("/")) {
                entry = (Entry)((Object)ZipFS.getDir(string, hashMap));
                bl = true;
            } else {
                entry = new JarEntry(string, this.zf, zipEntry);
            }
            if (bl) continue;
            entryAddable.addEntry(entry);
        }
    }

    private static EntryAddable getDir(String string, Map map) {
        EntryAddable entryAddable = (EntryAddable)map.get(string);
        if (entryAddable == null) {
            entryAddable = new DirEntry(string);
            map.put(string, entryAddable);
            ZipFS.getParent(string, map).addEntry((Entry)((Object)entryAddable));
        }
        return entryAddable;
    }

    private static EntryAddable getParent(String string, Map map) {
        int n = string.length();
        EntryAddable entryAddable = null;
        if (n <= 2) {
            entryAddable = ZipFS.getDir("", map);
        } else {
            int n2 = string.lastIndexOf(47, n - 2);
            String string2 = string.substring(0, n2 + 1);
            entryAddable = ZipFS.getDir(string2, map);
        }
        return entryAddable;
    }

    public Entry getEntry(String string) throws IOException {
        string = string.replace(File.separatorChar, '/');
        Entry entry = this.findEntry(this.zre, string = ZipFS.trimLeadingSlash(string), string);
        if (entry == null) {
            throw new FileNotFoundException(string);
        }
        return entry;
    }

    private static String trimLeadingSlash(String string) {
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    public boolean exists(String string) {
        string = string.replace(File.separatorChar, '/');
        boolean bl = this.findEntry(this.zre, string = ZipFS.trimLeadingSlash(string), string) != null;
        return bl;
    }

    private void p(String string) {
        System.err.println("[ZipFS(" + this.getPath() + ")(tmp=" + this.myTmpNum + ")]: " + string);
    }

    private Entry findEntry(Entry entry, String string, String object) {
        Object[] objectArray;
        String string2 = null;
        string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string + "/";
        Object object2 = object;
        String string3 = object2;
        boolean bl = false;
        if (((String)object).indexOf(47) != -1) {
            objectArray = StringUtils.split((String)object, (char)'/');
            object2 = objectArray[0];
            string3 = (String)object2 + "/";
            object = objectArray[1];
            bl = true;
        }
        if ((objectArray = entry.list()) == null) {
            return null;
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (string.equals(((Entry)objectArray[i]).getPath()) || string2.equals(((Entry)objectArray[i]).getPath())) {
                return objectArray[i];
            }
            String string4 = ((Entry)objectArray[i]).getName();
            if (!((String)object2).equals(string4) && !string3.equals(string4)) continue;
            return bl ? this.findEntry((Entry)objectArray[i], string, (String)object) : objectArray[i];
        }
        return null;
    }

    public FS mountNested(String string) throws IOException {
        int n;
        FS fS = (FS)this.children.get(string);
        if (fS != null) {
            return fS;
        }
        Entry entry = this.getEntry(string);
        if (entry instanceof DirEntry) {
            NestedZipFS nestedZipFS = new NestedZipFS(this.getRoot(), this, string, entry);
            return nestedZipFS;
        }
        int n2 = ZipFS.nextTmpNum();
        File file = new File(marathonTmpDir, n2 + ".jar");
        byte[] byArray = new byte[1024];
        InputStream inputStream = entry.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        ZipFS zipFS = new ZipFS(file, this, string, n2);
        this.children.put(string, zipFS);
        return zipFS;
    }

    public void unmountNested(String string) {
        this.children.remove(string);
    }

    public void close() throws IOException {
        this.zf.close();
        this.jarFile.delete();
    }

    private void remount() throws IOException {
        try {
            this.zf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = this.jarFile;
        this.updateTmpNum();
        File file2 = this.jarFile;
        this.copyFile(file, file2);
        file.delete();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.inSave = true;
        try {
            File file = this.getTmpDir();
            new DelTree(file).run();
            file.mkdirs();
            this.saveSelf_1();
            this.saveChildren();
            this.saveSelf_2();
        }
        finally {
            this.close();
            this.inSave = false;
        }
    }

    private File getTmpDir() {
        File file = new File(marathonTmpDir, "" + this.myTmpNum);
        file.mkdirs();
        return file;
    }

    private void saveChildren() throws IOException {
        if (this.children.size() == 0) {
            return;
        }
        Enumeration enumeration = this.children.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FS fS = (FS)this.children.get(string);
            if (fS instanceof ZipFS) {
                ZipFS zipFS = (ZipFS)fS;
                zipFS.save();
                this.copyFile(zipFS.jarFile, new File(this.getTmpDir(), string.replace('/', File.separatorChar)));
                continue;
            }
            fS.save();
        }
    }

    private void saveSelf_1() throws IOException {
        File file = this.getTmpDir();
        file.mkdirs();
        JarFileUtils.extract((File)this.jarFile, (File)file);
        this.close();
        this.saveMems(file, this.zre);
    }

    private void saveSelf_2() throws IOException {
        JarFileUtils.createJarFileFromDirectory((String)this.jarFile.getAbsolutePath(), (File)this.getTmpDir());
        new DelTree(this.getTmpDir()).run();
        this.remount();
        if (!this.isInternal) {
            this.copyFile(this.jarFile, this.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMems(File file, Entry entry) throws IOException {
        Entry[] entryArray = entry.list();
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i] instanceof MemoryEntry) {
                MemoryEntry memoryEntry = (MemoryEntry)entryArray[i];
                File file2 = new File(file, memoryEntry.getPath().replace('/', File.separatorChar));
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    ((OutputStream)fileOutputStream).write(memoryEntry.data);
                    continue;
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            this.saveMems(file, entryArray[i]);
        }
    }

    private static EntryAddable addable(Entry entry) {
        if (!(entry instanceof EntryAddable)) {
            throw new IllegalArgumentException("not addable: " + entry.getClass().getName());
        }
        return (EntryAddable)((Object)entry);
    }

    public void put(String string, byte[] byArray) throws IOException {
        Entry entry;
        if (this.exists(string) && (entry = this.getEntry(string)) instanceof MemoryEntry) {
            MemoryEntry memoryEntry = (MemoryEntry)entry;
            memoryEntry.data = byArray;
            return;
        }
        entry = this.getParent(string);
        MemoryEntry memoryEntry = new MemoryEntry(string, byArray);
        ZipFS.addable(entry).addEntry(memoryEntry);
    }

    private Entry getParent(String string) throws IOException {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return this.zre;
        }
        String string2 = string.substring(0, n);
        Entry entry = null;
        if (this.exists(string2)) {
            entry = this.getEntry(string2);
        } else {
            entry = this.getParent(string2);
            EntryAddable entryAddable = ZipFS.addable(entry);
            entry = new DirEntry(string2);
            entryAddable.addEntry(entry);
        }
        return entry;
    }

    public Entry getRootEntry() throws IOException {
        return this.zre;
    }

    static synchronized int nextTmpNum() {
        int n = ++tmpcnt;
        return n;
    }

    private void copyFile(File file, File file2) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }
}

