/*
 * Decompiled with CFR 0.152.
 */
package weblogic.marathon.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipFile;
import weblogic.marathon.fs.Entry;
import weblogic.marathon.fs.EntryAddable;
import weblogic.marathon.fs.ZU;

class ZipRootEntry
extends Entry
implements EntryAddable {
    ZipFile zf;
    List l;
    Entry[] entries;

    public ZipRootEntry(ZipFile zipFile) {
        super("");
        this.zf = zipFile;
        this.entries = new Entry[0];
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public Entry[] list() {
        return this.entries;
    }

    public void addEntry(Entry entry) {
        if (ZU.containsEntry(this, entry)) {
            return;
        }
        Entry[] entryArray = new Entry[this.entries.length + 1];
        System.arraycopy(this.entries, 0, entryArray, 0, this.entries.length);
        entryArray[this.entries.length] = entry;
        this.entries = entryArray;
    }

    public InputStream getInputStream() throws IOException {
        throw new IllegalArgumentException("no input for this entry");
    }
}

