/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.messaging.MessageID;
import weblogic.messaging.common.MessageIDFactory;
import weblogic.messaging.common.MessagingUtilities;

public abstract class MessageIDImpl
implements Externalizable,
Comparable,
MessageID {
    static final long serialVersionUID = -1173635685896143247L;
    private static final byte MINVERSION = 1;
    private static final byte WL60_VERSION = 1;
    private static final byte WL61_VERSION = 11;
    private static final byte WL81_VERSION = 12;
    private static final byte MAXVERSION = 12;
    private static final int VERSION_MASK = 63;
    private static final int HAS_DIFFERENTIATOR = 64;
    protected int seed;
    protected long timestamp;
    protected int counter;
    protected int differentiator;

    public MessageIDImpl(MessageIDFactory messageIDFactory) {
        messageIDFactory.initMessageId(this);
    }

    public MessageIDImpl(int n, long l, int n2) {
        this.seed = n;
        this.timestamp = l;
        this.counter = n2;
    }

    public MessageIDImpl(MessageIDImpl messageIDImpl, int n) {
        this.seed = messageIDImpl.seed;
        this.timestamp = messageIDImpl.timestamp;
        this.counter = messageIDImpl.counter;
        this.differentiator = n;
    }

    void init(int n, long l, int n2) {
        this.seed = n;
        this.timestamp = l;
        this.counter = n2;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setDifferentiator(int n) {
        this.differentiator = n;
    }

    public int getDifferentiator() {
        return this.differentiator;
    }

    public MessageIDImpl() {
    }

    private int getStreamVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_81) < 0) {
            return 11;
        }
        return 12;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getStreamVersion(objectOutput);
        if (n >= 12 && this.differentiator != 0) {
            n |= 0x40;
        }
        objectOutput.writeByte((byte)n);
        objectOutput.writeLong(this.timestamp);
        objectOutput.writeInt(this.counter);
        objectOutput.writeInt(this.seed);
        if ((n & 0x40) != 0) {
            objectOutput.writeInt(this.differentiator);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        int n = by & 0x3F;
        if (n == 12 || n == 11) {
            this.timestamp = objectInput.readLong();
            this.counter = objectInput.readInt();
            this.seed = objectInput.readInt();
            if ((by & 0x40) != 0) {
                this.differentiator = objectInput.readInt();
            }
        } else if (n == 1) {
            this.timestamp = objectInput.readLong();
            this.counter = objectInput.readInt();
            objectInput.readInt();
            this.seed = objectInput.readInt();
        } else {
            throw MessagingUtilities.versionIOException(n, 1, 12);
        }
    }

    public boolean equals(Object object) {
        MessageIDImpl messageIDImpl = (MessageIDImpl)object;
        return this.timestamp == messageIDImpl.timestamp && this.counter == messageIDImpl.counter && this.seed == messageIDImpl.seed;
    }

    public boolean differentiatedEquals(Object object) {
        return this.equals(object) && this.differentiator == ((MessageIDImpl)object).differentiator;
    }

    public int compare(MessageIDImpl messageIDImpl) {
        if (this.timestamp > messageIDImpl.timestamp) {
            return 1;
        }
        if (this.timestamp < messageIDImpl.timestamp) {
            return -1;
        }
        if (this.counter > messageIDImpl.counter) {
            return 1;
        }
        if (this.counter < messageIDImpl.counter) {
            return -1;
        }
        if (this.seed > messageIDImpl.seed) {
            return 1;
        }
        if (this.seed < messageIDImpl.seed) {
            return -1;
        }
        if (this.differentiator > messageIDImpl.differentiator) {
            return 1;
        }
        if (this.differentiator < messageIDImpl.differentiator) {
            return -1;
        }
        return 0;
    }

    public int compareTime(MessageIDImpl messageIDImpl) {
        if (this.timestamp < messageIDImpl.timestamp) {
            return -1;
        }
        if (this.timestamp > messageIDImpl.timestamp) {
            return 1;
        }
        if (this.counter < messageIDImpl.counter) {
            return -1;
        }
        if (this.counter > messageIDImpl.counter) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        try {
            return this.compare((MessageIDImpl)object);
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
    }

    public String toString() {
        return "<" + this.seed + "." + this.timestamp + "." + this.counter + ">";
    }

    public int hashCode() {
        return (int)((long)this.seed ^ this.timestamp ^ (long)this.counter);
    }

    public int differentiatedHashCode() {
        return this.hashCode() ^ this.differentiator;
    }
}

