/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.common;

import java.io.StreamCorruptedException;
import java.security.SecureRandom;
import weblogic.messaging.MessagingLogger;

public class MessagingUtilities {
    public static StreamCorruptedException versionIOException(int n, int n2, int n3) {
        return new StreamCorruptedException(MessagingLogger.logUnsupportedClassVersionLoggable((int)n, (int)n2, (int)n3).getMessage());
    }

    public static final int calcObjectSize(Object object) {
        if (object == null) {
            return 2;
        }
        if (object instanceof Integer) {
            return 6;
        }
        if (object instanceof String) {
            return 4 + (((String)object).length() << 2);
        }
        if (object instanceof Long) {
            return 10;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof Byte) {
            return 3;
        }
        if (object instanceof Short) {
            return 4;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 10;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length + 6;
        }
        return 0;
    }

    public static final int getSeed() {
        int n = 0;
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[4];
        secureRandom.nextBytes(byArray);
        for (int i = 0; i < 4; ++i) {
            n = n << 4 | byArray[i] & 0xFF;
        }
        return n;
    }
}

