/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.common;

import java.io.StreamCorruptedException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.WLContext;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.messaging.MessagingLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;

public class PrivilegedActionUtilities {
    public static void register(RuntimeMBeanDelegate runtimeMBeanDelegate, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        final RuntimeMBeanDelegate runtimeMBeanDelegate2 = runtimeMBeanDelegate;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    runtimeMBeanDelegate2.register();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ManagementException)((Object)privilegedActionException.getException());
        }
    }

    public static void unregister(RuntimeMBeanDelegate runtimeMBeanDelegate, AuthenticatedSubject authenticatedSubject) throws ManagementException {
        final RuntimeMBeanDelegate runtimeMBeanDelegate2 = runtimeMBeanDelegate;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    runtimeMBeanDelegate2.unregister();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ManagementException)((Object)privilegedActionException.getException());
        }
    }

    public static void bindAsSU(Context context, String string, Object object, AuthenticatedSubject authenticatedSubject) throws NamingException {
        final Context context2 = context;
        final String string2 = string;
        final Object object2 = object;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context2.bind(string2, object2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof NamingException) {
                throw (NamingException)throwable;
            }
            throw new NamingException(privilegedActionException.toString());
        }
    }

    public static void unbindAsSU(Context context, String string, AuthenticatedSubject authenticatedSubject) throws NamingException {
        final Context context2 = context;
        final String string2 = string;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context2.unbind(string2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof NamingException) {
                throw (NamingException)throwable;
            }
            throw new NamingException(privilegedActionException.toString());
        }
    }

    public static void unbindAsSU(Context context, String string, Object object, AuthenticatedSubject authenticatedSubject) throws NamingException {
        final Context context2 = context;
        final String string2 = string;
        final Object object2 = object;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    ((WLContext)context2).unbind(string2, object2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new NamingException(privilegedActionException.toString());
        }
    }

    public static void rebindAsSU(Context context, String string, Object object, AuthenticatedSubject authenticatedSubject) throws NamingException {
        final Context context2 = context;
        final String string2 = string;
        final Object object2 = object;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    if (object2 instanceof Aggregatable) {
                        ((WLContext)context2).rebind(string2, object2, object2);
                    } else {
                        context2.rebind(string2, object2);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new NamingException(privilegedActionException.toString());
        }
    }

    public static StreamCorruptedException versionIOException(int n, int n2, int n3) {
        return new StreamCorruptedException(MessagingLogger.logUnsupportedClassVersionLoggable((int)n, (int)n2, (int)n3).getMessage());
    }

    public static final int calcObjectSize(Object object) {
        if (object == null) {
            return 2;
        }
        if (object instanceof Integer) {
            return 6;
        }
        if (object instanceof String) {
            return 4 + (((String)object).length() << 2);
        }
        if (object instanceof Long) {
            return 10;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof Byte) {
            return 3;
        }
        if (object instanceof Short) {
            return 4;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 10;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length + 6;
        }
        return 0;
    }
}

