/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import weblogic.messaging.common.CompiledSQLExpression;
import weblogic.messaging.common.SQLExpression;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.Filter;
import weblogic.messaging.kernel.InvalidExpressionException;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Sink;
import weblogic.utils.concurrent.locks.NonRecursiveReadWriteLock;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.ExpressionParser;
import weblogic.utils.expressions.ExpressionParserException;
import weblogic.utils.expressions.VariableBinder;

public class SQLFilter
implements Filter {
    protected final Map subscribers = new LinkedHashMap();
    protected final NonRecursiveReadWriteLock lock = new NonRecursiveReadWriteLock();
    protected Kernel kernel;
    protected VariableBinder variableBinder;

    public SQLFilter(Kernel kernel, VariableBinder variableBinder) {
        this.kernel = kernel;
        this.variableBinder = variableBinder;
    }

    public Expression createExpression(Object object) throws KernelException {
        try {
            SQLExpression sQLExpression = (SQLExpression)object;
            if (sQLExpression.isNull()) {
                return null;
            }
            return new Exp(this.variableBinder, sQLExpression);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidExpressionException("Invalid expression class: " + object.getClass().getName());
        }
    }

    public void subscribe(Sink sink, Expression expression) {
        CompiledSQLExpression compiledSQLExpression = (CompiledSQLExpression)expression;
        this.lock.lockWrite();
        this.subscribers.put(sink, compiledSQLExpression);
        this.lock.unlockWrite();
    }

    public void unsubscribe(Sink sink) {
        this.lock.lockWrite();
        this.subscribers.remove(sink);
        this.lock.unlockWrite();
    }

    public synchronized void resubscribe(Sink sink, Expression expression) {
        this.unsubscribe(sink);
        this.subscribe(sink, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection match(MessageElement messageElement) {
        Map.Entry entry2;
        ArrayList arrayList = new ArrayList();
        this.lock.lockRead();
        try {
            for (Map.Entry entry2 : this.subscribers.entrySet()) {
                CompiledSQLExpression compiledSQLExpression = (CompiledSQLExpression)entry2.getValue();
                if (compiledSQLExpression != null && !compiledSQLExpression.evaluate(messageElement)) continue;
                arrayList.add(entry2.getKey());
            }
            entry2 = arrayList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.unlockRead();
            throw throwable;
        }
        this.lock.unlockRead();
        return entry2;
    }

    public boolean match(MessageElement messageElement, Expression expression) {
        if (expression == null) {
            return true;
        }
        CompiledSQLExpression compiledSQLExpression = (CompiledSQLExpression)expression;
        try {
            return compiledSQLExpression.evaluate(messageElement);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private final class Exp
    implements CompiledSQLExpression {
        private weblogic.utils.expressions.Expression wlExp;

        Exp(VariableBinder variableBinder, SQLExpression sQLExpression) throws KernelException {
            String string = sQLExpression.getSelector();
            if (string != null) {
                try {
                    ExpressionParser expressionParser = new ExpressionParser();
                    this.wlExp = expressionParser.parse(string, variableBinder);
                }
                catch (ExpressionParserException expressionParserException) {
                    throw new InvalidExpressionException(string);
                }
            }
        }

        public Filter getFilter() {
            return SQLFilter.this;
        }

        public boolean evaluate(MessageElement messageElement) {
            if (this.wlExp != null) {
                try {
                    return this.wlExp.evaluate((Object)messageElement);
                }
                catch (ExpressionEvaluationException expressionEvaluationException) {
                    return false;
                }
            }
            return true;
        }

        public String getSelectorID() {
            return this.wlExp == null ? null : this.wlExp.getSelectorID();
        }
    }
}

