/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.CrossDomainManager;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherWrapper;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.work.WorkManager;

public class DispatcherManager {
    public static final String SERVER_PREFIX = "weblogic.messaging.dispatcher.S:";
    private static final HashMap dispatchers = new HashMap();
    private static Dispatcher localDispatcher;

    private DispatcherManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dispatcher createLocalDispatcher(String string, String string2, WorkManager workManager, WorkManager workManager2, String string3) {
        DispatcherId dispatcherId = new DispatcherId(string, string2);
        DispatcherImpl dispatcherImpl = new DispatcherImpl(string, dispatcherId, workManager, workManager2, string3);
        Class<DispatcherManager> clazz = DispatcherManager.class;
        synchronized (DispatcherManager.class) {
            localDispatcher = dispatcherImpl;
            dispatchers.put(dispatcherId, dispatcherImpl);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return dispatcherImpl;
        }
    }

    public static Dispatcher dispatcherFindOrCreate(DispatcherId dispatcherId) throws DispatcherException {
        try {
            return DispatcherManager.dispatcherFind(dispatcherId);
        }
        catch (DispatcherException dispatcherException) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                throw new DispatcherException(namingException.getMessage(), namingException);
            }
            return DispatcherManager.dispatcherCreate(initialContext, dispatcherId, true);
        }
    }

    public static Dispatcher dispatcherFindOrCreate(Context context, DispatcherId dispatcherId) throws DispatcherException {
        return DispatcherManager.dispatcherCreate(context, dispatcherId, false);
    }

    public static void export(Dispatcher dispatcher) {
        if (dispatcher instanceof DispatcherImpl) {
            ((DispatcherImpl)dispatcher).export();
        }
    }

    public static void unexport(Dispatcher dispatcher) {
        if (KernelStatus.isServer()) {
            return;
        }
        if (dispatcher instanceof DispatcherImpl) {
            ((DispatcherImpl)dispatcher).unexport();
        }
    }

    public static String getHostAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "UNKNOWN";
        }
    }

    public static long generateRandomLong() {
        SecureRandom secureRandom = new SecureRandom();
        return secureRandom.nextLong();
    }

    public static Dispatcher addDispatcherReference(DispatcherWrapper dispatcherWrapper) throws DispatcherException {
        if (!KernelStatus.isServer() || CrossDomainManager.getCrossDomainUtil().isRemoteDomain(dispatcherWrapper)) {
            DispatcherWrapperState dispatcherWrapperState = new DispatcherWrapperState(dispatcherWrapper);
            return dispatcherWrapperState;
        }
        try {
            Dispatcher dispatcher = DispatcherManager.dispatcherFind(dispatcherWrapper.getId());
            if (dispatcher instanceof DispatcherWrapperState) {
                ((DispatcherWrapperState)dispatcher).addRefCount();
            }
            return dispatcher;
        }
        catch (DispatcherException dispatcherException) {
            return DispatcherManager.dispatcherAdd(dispatcherWrapper, true);
        }
    }

    public static boolean isLocal(DispatcherWrapper dispatcherWrapper) {
        if (CrossDomainManager.getCrossDomainUtil().isRemoteDomain(dispatcherWrapper)) {
            return false;
        }
        DispatcherId dispatcherId = dispatcherWrapper.getId();
        return dispatcherId.getId() == null && localDispatcher.getId().getName().equals(dispatcherId.getName()) || localDispatcher.getId().equals(dispatcherId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void removeDispatcherReference(Dispatcher dispatcher, boolean bl) {
        if (!(dispatcher instanceof DispatcherWrapperState)) return;
        DispatcherWrapperState dispatcherWrapperState = (DispatcherWrapperState)dispatcher;
        if (dispatcherWrapperState.removeRefCount() && !bl) {
            return;
        }
        if (localDispatcher.getId().equals(dispatcher.getId())) {
            return;
        }
        dispatcherWrapperState.deleteNotify();
        Class<DispatcherManager> clazz = DispatcherManager.class;
        synchronized (DispatcherManager.class) {
            dispatchers.remove(dispatcher.getId());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dispatcher dispatcherFind(DispatcherId dispatcherId) throws DispatcherException {
        Class<DispatcherManager> clazz = DispatcherManager.class;
        synchronized (DispatcherManager.class) {
            if (dispatcherId == null) {
                throw new DispatcherException("Dispatcher not found: " + dispatcherId);
            }
            if (dispatcherId.getId() == null && localDispatcher.getId().getName().equals(dispatcherId.getName()) || localDispatcher.getId().equals(dispatcherId)) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return localDispatcher;
            }
            Dispatcher dispatcher = (Dispatcher)dispatchers.get(dispatcherId);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (dispatcher == null) {
                throw new DispatcherException("Dispatcher not found: " + dispatcherId);
            }
            return dispatcher;
        }
    }

    private static Dispatcher dispatcherCreate(Context context, DispatcherId dispatcherId, boolean bl) throws DispatcherException {
        DispatcherWrapper dispatcherWrapper;
        try {
            dispatcherWrapper = (DispatcherWrapper)context.lookup(SERVER_PREFIX + dispatcherId);
        }
        catch (NamingException namingException) {
            DispatcherException dispatcherException = new DispatcherException("could not find Server " + dispatcherId);
            dispatcherException.initCause(namingException);
            throw dispatcherException;
        }
        return DispatcherManager.dispatcherAdd(dispatcherWrapper, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Dispatcher dispatcherAdd(DispatcherWrapper dispatcherWrapper, boolean bl) throws DispatcherException {
        if (DispatcherManager.isLocal(dispatcherWrapper)) {
            return localDispatcher;
        }
        DispatcherWrapperState dispatcherWrapperState = new DispatcherWrapperState(dispatcherWrapper);
        if (!bl) return dispatcherWrapperState;
        Class<DispatcherManager> clazz = DispatcherManager.class;
        synchronized (DispatcherManager.class) {
            dispatchers.put(dispatcherWrapperState.getId(), dispatcherWrapperState);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return dispatcherWrapperState;
        }
    }
}

