/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import weblogic.jms.common.JMSDebug;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public abstract class DispatcherObjectHandler {
    protected int MASK;

    protected DispatcherObjectHandler(int n) {
        this.MASK = n;
    }

    public void writeRequest(ObjectOutput objectOutput, Request request) throws IOException {
        objectOutput.writeInt(request.getMethodId());
        request.writeShortened(objectOutput);
    }

    public Request readRequest(int n, ObjectInput objectInput, ID iD) throws ClassNotFoundException, IOException {
        Request request = this.instantiate(n & this.MASK);
        try {
            request.readExternal(objectInput);
        }
        catch (IOException iOException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, iD, null, iOException);
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, iD, null, classNotFoundException);
            }
            throw classNotFoundException;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("RecvReq  ", (byte)15, request, -1, iD, null, null);
        }
        request.setMethodId(n);
        request.setInvocableId(iD);
        return request;
    }

    static void debugWireOperation(String string, byte by, Request request, int n, ID iD, Response response, Throwable throwable) {
        String string2 = n == 0 || n == -1 ? "" : "workId " + Integer.toString(n) + " ";
        String string3 = 15 == by ? "" : ", requestType x" + Integer.toHexString(by).toUpperCase();
        String string4 = response == null ? "" : ", Response " + response.getClass().getName();
        String string5 = string + string2 + string3 + ", ID " + iD + ", " + request.getClass().getName() + string4;
        if (throwable == null) {
            JMSDebug.JMSDispatcher.debug(string5);
        } else {
            JMSDebug.JMSDispatcher.debug(string5, throwable);
        }
    }

    public void writeResponse(ObjectOutput objectOutput, Request request, Response response) throws IOException {
        try {
            objectOutput.writeInt(request.getMethodId() & this.MASK);
            response.writeExternal(objectOutput);
        }
        catch (IOException iOException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, request, -1, request.getInvocableId(), response, iOException);
            }
            throw iOException;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, request, -1, request.getInvocableId(), response, null);
        }
    }

    public Response readResponse(ObjectInput objectInput, Request request) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        if (n != (request.getMethodId() & this.MASK)) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException("Unexpected response for " + request.getClass().getName() + " : " + n);
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), null, streamCorruptedException);
            }
            throw streamCorruptedException;
        }
        Response response = request.createResponse();
        try {
            response.readExternal(objectInput);
        }
        catch (IOException iOException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, iOException);
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, classNotFoundException);
            }
            throw classNotFoundException;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), response, null);
        }
        return response;
    }

    protected Request instantiate(int n) throws IOException {
        throw new StreamCorruptedException("Unknown typecode: " + n);
    }

    static DispatcherObjectHandler load(String string) {
        try {
            return (DispatcherObjectHandler)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

