/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import weblogic.common.WLObjectInput;
import weblogic.jms.common.JMSDebug;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherObjectHandler;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.MessagingEnvironment;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RequestStream;
import weblogic.rjvm.ResponseListener;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorList;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.SmartStubInfo;
import weblogic.rmi.spi.AsyncCallback;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.socket.UnrecoverableConnectException;

public class DispatcherProxy
implements DispatcherRemote,
DispatcherOneWay,
Externalizable,
SmartStubInfo {
    static final long serialVersionUID = 6780111363122647296L;
    private static final byte RT_ONEWAY = 1;
    private static final byte RT_ASYNC = 2;
    private static final byte RT_TRANSACTIONAL = 4;
    private static final byte RT_INVOCABLE_ID = 8;
    static final byte RT_WORK_ID = 16;
    private static boolean disconnectMonitorInitialized;
    private int oid;
    private JVMID hostID;
    private RJVM rjvm;
    private String objectHandlerClassName;
    private DispatcherObjectHandler objectHandler;
    private transient boolean hostReachable = true;

    public DispatcherProxy() {
        DispatcherProxy.initializeDisconnectMonitorImpl();
    }

    public DispatcherProxy(int n, HostID hostID, String string) {
        this();
        this.oid = n;
        this.hostID = (JVMID)hostID;
        this.objectHandlerClassName = string;
        this.objectHandler = DispatcherObjectHandler.load(string);
    }

    private static synchronized void initializeDisconnectMonitorImpl() {
        if (!disconnectMonitorInitialized) {
            DisconnectMonitorList disconnectMonitorList = DisconnectMonitorListImpl.getDisconnectMonitorList();
            disconnectMonitorList.addDisconnectMonitor((DisconnectMonitorProvider)new DispatcherProxyDisconnectMonitorImpl());
            disconnectMonitorInitialized = true;
        }
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)2, request);
        requestStream.sendAsync(this.oid, (ResponseListener)new DispatcherResponseListener(false, (AsyncCallback)asyncResult, request, this.objectHandler));
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)6, request);
        requestStream.sendAsync(this.oid, (ResponseListener)new DispatcherResponseListener(true, (AsyncCallback)asyncResult, request, this.objectHandler));
    }

    public Response dispatchSyncFuture(Request request) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)0, request);
        return this.unmarshalResponse(false, request, requestStream.sendRecv(this.oid));
    }

    public Response dispatchSyncNoTranFuture(Request request) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)0, request);
        return this.unmarshalResponse(false, request, requestStream.sendRecv(this.oid));
    }

    public Response dispatchSyncTranFuture(Request request) throws RemoteException, DispatcherException {
        RequestStream requestStream = this.marshal((byte)4, request);
        return this.unmarshalResponse(true, request, requestStream.sendRecv(this.oid));
    }

    public Response dispatchSyncTranFutureWithId(Request request, int n) throws RemoteException, DispatcherException {
        RequestStream requestStream = this.marshal((byte)4, request, n);
        return this.unmarshalResponse(true, request, requestStream.sendRecv(this.oid));
    }

    public void dispatchOneWay(Request request) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)1, request);
        requestStream.sendOneWay(this.oid, (byte)101);
    }

    public void dispatchOneWayWithId(Request request, int n) throws RemoteException {
        RequestStream requestStream = this.marshal((byte)1, request, n);
        requestStream.sendOneWay(this.oid, (byte)101);
    }

    public RJVM getRJVM() {
        if (this.rjvm == null || this.rjvm.isDead()) {
            this.rjvm = RJVMManager.getRJVMManager().findOrCreate(this.hostID);
        }
        return this.rjvm;
    }

    private RequestStream marshal(byte by, Request request) throws RemoteException {
        return this.marshal(by, request, 0);
    }

    private RequestStream marshal(byte by, Request request, int n) throws RemoteException {
        Interceptor interceptor;
        MsgAbbrevOutputStream msgAbbrevOutputStream;
        if (!this.hostReachable) {
            throw new ConnectException("Unable to reach host");
        }
        RJVM rJVM = this.getRJVM();
        try {
            msgAbbrevOutputStream = rJVM.getRequestStream(null);
        }
        catch (UnrecoverableConnectException unrecoverableConnectException) {
            this.hostReachable = false;
            throw new ConnectException("Unable to reach host");
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        if (DispatcherProxy.isTransactional(by)) {
            interceptor = InterceptorManager.getManager().getTransactionInterceptor();
            if (interceptor != null) {
                msgAbbrevOutputStream.setTxContext(interceptor.sendRequest((Object)rJVM));
            }
            try {
                msgAbbrevOutputStream.marshalCustomCallData();
            }
            catch (IOException iOException) {
                throw new MarshalException("failed to marshal : " + request, iOException);
            }
        }
        if ((interceptor = request.getInvocableId()) != null) {
            by = (byte)(by | 8);
        }
        if (n > 0) {
            by = (byte)(by | 0x10);
        }
        try {
            msgAbbrevOutputStream.writeByte((int)by);
            if (n > 0) {
                msgAbbrevOutputStream.writeInt(n);
            }
            if (interceptor != null) {
                interceptor.writeExternal((ObjectOutput)msgAbbrevOutputStream);
            }
            this.objectHandler.writeRequest((ObjectOutput)msgAbbrevOutputStream, request);
        }
        catch (IOException iOException) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("SendReq  ", by, request, n, (ID)interceptor, null, iOException);
            }
            throw new MarshalException("failed to marshal : " + request, iOException);
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            DispatcherObjectHandler.debugWireOperation("SendReq  ", by, request, n, (ID)interceptor, null, null);
        }
        return msgAbbrevOutputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response unmarshalResponse(boolean bl, Request request, weblogic.rjvm.Response response) throws RemoteException {
        Response response2;
        Throwable throwable;
        InboundResponse inboundResponse = (InboundResponse)response;
        try {
            inboundResponse.retrieveThreadLocalContext();
        }
        catch (IOException iOException) {
            throw new UnmarshalException("failed to unmarshal response", iOException);
        }
        if (bl) {
            try {
                throwable = InterceptorManager.getManager().getTransactionInterceptor();
                if (throwable != null) {
                    throwable.receiveResponse(response.getTxContext());
                }
            }
            catch (RemoteException remoteException) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) throw remoteException;
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), null, remoteException);
                throw remoteException;
            }
        }
        if ((throwable = response.getThrowable()) != null) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                DispatcherObjectHandler.debugWireOperation("RecvResp ", (byte)15, request, -1, request.getInvocableId(), null, throwable);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof RemoteException)) throw new RemoteRuntimeException(throwable);
            throw (RemoteException)throwable;
        }
        WLObjectInput wLObjectInput = response.getMsg();
        try {
            try {
                response2 = this.objectHandler.readResponse((ObjectInput)wLObjectInput, request);
                Object var9_12 = null;
            }
            catch (IOException iOException) {
                throw new UnmarshalException("failed to unmarshal response", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnmarshalException("failed to unmarshal response", classNotFoundException);
            }
        }
        catch (Throwable throwable2) {
            Object var9_13 = null;
            try {
                wLObjectInput.close();
                throw throwable2;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        wLObjectInput.close();
        return response2;
    }

    static boolean isOneWay(int n) {
        return (n & 1) != 0;
    }

    static boolean isAsync(int n) {
        return (n & 2) != 0;
    }

    static boolean isTransactional(int n) {
        return (n & 4) != 0;
    }

    static boolean hasInvocableID(int n) {
        return (n & 8) != 0;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.oid);
        objectOutput.writeObject(this.hostID);
        objectOutput.writeUTF("weblogic.jms.dispatcher.DispatcherObjectHandler");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.oid = objectInput.readInt();
        this.hostID = (JVMID)objectInput.readObject();
        String string = objectInput.readUTF();
        try {
            this.objectHandler = DispatcherObjectHandler.load(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (!MessagingEnvironment.getMessagingEnvironment().isServer()) {
                this.objectHandler = DispatcherObjectHandler.load("weblogic.jms.dispatcher.FEDispatcherObjectHandler");
            }
            throw noClassDefFoundError;
        }
        catch (AssertionError assertionError) {
            if (!MessagingEnvironment.getMessagingEnvironment().isServer()) {
                this.objectHandler = DispatcherObjectHandler.load("weblogic.jms.dispatcher.FEDispatcherObjectHandler");
            }
            throw assertionError;
        }
    }

    public Object getSmartStub(Object object) {
        return this;
    }

    private static final class InboundResponseWrapper
    implements InboundResponse {
        private final InboundResponse inboundResponse;
        private final Request request;
        private final Throwable thr;
        private DispatcherObjectHandler objectHandler;

        private InboundResponseWrapper(InboundResponse inboundResponse, Request request, Throwable throwable, DispatcherObjectHandler dispatcherObjectHandler) {
            this.inboundResponse = inboundResponse;
            this.request = request;
            this.thr = throwable;
            this.objectHandler = dispatcherObjectHandler;
        }

        public MsgInput getMsgInput() {
            return this.inboundResponse.getMsgInput();
        }

        public Object unmarshalReturn() throws Throwable {
            if (this.thr != null) {
                throw this.thr;
            }
            return this.objectHandler.readResponse((ObjectInput)this.getMsgInput(), this.request);
        }

        public void retrieveThreadLocalContext() throws IOException {
            this.inboundResponse.retrieveThreadLocalContext();
        }

        public Object getTxContext() {
            return this.inboundResponse.getTxContext();
        }

        public Object getReplicaInfo() throws IOException {
            return this.inboundResponse.getReplicaInfo();
        }

        public Object getActivatedPinnedRef() throws IOException {
            return this.inboundResponse.getActivatedPinnedRef();
        }

        public Object getContext(int n) throws IOException {
            return this.inboundResponse.getContext(n);
        }

        public void close() throws IOException {
            this.inboundResponse.close();
        }
    }

    private static final class DispatcherProxyDisconnectMonitorImpl
    implements DisconnectMonitorProvider {
        private DispatcherProxyDisconnectMonitorImpl() {
        }

        public boolean addDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
            HostID hostID = DispatcherProxyDisconnectMonitorImpl.getHostIDFromStub(remote);
            if (hostID != null) {
                EndPoint endPoint = RMIRuntime.findEndPoint((HostID)hostID);
                if (endPoint == null || endPoint.isDead()) {
                    RMIRuntime.getRMIRuntime();
                    endPoint = RMIRuntime.findOrCreateEndPoint((HostID)hostID);
                }
                if (endPoint != null) {
                    return endPoint.addDisconnectListener(remote, disconnectListener);
                }
            }
            return false;
        }

        public boolean removeDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
            HostID hostID = DispatcherProxyDisconnectMonitorImpl.getHostIDFromStub(remote);
            if (hostID != null) {
                EndPoint endPoint = RMIRuntime.findEndPoint((HostID)hostID);
                if (endPoint != null) {
                    endPoint.removeDisconnectListener(remote, disconnectListener);
                }
                return true;
            }
            return false;
        }

        private static HostID getHostIDFromStub(Remote remote) {
            if (remote instanceof DispatcherProxy) {
                return ((DispatcherProxy)remote).hostID;
            }
            return null;
        }
    }

    private static final class DispatcherResponseListener
    implements ResponseListener {
        private final boolean transactional;
        private final AsyncCallback callback;
        private final Request request;
        private final DispatcherObjectHandler objectHandler;

        DispatcherResponseListener(boolean bl, AsyncCallback asyncCallback, Request request, DispatcherObjectHandler dispatcherObjectHandler) {
            this.transactional = bl;
            this.callback = asyncCallback;
            this.request = request;
            this.objectHandler = dispatcherObjectHandler;
        }

        public synchronized void response(weblogic.rjvm.Response response) {
            InboundResponse inboundResponse = (InboundResponse)response;
            try {
                inboundResponse.retrieveThreadLocalContext();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            if (this.transactional) {
                Interceptor interceptor = InterceptorManager.getManager().getTransactionInterceptor();
                try {
                    interceptor.receiveResponse(inboundResponse.getTxContext());
                }
                catch (RemoteException remoteException) {
                    throw new AssertionError((Object)remoteException);
                }
            }
            this.callback.setInboundResponse((InboundResponse)new InboundResponseWrapper(inboundResponse, this.request, response.getThrowable(), this.objectHandler));
        }
    }
}

