/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import weblogic.jms.common.JMSDebug;
import weblogic.messaging.common.IDImpl;
import weblogic.messaging.dispatcher.DispatcherObjectHandler;
import weblogic.messaging.dispatcher.DispatcherProxy;
import weblogic.messaging.dispatcher.FastDispatcherImpl;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.internal.AsyncResultImpl;
import weblogic.rmi.internal.BasicFutureResponse;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.IDBasedConstraintEnforcement;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;

public class DispatcherServerRef
extends BasicServerRef {
    private final DispatcherObjectHandler objectHandler;
    private final WorkManager workManager;
    private final WorkManager oneWayWorkManager;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int count;
    private int lastMethodId;
    private int lastRequestType;

    public DispatcherServerRef(Object object) throws RemoteException {
        super(object);
        FastDispatcherImpl fastDispatcherImpl = (FastDispatcherImpl)object;
        this.workManager = fastDispatcherImpl.getWorkManager();
        this.oneWayWorkManager = fastDispatcherImpl.getOneWayWorkManager();
        this.objectHandler = fastDispatcherImpl.getObjectHandler();
    }

    public final void dispatch(final InboundRequest inboundRequest) {
        Interceptor interceptor;
        int n;
        byte by;
        block7: {
            MsgInput msgInput = inboundRequest.getMsgInput();
            try {
                by = msgInput.readByte();
                n = (by & 0x10) != 0 ? msgInput.readInt() : 0;
            }
            catch (IOException iOException) {
                DispatcherServerRef.trySendThrowableBeforeInterceptor((InboundRequest)inboundRequest, (Throwable)new UnmarshalException("Could not unmarshal inboundRequest type", iOException));
                return;
            }
            if (DispatcherProxy.isTransactional(by) && (interceptor = InterceptorManager.getManager().getTransactionInterceptor()) != null) {
                try {
                    interceptor.receiveRequest(inboundRequest.getTxContext());
                }
                catch (RemoteException remoteException) {
                    if (DispatcherProxy.isOneWay(by)) break block7;
                    DispatcherServerRef.trySendThrowable((InboundRequest)inboundRequest, (Throwable)remoteException);
                }
            }
        }
        WorkManager workManager = interceptor = n > 0 || DispatcherProxy.isOneWay(by) ? this.oneWayWorkManager : this.workManager;
        if (n > 0) {
            IDBasedConstraintEnforcement.getInstance().schedule((WorkManager)interceptor, (Runnable)new WorkAdapter(){

                public void run() {
                    DispatcherServerRef.this.handleRequest(by, inboundRequest);
                }
            }, n);
        } else {
            interceptor.schedule((Runnable)new WorkAdapter(){

                public void run() {
                    DispatcherServerRef.this.handleRequest(by, inboundRequest);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRequest(int n, InboundRequest inboundRequest) {
        OutboundResponse outboundResponse = null;
        try {
            AuthenticatedSubject authenticatedSubject;
            if (!DispatcherProxy.isOneWay(n)) {
                outboundResponse = inboundRequest.getOutboundResponse();
                if (DispatcherProxy.isTransactional(n) && (authenticatedSubject = InterceptorManager.getManager().getTransactionInterceptor()) != null) {
                    authenticatedSubject.dispatchRequest(inboundRequest.getTxContext());
                }
            }
            authenticatedSubject = (AuthenticatedSubject)inboundRequest.getSubject();
            try {
                SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
                this.invoke(n, inboundRequest, outboundResponse);
            }
            finally {
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            }
        }
        catch (Throwable throwable) {
            DispatcherServerRef.handleThrowable(inboundRequest, outboundResponse, throwable);
        }
        finally {
            if (DispatcherProxy.isOneWay(n)) {
                try {
                    inboundRequest.close();
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
            }
        }
    }

    private static void handleThrowable(InboundRequest inboundRequest, OutboundResponse outboundResponse, Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            RMILogger.logRuntimeException((String)"dispatch", (Throwable)throwable);
        } else if (throwable instanceof Error) {
            RMILogger.logError((String)"dispatch", (Throwable)throwable);
        } else {
            RMILogger.logException((String)"dispatch", (Throwable)throwable);
        }
        if (outboundResponse != null) {
            try {
                outboundResponse.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                outboundResponse = inboundRequest.getOutboundResponse();
                outboundResponse.transferThreadLocalContext(inboundRequest);
            }
            catch (IOException iOException) {
                RMILogger.logAssociateTX((Exception)iOException);
            }
        }
        DispatcherServerRef.handleThrowable((Throwable)throwable, (OutboundResponse)outboundResponse);
    }

    private final void invoke(int n, InboundRequest inboundRequest, OutboundResponse outboundResponse) throws Exception {
        Request request;
        IDImpl iDImpl;
        Object object;
        int n2 = this.count++;
        int n3 = this.lastMethodId;
        int n4 = this.lastRequestType;
        this.lastRequestType = n;
        try {
            int n5;
            object = inboundRequest.getMsgInput();
            if (DispatcherProxy.hasInvocableID(n)) {
                iDImpl = new IDImpl();
                iDImpl.readExternal((ObjectInput)object);
            } else {
                iDImpl = null;
            }
            this.lastMethodId = n5 = object.readInt();
            request = this.objectHandler.readRequest(n5, (ObjectInput)object, iDImpl);
        }
        catch (IOException iOException) {
            throw new UnmarshalException("error unmarshalling arguments, count=" + n2 + ", lastMethodId" + n3 + ", lastRequestType" + n4, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("error unmarshalling arguments; count=" + n2 + ", lastMethodId" + n3 + ", lastRequestType" + n4, classNotFoundException);
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("Dispatching : " + request + " OneWay=" + DispatcherProxy.isOneWay(n) + " Async=" + DispatcherProxy.isAsync(n) + " Transactional=" + DispatcherProxy.isTransactional(n));
        }
        if (!DispatcherProxy.isOneWay(n)) {
            object = new OutboundResponseWrapper(inboundRequest, outboundResponse, request, this.objectHandler);
            request.setFutureResponse((FutureResponse)object);
            if (DispatcherProxy.isAsync(n)) {
                iDImpl = new AsyncResultImpl(inboundRequest, (OutboundResponse)object);
                request.setAsyncResult((AsyncResult)iDImpl);
            }
            if (DispatcherProxy.isTransactional(n)) {
                request.setTranInfo(2);
            } else {
                request.setTranInfo(0);
            }
        }
        try {
            request.wrappedFiniteStateMachine();
        }
        catch (Throwable throwable) {
            request.notifyResult(throwable, false);
        }
    }

    protected boolean deferredUnmarshal() {
        return false;
    }

    static final class OutboundResponseWrapper
    extends BasicFutureResponse
    implements FutureResponse,
    OutboundResponse,
    MsgOutput {
        private final DispatcherObjectHandler objectHandler;
        private final OutboundResponse outboundResponse;
        private MsgOutput msgOutputDelegate;
        private final Request request;

        private OutboundResponseWrapper(InboundRequest inboundRequest, OutboundResponse outboundResponse, Request request, DispatcherObjectHandler dispatcherObjectHandler) {
            super(inboundRequest, outboundResponse);
            this.outboundResponse = outboundResponse;
            this.request = request;
            this.objectHandler = dispatcherObjectHandler;
        }

        public MsgOutput getMsgOutput() throws RemoteException {
            this.msgOutputDelegate = super.getMsgOutput();
            return this;
        }

        public void writeObject(Object object, Class clazz) throws IOException {
            if (object instanceof Throwable) {
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    DispatcherObjectHandler.debugWireOperation("SendResp ", (byte)15, this.request, -1, this.request.getInvocableId(), null, (Throwable)object);
                }
                this.outboundResponse.sendThrowable((Throwable)object);
            } else {
                this.objectHandler.writeResponse((ObjectOutput)this.msgOutputDelegate, this.request, (Response)object);
            }
        }

        public void writeObject(Object object) throws IOException {
            this.objectHandler.writeResponse((ObjectOutput)this.msgOutputDelegate, this.request, (Response)object);
        }

        public void write(int n) throws IOException {
            this.msgOutputDelegate.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.msgOutputDelegate.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.msgOutputDelegate.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.msgOutputDelegate.flush();
        }

        public void writeBoolean(boolean bl) throws IOException {
            this.msgOutputDelegate.writeBoolean(bl);
        }

        public void writeByte(int n) throws IOException {
            this.msgOutputDelegate.writeByte(n);
        }

        public void writeShort(int n) throws IOException {
            this.msgOutputDelegate.writeShort(n);
        }

        public void writeChar(int n) throws IOException {
            this.msgOutputDelegate.writeChar(n);
        }

        public void writeInt(int n) throws IOException {
            this.msgOutputDelegate.writeInt(n);
        }

        public void writeLong(long l) throws IOException {
            this.msgOutputDelegate.writeLong(l);
        }

        public void writeFloat(float f) throws IOException {
            this.msgOutputDelegate.writeFloat(f);
        }

        public void writeDouble(double d) throws IOException {
            this.msgOutputDelegate.writeDouble(d);
        }

        public void writeBytes(String string) throws IOException {
            this.msgOutputDelegate.writeBytes(string);
        }

        public void writeChars(String string) throws IOException {
            this.msgOutputDelegate.writeChars(string);
        }

        public void writeUTF(String string) throws IOException {
            this.msgOutputDelegate.writeUTF(string);
        }
    }
}

