/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.InvocableManager;
import weblogic.rmi.extensions.PortableRemoteObject;

public class DispatcherWrapper
implements Externalizable {
    static final long serialVersionUID = -569390197367234160L;
    private static final byte EXTVERSION = 1;
    private static final byte DISPATCHER_VERSION = 8;
    private String name;
    private DispatcherId dispatcherId;
    private PeerInfo peerInfo;
    protected DispatcherRemote dispatcherRemote;
    protected DispatcherOneWay dispatcherOneWay;
    private InvocableManager appInvocableManager;

    public DispatcherWrapper(DispatcherImpl dispatcherImpl) {
        this.dispatcherId = dispatcherImpl.getId();
        this.name = dispatcherImpl.getName();
        this.dispatcherRemote = dispatcherImpl;
        this.dispatcherOneWay = dispatcherImpl;
        this.peerInfo = VersionInfoFactory.getPeerInfoForWire();
    }

    public void setAppInvocableManager(InvocableManager invocableManager) {
        this.appInvocableManager = invocableManager;
    }

    public InvocableManager getAppInvocableManager() {
        return this.appInvocableManager;
    }

    public DispatcherRemote getRemoteDispatcher() {
        return this.dispatcherRemote;
    }

    public DispatcherOneWay getOneWayDispatcher() {
        return this.dispatcherOneWay;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public final String getName() {
        return this.name;
    }

    public final DispatcherId getId() {
        return this.dispatcherId;
    }

    public final void setId(DispatcherId dispatcherId) {
        this.dispatcherId = dispatcherId;
    }

    public DispatcherWrapper() {
    }

    protected void writeExternalInterop(ObjectOutput objectOutput) throws IOException {
    }

    protected void readExternalInterop(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo;
        objectOutput.writeByte(1);
        objectOutput.writeByte(8);
        if (this.name == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.name);
        }
        if (this.dispatcherId == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            this.dispatcherId.writeExternal(objectOutput);
        }
        objectOutput.writeObject(this.peerInfo);
        if (objectOutput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectOutput).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_DIABLO) < 0) {
            this.writeExternalInterop(objectOutput);
            return;
        }
        if (KernelStatus.isApplet() && objectOutput instanceof WLObjectOutput) {
            ((WLObjectOutput)objectOutput).writeObjectWL((Object)this.dispatcherRemote);
            ((WLObjectOutput)objectOutput).writeObjectWL((Object)this.dispatcherOneWay);
        } else {
            objectOutput.writeObject(this.dispatcherRemote);
            objectOutput.writeObject(this.dispatcherOneWay);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw MessagingUtilities.versionIOException(by, 1, 1);
        }
        byte by2 = objectInput.readByte();
        if (by2 != 8) {
            throw MessagingUtilities.versionIOException(by2, 8, 8);
        }
        if (objectInput.readBoolean()) {
            this.name = objectInput.readUTF();
        }
        if (objectInput.readBoolean()) {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
        this.peerInfo = (PeerInfo)objectInput.readObject();
        if (this.peerInfo.compareTo((Object)PeerInfo.VERSION_DIABLO) >= 0) {
            this.dispatcherRemote = (DispatcherRemote)PortableRemoteObject.narrow((Object)objectInput.readObject(), DispatcherRemote.class);
            this.dispatcherOneWay = (DispatcherOneWay)PortableRemoteObject.narrow((Object)objectInput.readObject(), DispatcherOneWay.class);
        } else {
            this.readExternalInterop(objectInput);
        }
    }
}

