/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.Transaction;
import weblogic.common.internal.PeerInfo;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherManager;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.DispatcherStateChangeListener;
import weblogic.messaging.dispatcher.DispatcherWrapper;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.dispatcher.VoidResponse;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultFactory;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.server.RemoteWrapper;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class DispatcherWrapperState
implements Dispatcher,
DisconnectListener,
RemoteWrapper,
TimerListener,
Runnable {
    static final long serialVersionUID = -360573074488373048L;
    private final String name;
    private final DispatcherId dispatcherId;
    private PeerInfo peerInfo;
    private DispatcherRemote dispatcherRemote;
    private DispatcherOneWay dispatcherOneWay;
    private boolean peerGone;
    private boolean peerGoneIsOn;
    private int refCount = 1;
    private Exception exceptionForPeerGone;
    private boolean fireListeners;
    private final transient HashMap listenersMap = new HashMap();
    private final transient HashMap stateChangeListeners = new HashMap();
    private int stateChangeListenersInExecution;
    private static final transient int PEERGONE_DELAY = 100;
    private static transient WorkManager workManager;
    private static transient TimerManager timerManager;
    private static VoidResponse voidResponse;
    private static final ClientTransactionManager tranManager;

    protected DispatcherWrapperState(DispatcherWrapper dispatcherWrapper) throws DispatcherException {
        this.dispatcherId = dispatcherWrapper.getId();
        this.name = dispatcherWrapper.getName();
        this.dispatcherRemote = dispatcherWrapper.getRemoteDispatcher();
        this.dispatcherOneWay = dispatcherWrapper.getOneWayDispatcher();
        this.peerInfo = dispatcherWrapper.getPeerInfo();
        this.addPeerGoneListener();
    }

    public final synchronized boolean getPeerGoneCache() {
        return this.peerGone;
    }

    synchronized boolean removeRefCount() {
        --this.refCount;
        return this.refCount > 0;
    }

    synchronized void addRefCount() {
        ++this.refCount;
    }

    public final synchronized void deleteNotify() {
        this.removePeerGoneListener();
    }

    public final String getName() {
        return this.name;
    }

    public final DispatcherId getId() {
        return this.dispatcherId;
    }

    public final boolean isLocal() {
        return false;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public final Remote getRemoteDelegate() {
        return this.dispatcherRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatchAsync(Request request) throws DispatcherException {
        this.preAsync(request);
        try {
            if (0 != (request.remoteSignature() & 1)) {
                AsyncResult asyncResult = AsyncResultFactory.getCallbackableResult((AsyncResultListener)request);
                this.dispatcherRemote.dispatchAsyncTranFuture(request, asyncResult);
                return;
            }
            Transaction transaction = null;
            try {
                transaction = tranManager.forceSuspend();
                AsyncResult asyncResult = AsyncResultFactory.getCallbackableResult((AsyncResultListener)request);
                this.dispatcherRemote.dispatchAsyncFuture(request, asyncResult);
                Object var5_12 = null;
                if (transaction == null) return;
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (transaction == null) throw throwable;
                tranManager.forceResume(transaction);
                throw throwable;
            }
            tranManager.forceResume(transaction);
            return;
        }
        catch (DispatcherException dispatcherException) {
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            DispatcherException dispatcherException = new DispatcherException(remoteRuntimeException.getNestedException());
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteException remoteException) {
            DispatcherException dispatcherException = new DispatcherException(remoteException);
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (Error error) {
            request.complete(error, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            request.complete(runtimeException, false);
            throw runtimeException;
        }
    }

    public void dispatchNoReply(Request request) throws DispatcherException {
        if ((request.remoteSignature() & 1) == 0) {
            this.preRemote(request);
            try {
                this.dispatcherOneWay.dispatchOneWay(request);
                this.postRMI(request, voidResponse);
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                DispatcherException dispatcherException = new DispatcherException(remoteRuntimeException.getNestedException());
                request.complete(dispatcherException, false);
                throw dispatcherException;
            }
            catch (RemoteException remoteException) {
                DispatcherException dispatcherException = new DispatcherException(remoteException);
                request.complete(dispatcherException, false);
                throw dispatcherException;
            }
            catch (Error error) {
                request.complete(error, false);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                request.complete(runtimeException, false);
                throw runtimeException;
            }
        } else {
            DispatcherException dispatcherException = new DispatcherException("Transactions not supported for one-way calls");
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
    }

    public void dispatchNoReplyWithId(Request request, int n) throws DispatcherException {
        this.preRemote(request);
        if ((request.remoteSignature() & 1) == 0) {
            try {
                this.dispatcherOneWay.dispatchOneWayWithId(request, n);
                this.postRMI(request, voidResponse);
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                DispatcherException dispatcherException = new DispatcherException(remoteRuntimeException.getNestedException());
                request.complete(dispatcherException, false);
                throw dispatcherException;
            }
            catch (RemoteException remoteException) {
                DispatcherException dispatcherException = new DispatcherException(remoteException);
                request.complete(dispatcherException, false);
                throw dispatcherException;
            }
            catch (Error error) {
                request.complete(error, false);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                request.complete(runtimeException, false);
                throw runtimeException;
            }
        } else {
            DispatcherException dispatcherException = new DispatcherException("Transactions not supported for one-way calls");
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
    }

    public Response dispatchSync(Request request) throws DispatcherException {
        return this.dispatchSyncNoTran(request);
    }

    private String preSync(Request request) {
        request.setSyncRequest(true);
        return this.preRemote(request);
    }

    private String preAsync(Request request) {
        return this.preRemote(request);
    }

    private String preRemote(Request request) {
        request.setPeerInfo(this.peerInfo);
        request.setState(-42);
        request.setParentResumeNewThread(true);
        request.incNumChildren();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response postRMI(Request request, Response response) {
        InvocableMonitor invocableMonitor;
        Request request2 = request;
        synchronized (request2) {
            request.childResult(response);
            invocableMonitor = request.getInvocableMonitor();
        }
        if (invocableMonitor != null) {
            request.clearInvocableMonitor();
        }
        return response;
    }

    public Response dispatchSyncTranWithId(Request request, int n) throws DispatcherException {
        this.preSync(request);
        try {
            return this.postRMI(request, this.dispatcherRemote.dispatchSyncTranFutureWithId(request, n));
        }
        catch (DispatcherException dispatcherException) {
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            DispatcherException dispatcherException = new DispatcherException(remoteRuntimeException.getNestedException());
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteException remoteException) {
            DispatcherException dispatcherException = new DispatcherException(remoteException);
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (Error error) {
            request.complete(error, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            request.complete(runtimeException, false);
            throw runtimeException;
        }
    }

    public Response dispatchSyncTran(Request request) throws DispatcherException {
        this.preSync(request);
        try {
            return this.postRMI(request, this.dispatcherRemote.dispatchSyncTranFuture(request));
        }
        catch (DispatcherException dispatcherException) {
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            DispatcherException dispatcherException = new DispatcherException(remoteRuntimeException.getNestedException());
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (RemoteException remoteException) {
            DispatcherException dispatcherException = new DispatcherException(remoteException);
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (Error error) {
            request.complete(error, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            request.complete(runtimeException, false);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncNoTranWithId(Request request, int n) throws DispatcherException {
        Response response;
        block2: {
            Transaction transaction = tranManager.forceSuspend();
            try {
                response = this.dispatchSyncTranWithId(request, n);
                Object var6_5 = null;
                if (transaction == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (transaction == null) break block3;
                    tranManager.forceResume(transaction);
                }
                throw throwable;
            }
            tranManager.forceResume(transaction);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncNoTran(Request request) throws DispatcherException {
        Response response;
        block2: {
            Transaction transaction = tranManager.forceSuspend();
            try {
                response = this.dispatchSyncTran(request);
                Object var5_4 = null;
                if (transaction == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (transaction == null) break block3;
                    tranManager.forceResume(transaction);
                }
                throw throwable;
            }
            tranManager.forceResume(transaction);
        }
        return response;
    }

    public void onDisconnect(DisconnectEvent disconnectEvent) {
        this.schedulePeerGone(new Exception(disconnectEvent.getThrowable()));
    }

    public synchronized void addPeerGoneListener() throws DispatcherException {
        if (this.dispatcherRemote == null) {
            if (this.peerGoneIsOn) {
                return;
            }
            new DispatcherException("TODO REMOVE SAG dispatcherRemote is null").printStackTrace();
            throw new DispatcherException("dispatcherRemote is null");
        }
        DisconnectMonitor disconnectMonitor = DisconnectMonitorListImpl.getDisconnectMonitor();
        try {
            Remote remote = this.dispatcherRemote;
            if (remote instanceof RemoteWrapper) {
                remote = ((RemoteWrapper)remote).getRemoteDelegate();
            }
            disconnectMonitor.addDisconnectListener(remote, (DisconnectListener)this);
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            DispatcherException dispatcherException = new DispatcherException(disconnectMonitorUnavailableException.getMessage() + " for " + this.dispatcherId);
            dispatcherException.initCause(disconnectMonitorUnavailableException);
            throw dispatcherException;
        }
        this.peerGoneIsOn = true;
    }

    public synchronized void removePeerGoneListener() {
        if (!this.peerGoneIsOn) {
            return;
        }
        this.peerGoneIsOn = false;
        if (this.dispatcherRemote == null) {
            return;
        }
        DisconnectMonitor disconnectMonitor = DisconnectMonitorListImpl.getDisconnectMonitor();
        try {
            Remote remote = this.dispatcherRemote;
            if (remote instanceof RemoteWrapper) {
                remote = ((RemoteWrapper)remote).getRemoteDelegate();
            }
            disconnectMonitor.removeDisconnectListener(remote, (DisconnectListener)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
        DispatcherPeerGoneListener dispatcherPeerGoneListener2;
        DispatcherWrapperState dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            dispatcherPeerGoneListener2 = (DispatcherPeerGoneListener)this.listenersMap.get(dispatcherPeerGoneListener.getId());
            if (this.exceptionForPeerGone == null) {
                if (dispatcherPeerGoneListener2 == null) {
                    dispatcherPeerGoneListener2 = dispatcherPeerGoneListener;
                    this.listenersMap.put(dispatcherPeerGoneListener.getId(), dispatcherPeerGoneListener2);
                    if (dispatcherPeerGoneListener instanceof DispatcherStateChangeListener) {
                        this.stateChangeListeners.put(dispatcherPeerGoneListener.getId(), dispatcherPeerGoneListener2);
                    }
                }
                dispatcherPeerGoneListener2.incrementRefCount();
                return dispatcherPeerGoneListener2;
            }
        }
        try {
            dispatcherPeerGoneListener.dispatcherPeerGone(this.exceptionForPeerGone, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dispatcherWrapperState = this;
        synchronized (dispatcherWrapperState) {
            return dispatcherPeerGoneListener2 == null ? dispatcherPeerGoneListener : dispatcherPeerGoneListener2;
        }
    }

    public synchronized void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
        ID iD = dispatcherPeerGoneListener.getId();
        DispatcherPeerGoneListener dispatcherPeerGoneListener2 = (DispatcherPeerGoneListener)this.listenersMap.get(iD);
        if (dispatcherPeerGoneListener2 == null) {
            return;
        }
        if (dispatcherPeerGoneListener2.decrementRefCount() == 0) {
            this.listenersMap.remove(iD);
            if (dispatcherPeerGoneListener2 instanceof DispatcherStateChangeListener) {
                this.stateChangeListeners.remove(iD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePeerGone(Exception exception) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        RuntimeException runtimeException = null;
        Error error = null;
        while (true) {
            DispatcherStateChangeListener dispatcherStateChangeListener;
            DispatcherWrapperState dispatcherWrapperState = this;
            synchronized (dispatcherWrapperState) {
                this.peerGone = true;
                if (this.exceptionForPeerGone == null) {
                    this.exceptionForPeerGone = exception;
                    bl2 = true;
                }
                if (bl3) {
                    --this.stateChangeListenersInExecution;
                }
                if (bl = this.stateChangeListeners.isEmpty()) {
                    if (this.stateChangeListenersInExecution == 0) {
                        this.notifyAll();
                    }
                    break;
                }
                dispatcherStateChangeListener = this.removeLockedStateChangeListener();
                if (dispatcherStateChangeListener == null) {
                    if (this.stateChangeListenersInExecution == 0) {
                        this.notifyAll();
                    }
                    break;
                }
                if (!bl3) {
                    bl3 = true;
                    ++this.stateChangeListenersInExecution;
                }
            }
            try {
                dispatcherStateChangeListener.stateChangeListener(dispatcherStateChangeListener, exception);
            }
            catch (Error error2) {
                if (error != null || runtimeException != null) continue;
                error = error2;
            }
            catch (RuntimeException runtimeException2) {
                if (error != null || runtimeException != null) continue;
                runtimeException = runtimeException2;
            }
        }
        if (bl2) {
            if (bl) {
                DispatcherWrapperState.getDefaultWorkManager().schedule((Runnable)this);
            } else {
                DispatcherWrapperState.getDefaultTimerManager().schedule((TimerListener)this, 100L);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (error != null) {
            throw error;
        }
    }

    private static synchronized WorkManager getDefaultWorkManager() {
        if (workManager == null) {
            workManager = WorkManagerFactory.getInstance().getDefault();
        }
        return workManager;
    }

    private static synchronized TimerManager getDefaultTimerManager() {
        if (timerManager == null) {
            timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
        }
        return timerManager;
    }

    private DispatcherStateChangeListener removeLockedStateChangeListener() {
        Iterator iterator = this.stateChangeListeners.values().iterator();
        while (iterator.hasNext()) {
            DispatcherStateChangeListener dispatcherStateChangeListener = (DispatcherStateChangeListener)iterator.next();
            if (!dispatcherStateChangeListener.holdsLock()) continue;
            iterator.remove();
            return dispatcherStateChangeListener;
        }
        return null;
    }

    public void timerExpired(Timer timer) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Error error = null;
        RuntimeException runtimeException = null;
        Object object = DispatcherManager.class;
        synchronized (DispatcherManager.class) {
            DispatcherManager.removeDispatcherReference(this, true);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            while (true) {
                Exception exception;
                boolean bl;
                DispatcherWrapperState dispatcherWrapperState = this;
                synchronized (dispatcherWrapperState) {
                    Iterator iterator;
                    while (this.stateChangeListenersInExecution > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                    }
                    boolean bl2 = bl = !this.stateChangeListeners.isEmpty();
                    if (bl) {
                        iterator = this.stateChangeListeners.values().iterator();
                    } else {
                        if (!this.fireListeners) {
                            this.fireListeners = true;
                            this.notifyAll();
                        }
                        if (this.listenersMap.isEmpty()) {
                            if (runtimeException != null) {
                                throw runtimeException;
                            }
                            if (error != null) {
                                throw error;
                            }
                            return;
                        }
                        iterator = this.listenersMap.values().iterator();
                    }
                    exception = this.exceptionForPeerGone;
                    object = (DispatcherPeerGoneListener)iterator.next();
                    iterator.remove();
                }
                if (bl) {
                    try {
                        ((DispatcherStateChangeListener)object).stateChangeListener((DispatcherStateChangeListener)object, exception);
                    }
                    catch (Error error2) {
                        if (error != null || runtimeException != null) continue;
                        error = error2;
                    }
                    catch (RuntimeException runtimeException2) {
                        if (error != null || runtimeException != null) continue;
                        runtimeException = runtimeException2;
                    }
                    continue;
                }
                try {
                    object.dispatcherPeerGone(exception, this);
                    continue;
                }
                catch (Error error3) {
                    if (error != null || runtimeException != null) continue;
                    error = error3;
                    continue;
                }
                catch (RuntimeException runtimeException3) {
                    if (error != null || runtimeException != null) continue;
                    runtimeException = runtimeException3;
                    continue;
                }
                break;
            }
        }
    }

    public String toString() {
        return "DispWrap #" + this.hashCode() + " " + this.dispatcherId;
    }

    static {
        voidResponse = new VoidResponse();
        tranManager = TransactionHelper.getTransactionHelper().getTransactionManager();
    }
}

