/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.PeerInfoableObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.VoidResponse;

public class Response
implements Externalizable {
    static final long serialVersionUID = -4057384450154825617L;
    public static final boolean CHECK = false;
    private static final byte EXTVERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte CORRELATION_ID_MASK = 32;
    private static final byte PAYLOAD_MASK = 64;
    private PeerInfo peerInfo;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if ((by & 0x1F) != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        if ((by & 0x20) != 0) {
            objectInput.readLong();
        }
        if ((by & 0x40) != 0) {
            objectInput.readObject();
        }
    }

    public static void instanceOf(Object object, Class clazz) {
        if (clazz.isInstance(object)) {
            return;
        }
        if (object == null && VoidResponse.class == clazz) {
            return;
        }
        throw new AssertionError((Object)("" + object + " is not an instance of " + clazz.getName()));
    }

    public final void setPeerInfo(PeerInfo peerInfo) {
        this.peerInfo = peerInfo;
    }

    public final ObjectOutput getVersionedStream(ObjectOutput objectOutput) {
        if (objectOutput instanceof PeerInfoable) {
            return objectOutput;
        }
        assert (this.peerInfo != null);
        return new PeerInfoableObjectOutput(this.peerInfo, objectOutput);
    }
}

