/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.MILogger;
import weblogic.messaging.interception.interfaces.InterceptionService;
import weblogic.messaging.interception.internal.InterceptionServiceImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class MessageInterceptionService
extends AbstractServerService {
    public static String MessageInterceptionService_JNDIName = "weblogic.MessageInterception";
    private static InterceptionService interceptionService = InterceptionServiceImpl.getInterceptionService();
    private static Context nonReplicatedCtx;
    private static final AuthenticatedSubject KERNEL_ID;

    public static InterceptionService getSingleton() {
        return interceptionService;
    }

    public void start() throws ServiceFailureException {
        try {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            environment.setReplicateBindings(false);
            nonReplicatedCtx = environment.getInitialContext();
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        nonReplicatedCtx.bind(MessageInterceptionService_JNDIName, (Object)interceptionService);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new NamingException(privilegedActionException.toString());
            }
        }
        catch (NamingException namingException) {
            throw new ServiceFailureException(MIExceptionLogger.logSetupJNDIExceptionLoggable((String)MessageInterceptionService_JNDIName).getMessage(), (Throwable)namingException);
        }
        MILogger.logStartMessageInterceptionService();
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

