/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.rpc.handler.MessageContext;
import weblogic.jms.common.JMSMessageContext;
import weblogic.jms.common.MessageImpl;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.exceptions.MessageContextException;
import weblogic.messaging.interception.interfaces.AssociationHandle;
import weblogic.messaging.interception.interfaces.AssociationInfo;
import weblogic.messaging.interception.interfaces.CarrierCallBack;
import weblogic.messaging.interception.interfaces.Processor;
import weblogic.messaging.interception.internal.AssociationInfoImpl;
import weblogic.messaging.interception.internal.InterceptionCallBackImpl;
import weblogic.messaging.interception.internal.InterceptionPoint;
import weblogic.messaging.interception.internal.ProcessorWrapper;

public class Association
implements AssociationHandle {
    private static final int PROCESS = 1;
    private static final int PROCESSONLY = 2;
    private static final int PROCESSASYNC = 3;
    private static final int PROCESSONLYASYNC = 4;
    private InterceptionPoint ip = null;
    private ProcessorWrapper pw = null;
    private boolean activated = false;
    private boolean removed = false;
    private long totalMessagesCount = 0L;
    private long continueMessagesCount = 0L;
    private long inProgressMessagesCount = 0L;
    private int depth;
    private AssociationInfoImpl info = null;
    private String ipType = null;
    private String[] ipName = null;
    private String pType = null;
    private String pName = null;

    Association(InterceptionPoint interceptionPoint, ProcessorWrapper processorWrapper, boolean bl, int n) throws InterceptionServiceException {
        this.ip = interceptionPoint;
        this.ipType = interceptionPoint.getType();
        this.ipName = interceptionPoint.getName();
        this.pw = processorWrapper;
        this.pType = processorWrapper.getType();
        this.pName = processorWrapper.getName();
        this.activated = bl;
        this.depth = n;
        this.info = new AssociationInfoImpl(this);
    }

    String getInternalName() {
        return this.ip.getInternalName();
    }

    String getIPType() {
        return this.ipType;
    }

    String[] getIPName() {
        return this.ipName;
    }

    String getPType() {
        return this.pType;
    }

    String getPName() {
        return this.pName;
    }

    synchronized void remove() throws InterceptionServiceException {
        if (this.removed) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveAssociationAlreadyRemoveErrorLoggable((String)"Association has been removed").getMessage());
        }
        this.removed = true;
        this.pw.removeAssociation(this);
        this.ip.removeAssociation();
        this.ip = null;
        this.pw = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean processInternal(MessageContext messageContext, CarrierCallBack carrierCallBack, int n) throws InterceptionServiceException, InterceptionException, MessageContextException {
        Processor processor = null;
        this.adjust(messageContext);
        Association association2 = this;
        // MONITORENTER : association2
        if (this.removed) {
            // MONITOREXIT : association2
            return true;
        }
        ++this.totalMessagesCount;
        if (!this.activated) {
            ++this.continueMessagesCount;
            // MONITOREXIT : association2
            return true;
        }
        processor = this.pw.getProcessor();
        if (processor == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logProcessProcessorNotFoundErrorLoggable((String)"Processor not found").getMessage());
        }
        if (this.inProgressMessagesCount >= (long)this.depth) {
            throw new InterceptionServiceException(MIExceptionLogger.logProcessProcessorDepthExceededErrorLoggable((String)("Processor has more intercepted message than " + this.depth + " outstanding")).getMessage());
        }
        ++this.inProgressMessagesCount;
        // MONITOREXIT : association2
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        InterceptionServiceException interceptionServiceException = null;
        try {
            block47: {
                try {
                    if (n == 1) {
                        bl = processor.process(messageContext, this.info);
                        bl2 = true;
                        break block47;
                    }
                    if (n == 3) {
                        InterceptionCallBackImpl interceptionCallBackImpl = new InterceptionCallBackImpl(carrierCallBack, this, false, messageContext);
                        processor.processAsync(messageContext, this.info, interceptionCallBackImpl);
                        bl2 = true;
                        break block47;
                    }
                    if (n == 2) {
                        processor.processOnly(messageContext, this.info);
                        bl2 = true;
                        break block47;
                    }
                    InterceptionCallBackImpl interceptionCallBackImpl = new InterceptionCallBackImpl(carrierCallBack, this, true, messageContext);
                    processor.processOnlyAsync(messageContext, this.info, interceptionCallBackImpl);
                    bl2 = true;
                }
                catch (RuntimeException interceptionCallBackImpl) {
                    throwable = interceptionCallBackImpl;
                    interceptionServiceException = this.pw.removeProcessor(processor, true);
                    Object var11_15 = null;
                    Association association = this;
                    // MONITORENTER : association
                    if (!bl2) {
                        --this.inProgressMessagesCount;
                    } else if (n == 1) {
                        --this.inProgressMessagesCount;
                        if (bl) {
                            ++this.continueMessagesCount;
                        }
                    } else if (n == 2) {
                        --this.inProgressMessagesCount;
                        ++this.continueMessagesCount;
                    }
                    // MONITOREXIT : association
                    if (throwable == null) return bl;
                    this.pw.removeProcessorWrapperIfNotUsed();
                    if (interceptionServiceException != null) {
                        throw interceptionServiceException;
                    }
                    if (!(throwable instanceof Error)) throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalExceptionLoggable((String)"Processor throws illegal runtime exception").getMessage(), throwable);
                    throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalErrorLoggable((String)"Processor throws illegal error").getMessage(), throwable);
                }
                catch (Error runtimeException) {
                    throwable = runtimeException;
                    interceptionServiceException = this.pw.removeProcessor(processor, true);
                    Object var11_16 = null;
                    Association association4 = this;
                    // MONITORENTER : association4
                    if (!bl2) {
                        --this.inProgressMessagesCount;
                    } else if (n == 1) {
                        --this.inProgressMessagesCount;
                        if (bl) {
                            ++this.continueMessagesCount;
                        }
                    } else if (n == 2) {
                        --this.inProgressMessagesCount;
                        ++this.continueMessagesCount;
                    }
                    // MONITOREXIT : association4
                    if (throwable == null) return bl;
                    this.pw.removeProcessorWrapperIfNotUsed();
                    if (interceptionServiceException != null) {
                        throw interceptionServiceException;
                    }
                    if (!(throwable instanceof Error)) throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalExceptionLoggable((String)"Processor throws illegal runtime exception").getMessage(), throwable);
                    throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalErrorLoggable((String)"Processor throws illegal error").getMessage(), throwable);
                }
            }
            Object var11_14 = null;
            Association association = this;
            // MONITORENTER : association
            if (!bl2) {
                --this.inProgressMessagesCount;
            } else if (n == 1) {
                --this.inProgressMessagesCount;
                if (bl) {
                    ++this.continueMessagesCount;
                }
            } else if (n == 2) {
                --this.inProgressMessagesCount;
                ++this.continueMessagesCount;
            }
            // MONITOREXIT : association
            if (throwable == null) return bl;
            this.pw.removeProcessorWrapperIfNotUsed();
            if (interceptionServiceException != null) {
                throw interceptionServiceException;
            }
            if (!(throwable instanceof Error)) throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalExceptionLoggable((String)"Processor throws illegal runtime exception").getMessage(), throwable);
            throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalErrorLoggable((String)"Processor throws illegal error").getMessage(), throwable);
        }
        catch (Throwable throwable2) {
            Object var11_17 = null;
            Association association5 = this;
            // MONITORENTER : association5
            if (!bl2) {
                --this.inProgressMessagesCount;
            } else if (n == 1) {
                --this.inProgressMessagesCount;
                if (bl) {
                    ++this.continueMessagesCount;
                }
            } else if (n == 2) {
                --this.inProgressMessagesCount;
                ++this.continueMessagesCount;
            }
            // MONITOREXIT : association5
            if (throwable == null) throw throwable2;
            this.pw.removeProcessorWrapperIfNotUsed();
            if (interceptionServiceException != null) {
                throw interceptionServiceException;
            }
            if (!(throwable instanceof Error)) throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalExceptionLoggable((String)"Processor throws illegal runtime exception").getMessage(), throwable);
            throw new InterceptionServiceException(MIExceptionLogger.logProcessIllegalErrorLoggable((String)"Processor throws illegal error").getMessage(), throwable);
        }
    }

    boolean process(MessageContext messageContext) throws InterceptionServiceException, InterceptionException, MessageContextException {
        return this.processInternal(messageContext, null, 1);
    }

    void process(MessageContext messageContext, CarrierCallBack carrierCallBack) throws InterceptionServiceException, InterceptionException, MessageContextException {
        this.processInternal(messageContext, carrierCallBack, 3);
    }

    void processOnly(MessageContext messageContext) throws InterceptionServiceException, InterceptionException, MessageContextException {
        this.processInternal(messageContext, null, 2);
    }

    void processOnly(MessageContext messageContext, CarrierCallBack carrierCallBack) throws InterceptionServiceException, InterceptionException, MessageContextException {
        this.processInternal(messageContext, carrierCallBack, 4);
    }

    private void checkRemove() throws InterceptionServiceException {
        if (this.removed) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveAssociationAlreadyRemoveErrorLoggable((String)"Association has been removed").getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInterceptionPointType() throws InterceptionServiceException {
        InterceptionPoint interceptionPoint = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            interceptionPoint = this.ip;
        }
        return interceptionPoint.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getInterceptionPointName() throws InterceptionServiceException {
        InterceptionPoint interceptionPoint = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            interceptionPoint = this.ip;
        }
        return interceptionPoint.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProcessorType() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            processorWrapper = this.pw;
        }
        return processorWrapper.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProcessorName() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            processorWrapper = this.pw;
        }
        return processorWrapper.getName();
    }

    public AssociationInfo getInfoInternal() {
        return this.info;
    }

    public synchronized AssociationInfo getAssociationInfo() throws InterceptionServiceException {
        this.checkRemove();
        return this.info;
    }

    synchronized ProcessorWrapper getProcessorWrapper() {
        return this.pw;
    }

    synchronized long getTotalMessagesCount() throws InterceptionServiceException {
        this.checkRemove();
        return this.totalMessagesCount;
    }

    synchronized long getContinueMessagesCount() throws InterceptionServiceException {
        this.checkRemove();
        return this.continueMessagesCount;
    }

    synchronized long getInProgressMessagesCount() throws InterceptionServiceException {
        this.checkRemove();
        return this.inProgressMessagesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getProcessorRegistrationTime() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            processorWrapper = this.pw;
        }
        return processorWrapper.getRegistrationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasProcessor() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            processorWrapper = this.pw;
        }
        return processorWrapper.getProcessor() != null;
    }

    public synchronized void activate() throws InterceptionServiceException {
        this.checkRemove();
        this.activated = true;
    }

    public synchronized void deActivate() throws InterceptionServiceException {
        this.checkRemove();
        this.activated = false;
    }

    synchronized boolean isActivated() throws InterceptionServiceException {
        this.checkRemove();
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isProcessorShutdown() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper = null;
        Association association = this;
        synchronized (association) {
            this.checkRemove();
            processorWrapper = this.pw;
        }
        return processorWrapper.forcedShutdown();
    }

    synchronized void updateAsyncMeessagesCount(boolean bl) {
        if (bl) {
            ++this.continueMessagesCount;
        }
        --this.inProgressMessagesCount;
    }

    private void adjust(MessageContext messageContext) {
        JMSMessageContext jMSMessageContext;
        Message message;
        if (messageContext instanceof JMSMessageContext && (message = (jMSMessageContext = (JMSMessageContext)messageContext).getMessage()) instanceof TextMessage) {
            ((MessageImpl)message).setBodyWritable();
            ((MessageImpl)message).setPropertiesWritable(true);
        }
    }
}

