/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.util.HashMap;
import java.util.Iterator;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.internal.Association;
import weblogic.messaging.interception.internal.InterceptionPoint;
import weblogic.messaging.interception.internal.ProcessorWrapper;

class AssociationManager {
    private static HashMap associationMap = new HashMap(0);

    AssociationManager() {
    }

    static synchronized Association createAssociation(InterceptionPoint interceptionPoint, ProcessorWrapper processorWrapper, boolean bl, int n) throws InterceptionServiceException {
        Association association = (Association)associationMap.get(interceptionPoint.getInternalName());
        if (association != null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationAlreadyExistErrorLoggable((String)"Association exists").getMessage());
        }
        association = new Association(interceptionPoint, processorWrapper, bl, n);
        interceptionPoint.addAssociation(association);
        processorWrapper.addAssociation(association);
        associationMap.put(association.getInternalName(), association);
        return association;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAssociation(Association association) throws InterceptionServiceException {
        String string = association.getInternalName();
        ProcessorWrapper processorWrapper = association.getProcessorWrapper();
        association.remove();
        processorWrapper.removeProcessorWrapperIfNotUsed();
        Class<AssociationManager> clazz = AssociationManager.class;
        synchronized (AssociationManager.class) {
            associationMap.remove(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterator getAssociations() {
        HashMap hashMap = null;
        Class<AssociationManager> clazz = AssociationManager.class;
        synchronized (AssociationManager.class) {
            hashMap = (HashMap)associationMap.clone();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hashMap.values().iterator();
        }
    }

    public static int getAssociationsSize(String string) {
        if (string == null) {
            return associationMap.keySet().size();
        }
        Iterator iterator = associationMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith(string.length() + " " + string)) continue;
            ++n;
        }
        return n;
    }
}

