/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import javax.xml.rpc.handler.MessageContext;
import weblogic.messaging.interception.exceptions.InterceptionException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.exceptions.MessageContextException;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.interception.internal.Association;
import weblogic.messaging.interception.internal.InterceptionPointHandleImpl;
import weblogic.messaging.interception.internal.InterceptionPointTypeWrapper;
import weblogic.messaging.interception.internal.InterceptionServiceImpl;

class InterceptionPoint {
    private String interceptionPointType = null;
    private String[] interceptionPointName = null;
    private String internalName = null;
    private Association association = null;
    private InterceptionPointTypeWrapper iptw = null;
    private int handleCount = 0;

    InterceptionPoint(String string, String[] stringArray, String string2, InterceptionPointTypeWrapper interceptionPointTypeWrapper) {
        this.interceptionPointType = string;
        this.interceptionPointName = stringArray;
        this.internalName = string2;
        this.iptw = interceptionPointTypeWrapper;
    }

    synchronized void register() {
        ++this.handleCount;
    }

    synchronized void unregister() {
        --this.handleCount;
        if (this.handleCount == 0 & this.association == null) {
            this.iptw.removeIP(this.internalName);
        }
    }

    synchronized int getRegistrationCount() {
        return this.handleCount;
    }

    InterceptionPointHandle createHandle() {
        this.register();
        return new InterceptionPointHandleImpl(this);
    }

    void removeHandle() {
        this.unregister();
    }

    String[] getNameInternal() {
        return this.getName();
    }

    String[] getName() {
        return InterceptionServiceImpl.copyIPName(this.interceptionPointName);
    }

    String getType() {
        return this.interceptionPointType;
    }

    String getInternalName() {
        return this.internalName;
    }

    synchronized void addAssociation(Association association) {
        this.association = association;
    }

    synchronized void removeAssociation() {
        this.association = null;
        if (this.handleCount == 0) {
            this.iptw.removeIP(this.internalName);
        }
    }

    synchronized Association getAssociation() {
        return this.association;
    }

    boolean process(MessageContext messageContext) throws InterceptionServiceException, MessageContextException, InterceptionException {
        return false;
    }

    void processOnly(MessageContext messageContext) throws InterceptionServiceException, MessageContextException, InterceptionException {
    }

    static String createInternalName(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string.length());
        stringBuffer.append(" " + string);
        stringBuffer.append(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" " + stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

