/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import javax.xml.rpc.handler.MessageContext;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.exceptions.MessageContextException;
import weblogic.messaging.interception.interfaces.AssociationInfo;
import weblogic.messaging.interception.interfaces.CarrierCallBack;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.interception.internal.Association;
import weblogic.messaging.interception.internal.InterceptionPoint;

public class InterceptionPointHandleImpl
implements InterceptionPointHandle {
    private InterceptionPoint interceptionPoint = null;
    private boolean unregistered = false;

    InterceptionPointHandleImpl(InterceptionPoint interceptionPoint) {
        this.interceptionPoint = interceptionPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getName() throws InterceptionServiceException {
        InterceptionPoint interceptionPoint = null;
        InterceptionPointHandleImpl interceptionPointHandleImpl = this;
        synchronized (interceptionPointHandleImpl) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        return interceptionPoint.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() throws InterceptionServiceException {
        InterceptionPoint interceptionPoint = null;
        InterceptionPointHandleImpl interceptionPointHandleImpl = this;
        synchronized (interceptionPointHandleImpl) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        return interceptionPoint.getType();
    }

    synchronized void unregister() throws InterceptionServiceException {
        this.checkUnregistered();
        this.unregistered = true;
        this.interceptionPoint.unregister();
        this.interceptionPoint = null;
    }

    public synchronized boolean hasAssociation() throws InterceptionServiceException {
        this.checkUnregistered();
        return this.interceptionPoint.getAssociation() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationInfo getAssociationInfo() throws InterceptionServiceException {
        InterceptionPoint interceptionPoint = null;
        Object object = this;
        synchronized (object) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        object = interceptionPoint.getAssociation();
        if (object == null) {
            return null;
        }
        return interceptionPoint.getAssociation().getInfoInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(MessageContext messageContext) throws InterceptionServiceException, MessageContextException, InterceptionException {
        InterceptionPoint interceptionPoint = null;
        Object object = this;
        synchronized (object) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        object = interceptionPoint.getAssociation();
        if (object == null) {
            return true;
        }
        return ((Association)object).process(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAsync(MessageContext messageContext, CarrierCallBack carrierCallBack) throws InterceptionServiceException, MessageContextException, InterceptionException {
        InterceptionPoint interceptionPoint = null;
        Object object = this;
        synchronized (object) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        object = interceptionPoint.getAssociation();
        if (object == null) {
            carrierCallBack.onCallBack(true);
            return;
        }
        ((Association)object).process(messageContext, carrierCallBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOnly(MessageContext messageContext) throws InterceptionServiceException, MessageContextException, InterceptionException {
        InterceptionPoint interceptionPoint = null;
        Object object = this;
        synchronized (object) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        object = interceptionPoint.getAssociation();
        if (object == null) {
            return;
        }
        ((Association)object).processOnly(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOnlyAsync(MessageContext messageContext, CarrierCallBack carrierCallBack) throws InterceptionServiceException, MessageContextException, InterceptionException {
        InterceptionPoint interceptionPoint = null;
        Object object = this;
        synchronized (object) {
            this.checkUnregistered();
            interceptionPoint = this.interceptionPoint;
        }
        object = interceptionPoint.getAssociation();
        if (object == null) {
            carrierCallBack.onCallBack(true);
            return;
        }
        ((Association)object).processOnly(messageContext, carrierCallBack);
    }

    private void checkUnregistered() throws InterceptionServiceException {
        if (this.unregistered) {
            throw new InterceptionServiceException(MIExceptionLogger.logUnregisterInterceptionPointAlreayRemoveErrorLoggable((String)"InterceptionPoint has been unregistered").getMessage());
        }
    }
}

