/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.util.HashMap;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.AssociationListener;
import weblogic.messaging.interception.interfaces.InterceptionPointNameDescriptor;
import weblogic.messaging.interception.internal.InterceptionPoint;

class InterceptionPointTypeWrapper {
    private HashMap interceptionPointMap = new HashMap(0);
    private String name = null;
    private InterceptionPointNameDescriptor[] ipnd = null;
    private AssociationListener listener = null;

    InterceptionPointTypeWrapper(String string, InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray, AssociationListener associationListener) {
        this.name = string;
        this.ipnd = interceptionPointNameDescriptorArray;
        this.listener = associationListener;
    }

    String getName() {
        return this.name;
    }

    InterceptionPointNameDescriptor[] getIPND() {
        return this.ipnd;
    }

    AssociationListener getAssociationListener() {
        return this.listener;
    }

    void validate(String[] stringArray) throws InterceptionServiceException {
        if (this.ipnd.length != stringArray.length) {
            throw new InterceptionServiceException(MIExceptionLogger.logInvalidInterceptionPointNameLoggable((String)"Invalid InterceptionPointName - different length").getMessage());
        }
        for (int i = 0; i < this.ipnd.length; ++i) {
            if (this.ipnd[i].isValid(stringArray[i])) continue;
            throw new InterceptionServiceException(MIExceptionLogger.logInvalidInterceptionPointNameLoggable((String)"Invalid InterceptionPointName - invalid name").getMessage());
        }
    }

    synchronized InterceptionPoint findOrCreateInterceptionPoint(String[] stringArray) {
        String string = InterceptionPoint.createInternalName(this.name, stringArray);
        InterceptionPoint interceptionPoint = (InterceptionPoint)this.interceptionPointMap.get(string);
        if (interceptionPoint == null) {
            interceptionPoint = new InterceptionPoint(this.name, stringArray, string, this);
            this.interceptionPointMap.put(string, interceptionPoint);
        }
        return interceptionPoint;
    }

    synchronized InterceptionPoint findInterceptionPoint(String[] stringArray) {
        String string = InterceptionPoint.createInternalName(this.name, stringArray);
        return (InterceptionPoint)this.interceptionPointMap.get(string);
    }

    synchronized void removeIP(String string) {
        this.interceptionPointMap.remove(string);
    }

    synchronized int getIPsSize() {
        return this.interceptionPointMap.keySet().size();
    }
}

