/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.AssociationHandle;
import weblogic.messaging.interception.interfaces.AssociationListener;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.interception.interfaces.InterceptionPointNameDescriptionListener;
import weblogic.messaging.interception.interfaces.InterceptionPointNameDescriptor;
import weblogic.messaging.interception.interfaces.InterceptionService;
import weblogic.messaging.interception.interfaces.Processor;
import weblogic.messaging.interception.interfaces.ProcessorHandle;
import weblogic.messaging.interception.internal.Association;
import weblogic.messaging.interception.internal.AssociationManager;
import weblogic.messaging.interception.internal.InterceptionPoint;
import weblogic.messaging.interception.internal.InterceptionPointHandleImpl;
import weblogic.messaging.interception.internal.InterceptionPointTypeWrapper;
import weblogic.messaging.interception.internal.ProcessorHandleImpl;
import weblogic.messaging.interception.internal.ProcessorTypeWrapper;
import weblogic.messaging.interception.internal.ProcessorWrapper;

public class InterceptionServiceImpl
implements InterceptionService {
    private HashMap interceptionPointTypeMap = new HashMap(0);
    private HashMap interceptionPointTypeListenersMap = new HashMap(0);
    private HashMap processorTypeMap = new HashMap(0);
    private static InterceptionServiceImpl singleton = null;

    private InterceptionServiceImpl() {
    }

    public static synchronized InterceptionService getInterceptionService() {
        if (singleton == null) {
            singleton = new InterceptionServiceImpl();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationHandle addAssociation(String string, String[] stringArray, String string2, String string3, boolean bl, int n) throws InterceptionServiceException {
        ProcessorTypeWrapper processorTypeWrapper;
        InterceptionPointTypeWrapper interceptionPointTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationInputErrorLoggable((String)"InterceptionPointType cannot be null").getMessage());
        }
        if (stringArray == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationInputErrorLoggable((String)"InterceptionPointName cannot be null").getMessage());
        }
        if (string2 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        if (string3 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationInputErrorLoggable((String)"ProcessorName cannot be null").getMessage());
        }
        String[] stringArray2 = InterceptionServiceImpl.copyIPName(stringArray);
        Object object = this;
        synchronized (object) {
            interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(string);
            processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string2);
            if (interceptionPointTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logAddAssociationUnknownInterceptionPointTypeErrorLoggable((String)"Unknown InterceptionPointType").getMessage());
            }
            if (processorTypeWrapper == null) {
                processorTypeWrapper = new ProcessorTypeWrapper(string2);
                this.processorTypeMap.put(string2, processorTypeWrapper);
            }
        }
        interceptionPointTypeWrapper.validate(stringArray2);
        object = interceptionPointTypeWrapper.findOrCreateInterceptionPoint(stringArray2);
        ProcessorWrapper processorWrapper = processorTypeWrapper.findOrCreateProcessorWrapper(string3);
        AssociationListener associationListener = interceptionPointTypeWrapper.getAssociationListener();
        if (associationListener != null) {
            associationListener.onAddAssociation(string, InterceptionServiceImpl.copyIPName(stringArray), string2, string3, bl, n);
        }
        return AssociationManager.createAssociation((InterceptionPoint)object, processorWrapper, bl, n);
    }

    public AssociationHandle addAssociation(String string, String[] stringArray, String string2, String string3, boolean bl) throws InterceptionServiceException {
        return this.addAssociation(string, stringArray, string2, string3, bl, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociation(AssociationHandle associationHandle) throws InterceptionServiceException {
        AssociationListener associationListener = null;
        if (associationHandle == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveAssociationInputErrorLoggable((String)"AssociationHandle cannot be null").getMessage());
        }
        Association association = (Association)associationHandle;
        AssociationManager.removeAssociation(association);
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            InterceptionPointTypeWrapper interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(association.getIPType());
            associationListener = interceptionPointTypeWrapper.getAssociationListener();
        }
        if (associationListener == null) {
            return;
        }
        associationListener.onRemoveAssociation(association.getIPType(), association.getIPName(), association.getPType(), association.getPName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterceptionPointNameDescription(String string, InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray, AssociationListener associationListener) throws InterceptionServiceException {
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointNameDescriptionInputErrorLoggable((String)"InterceptionPointType cannot be null").getMessage());
        }
        if (interceptionPointNameDescriptorArray == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointNameDescriptionInputErrorLoggable((String)"Descriptor cannot be null").getMessage());
        }
        Iterator iterator = null;
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            InterceptionPointTypeWrapper interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(string);
            if (interceptionPointTypeWrapper != null) {
                throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointNameDescriptionInputErrorLoggable((String)"InterceptionPointType has been registered").getMessage());
            }
            InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray2 = InterceptionServiceImpl.copyIPND(interceptionPointNameDescriptorArray);
            interceptionPointTypeWrapper = new InterceptionPointTypeWrapper(string, interceptionPointNameDescriptorArray2, associationListener);
            this.interceptionPointTypeMap.put(string, interceptionPointTypeWrapper);
            iterator = this.removeListeners(string);
        }
        this.notifyListeners(iterator);
    }

    public synchronized InterceptionPointNameDescriptor[] getInterceptionPointNameDescription(String string) {
        if (string == null) {
            return null;
        }
        InterceptionPointTypeWrapper interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(string);
        if (interceptionPointTypeWrapper == null) {
            return null;
        }
        return InterceptionServiceImpl.copyIPND(interceptionPointTypeWrapper.getIPND());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptionPointHandle registerInterceptionPoint(String string, String[] stringArray) throws InterceptionServiceException {
        InterceptionPointTypeWrapper interceptionPointTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointInputErrorLoggable((String)"InterceptionPointType cannot be null").getMessage());
        }
        if (stringArray == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointInputErrorLoggable((String)"InterceptionPointName cannot be null").getMessage());
        }
        String[] stringArray2 = InterceptionServiceImpl.copyIPName(stringArray);
        Object object = this;
        synchronized (object) {
            interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(string);
            if (interceptionPointTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointUnknownInterceptionPointTypeErrorLoggable((String)"Unknown InterceptionPointType").getMessage());
            }
        }
        interceptionPointTypeWrapper.validate(stringArray2);
        object = interceptionPointTypeWrapper.findOrCreateInterceptionPoint(stringArray2);
        return ((InterceptionPoint)object).createHandle();
    }

    public void unRegisterInterceptionPoint(InterceptionPointHandle interceptionPointHandle) throws InterceptionServiceException {
        if (interceptionPointHandle == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logUnRegisterInterceptionPointInputErrorLoggable((String)"InterceptionPointHandle cannot be null").getMessage());
        }
        ((InterceptionPointHandleImpl)interceptionPointHandle).unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProcessorType(String string, String string2) throws InterceptionServiceException {
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterProcessorTypeInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        if (string2 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterProcessorTypeInputErrorLoggable((String)"ProcessorFactory cannot be null").getMessage());
        }
        HashMap hashMap = this.processorTypeMap;
        synchronized (hashMap) {
            ProcessorTypeWrapper processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string);
            if (processorTypeWrapper != null && processorTypeWrapper.getFactory() != null) {
                throw new InterceptionServiceException(MIExceptionLogger.logRegisterProcessorTypeInputErrorLoggable((String)"ProcessorType has been registered").getMessage());
            }
            if (processorTypeWrapper == null) {
                processorTypeWrapper = new ProcessorTypeWrapper(string, string2);
                this.processorTypeMap.put(string, processorTypeWrapper);
            } else {
                processorTypeWrapper.setFactoryName(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorHandle addProcessor(String string, String string2, String string3) throws InterceptionServiceException {
        ProcessorTypeWrapper processorTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        if (string2 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorInputErrorLoggable((String)"ProcessorName cannot be null").getMessage());
        }
        Object object = this;
        synchronized (object) {
            processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string);
            if (processorTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorUnknownProcessorTypeErrorLoggable((String)"Unknown ProcessorType").getMessage());
            }
        }
        object = processorTypeWrapper.findOrCreateProcessorWrapper(string2);
        InterceptionServiceException interceptionServiceException = null;
        Object object2 = object;
        synchronized (object2) {
            if (((ProcessorWrapper)object).getProcessor() != null) {
                throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorInputErrorLoggable((String)"Processor exists").getMessage());
            }
            Processor processor = null;
            try {
                processor = processorTypeWrapper.getFactory().create(string2, string3);
            }
            catch (RuntimeException runtimeException) {
                throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorInputErrorLoggable((String)"Failed to create processor").getMessage(), runtimeException);
            }
            catch (Error error) {
                throw new InterceptionServiceException(MIExceptionLogger.logAddProcessorInputErrorLoggable((String)"Failed to create processor").getMessage(), error);
            }
            interceptionServiceException = ((ProcessorWrapper)object).addProcessor(processor);
        }
        if (interceptionServiceException != null) {
            throw interceptionServiceException;
        }
        return new ProcessorHandleImpl((ProcessorWrapper)object);
    }

    public void removeProcessor(ProcessorHandle processorHandle) throws InterceptionServiceException {
        if (processorHandle == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"ProcessorHandle cannot be null").getMessage());
        }
        ProcessorWrapper processorWrapper = ((ProcessorHandleImpl)processorHandle).getProcessorWrapper();
        if (processorWrapper == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"Processor has been removed").getMessage());
        }
        InterceptionServiceException interceptionServiceException = processorWrapper.removeProcessor(processorHandle);
        processorWrapper.removeProcessorWrapperIfNotUsed();
        if (interceptionServiceException != null) {
            throw interceptionServiceException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessor(String string, String string2) throws InterceptionServiceException {
        ProcessorTypeWrapper processorTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        if (string2 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"ProcessorName cannot be null").getMessage());
        }
        Object object = this;
        synchronized (object) {
            processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string);
            if (processorTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"Unknown ProcessorType").getMessage());
            }
        }
        object = processorTypeWrapper.findProcessorWrapper(string2);
        if (object == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorInputErrorLoggable((String)"Processor not found").getMessage());
        }
        InterceptionServiceException interceptionServiceException = ((ProcessorWrapper)object).removeProcessor(null);
        ((ProcessorWrapper)object).removeProcessorWrapperIfNotUsed();
        if (interceptionServiceException != null) {
            throw interceptionServiceException;
        }
    }

    public Iterator getAssociationHandles() {
        return AssociationManager.getAssociations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationHandle getAssociationHandle(String string, String[] stringArray) throws InterceptionServiceException {
        InterceptionPointTypeWrapper interceptionPointTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logGetAssociationHandleInputErrorLoggable((String)"InterceptionPointType cannot be null").getMessage());
        }
        if (stringArray == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logGetAssociationHandleInputErrorLoggable((String)"InterceptionPointName cannot be null").getMessage());
        }
        String[] stringArray2 = InterceptionServiceImpl.copyIPName(stringArray);
        Object object = this;
        synchronized (object) {
            interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)this.interceptionPointTypeMap.get(string);
            if (interceptionPointTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logGetAssociationHandleInputErrorLoggable((String)"Unknown InterceptionPointType").getMessage());
            }
        }
        interceptionPointTypeWrapper.validate(stringArray2);
        object = interceptionPointTypeWrapper.findInterceptionPoint(stringArray2);
        if (object == null) {
            return null;
        }
        return ((InterceptionPoint)object).getAssociation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getProcessorHandles(String string) throws InterceptionServiceException {
        ProcessorTypeWrapper processorTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logGetProcessorHandlesInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string);
            if (processorTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logGetProcessorHandlesInputErrorLoggable((String)"Unknown ProcessorType").getMessage());
            }
        }
        return processorTypeWrapper.getProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorHandle getProcessorHandle(String string, String string2) throws InterceptionServiceException {
        ProcessorTypeWrapper processorTypeWrapper;
        if (string == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logGetProcessorHandleInputErrorLoggable((String)"ProcessorType cannot be null").getMessage());
        }
        if (string2 == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logGetProcessorHandleInputErrorLoggable((String)"ProcessorName cannot be null").getMessage());
        }
        Object object = this;
        synchronized (object) {
            processorTypeWrapper = (ProcessorTypeWrapper)this.processorTypeMap.get(string);
            if (processorTypeWrapper == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logGetProcessorHandleInputErrorLoggable((String)"Unknown ProcessorType").getMessage());
            }
        }
        object = processorTypeWrapper.findProcessorWrapper(string2);
        if (object == null) {
            return null;
        }
        return ((ProcessorWrapper)object).getProcessorHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterceptionPointNameDescriptionListener(InterceptionPointNameDescriptionListener interceptionPointNameDescriptionListener) throws InterceptionServiceException {
        if (interceptionPointNameDescriptionListener == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointNameDescriptionListenerInputErrorLoggable((String)"Listener cannot be null").getMessage());
        }
        if (interceptionPointNameDescriptionListener.getType() == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRegisterInterceptionPointNameDescriptionListenerInputErrorLoggable((String)"Listener.getType() cannot be null").getMessage());
        }
        Object var2_2 = null;
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            var2_2 = this.interceptionPointTypeMap.get(interceptionPointNameDescriptionListener.getType());
        }
        if (var2_2 != null) {
            this.notifyListener(interceptionPointNameDescriptionListener);
        } else {
            this.addListener(interceptionPointNameDescriptionListener);
        }
    }

    public static String[] copyIPName(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static InterceptionPointNameDescriptor[] copyIPND(InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray) {
        InterceptionPointNameDescriptor[] interceptionPointNameDescriptorArray2 = new InterceptionPointNameDescriptor[interceptionPointNameDescriptorArray.length];
        for (int i = 0; i < interceptionPointNameDescriptorArray.length; ++i) {
            interceptionPointNameDescriptorArray2[i] = interceptionPointNameDescriptorArray[i];
        }
        return interceptionPointNameDescriptorArray2;
    }

    public int getIPTMapSize(String string) {
        if (string == null) {
            return this.interceptionPointTypeMap.keySet().size();
        }
        Iterator iterator = this.interceptionPointTypeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            ++n;
        }
        return n;
    }

    public int getPTMapSize() {
        return this.processorTypeMap.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPsSize(String string) {
        if (this.getIPTMapSize(null) == 0) {
            return 0;
        }
        Iterator iterator = null;
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            iterator = ((HashMap)this.interceptionPointTypeMap.clone()).values().iterator();
        }
        int n = 0;
        while (iterator.hasNext()) {
            InterceptionPointTypeWrapper interceptionPointTypeWrapper = (InterceptionPointTypeWrapper)iterator.next();
            if (string != null && string.equals(interceptionPointTypeWrapper.getName())) continue;
            n += interceptionPointTypeWrapper.getIPsSize();
        }
        return n;
    }

    public int getAssociationsSize(String string) {
        return AssociationManager.getAssociationsSize(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProcessorsSize() {
        if (this.getPTMapSize() == 0) {
            return 0;
        }
        Iterator iterator = null;
        InterceptionServiceImpl interceptionServiceImpl = this;
        synchronized (interceptionServiceImpl) {
            iterator = ((HashMap)this.processorTypeMap.clone()).values().iterator();
        }
        int n = 0;
        while (iterator.hasNext()) {
            ProcessorTypeWrapper processorTypeWrapper = (ProcessorTypeWrapper)iterator.next();
            n += processorTypeWrapper.getProcessorsSize();
        }
        return n;
    }

    private void notifyListener(InterceptionPointNameDescriptionListener interceptionPointNameDescriptionListener) {
        interceptionPointNameDescriptionListener.onRegister();
    }

    private void notifyListeners(Iterator iterator) {
        InterceptionPointNameDescriptionListener interceptionPointNameDescriptionListener = null;
        while (iterator.hasNext()) {
            interceptionPointNameDescriptionListener = (InterceptionPointNameDescriptionListener)iterator.next();
            this.notifyListener(interceptionPointNameDescriptionListener);
        }
    }

    private synchronized void addListener(InterceptionPointNameDescriptionListener interceptionPointNameDescriptionListener) {
        LinkedList<InterceptionPointNameDescriptionListener> linkedList = (LinkedList<InterceptionPointNameDescriptionListener>)this.interceptionPointTypeListenersMap.get(interceptionPointNameDescriptionListener.getType());
        if (linkedList == null) {
            linkedList = new LinkedList<InterceptionPointNameDescriptionListener>();
            this.interceptionPointTypeListenersMap.put(interceptionPointNameDescriptionListener.getType(), linkedList);
        }
        linkedList.add(interceptionPointNameDescriptionListener);
    }

    private synchronized Iterator removeListeners(String string) {
        List list = (List)this.interceptionPointTypeListenersMap.get(string);
        if (list == null) {
            return new LinkedList().listIterator();
        }
        this.interceptionPointTypeListenersMap.remove(string);
        return list.listIterator();
    }
}

