/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.util.Iterator;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.ProcessorHandle;
import weblogic.messaging.interception.internal.ProcessorWrapper;

public class ProcessorHandleImpl
implements ProcessorHandle {
    private ProcessorWrapper pw = null;

    ProcessorHandleImpl(ProcessorWrapper processorWrapper) {
        this.pw = processorWrapper;
        processorWrapper.setProcessorHandle(this);
    }

    synchronized ProcessorWrapper getProcessorWrapper() {
        return this.pw;
    }

    synchronized void removeProcessorWrapper() {
        this.pw = null;
    }

    void checkRemoved() throws InterceptionServiceException {
        if (this.pw == null) {
            throw new InterceptionServiceException(MIExceptionLogger.logRemoveProcessorAlreadyRemoveErrorLoggable((String)"Processor has been removed").getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAssociationInfos() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper;
        ProcessorHandleImpl processorHandleImpl = this;
        synchronized (processorHandleImpl) {
            this.checkRemoved();
            processorWrapper = this.pw;
        }
        return processorWrapper.getAssociationInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper;
        ProcessorHandleImpl processorHandleImpl = this;
        synchronized (processorHandleImpl) {
            this.checkRemoved();
            processorWrapper = this.pw;
        }
        return processorWrapper.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws InterceptionServiceException {
        ProcessorWrapper processorWrapper;
        ProcessorHandleImpl processorHandleImpl = this;
        synchronized (processorHandleImpl) {
            this.checkRemoved();
            processorWrapper = this.pw;
        }
        return processorWrapper.getName();
    }
}

