/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.messaging.interception.MIExceptionLogger;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.ProcessorFactory;
import weblogic.messaging.interception.interfaces.ProcessorHandle;
import weblogic.messaging.interception.internal.ProcessorWrapper;

class ProcessorTypeWrapper {
    private HashMap processorWrapperMap = new HashMap(0);
    private String name = null;
    private ProcessorFactory factory = null;

    ProcessorTypeWrapper(String string, String string2) throws InterceptionServiceException {
        this.name = string;
        this.factory = this.instantiateProcessorFactory(string2);
    }

    ProcessorTypeWrapper(String string) {
        this.name = string;
    }

    private ProcessorFactory instantiateProcessorFactory(String string) throws InterceptionServiceException {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length != 0) continue;
                constructor = constructorArray[i];
                break;
            }
            if (constructor == null) {
                throw new InterceptionServiceException(MIExceptionLogger.logProcessorFactoryCreateErrorLoggable((String)"ProcessorFactory requires no argument constructor").getMessage());
            }
            return (ProcessorFactory)constructor.newInstance(null);
        }
        catch (Exception exception) {
            if (exception instanceof InterceptionServiceException) {
                throw (InterceptionServiceException)exception;
            }
            throw new InterceptionServiceException(MIExceptionLogger.logProcessorFactoryCreateUnknownErrorLoggable((String)"Fail to construct ProcessorFactory").getMessage(), exception);
        }
    }

    String getName() {
        return this.name;
    }

    ProcessorFactory getFactory() {
        return this.factory;
    }

    void setFactoryName(String string) throws InterceptionServiceException {
        this.factory = this.instantiateProcessorFactory(string);
    }

    synchronized ProcessorWrapper findOrCreateProcessorWrapper(String string) {
        ProcessorWrapper processorWrapper = (ProcessorWrapper)this.processorWrapperMap.get(string);
        if (processorWrapper == null) {
            processorWrapper = new ProcessorWrapper(this.name, string, this);
            this.processorWrapperMap.put(string, processorWrapper);
        }
        return processorWrapper;
    }

    synchronized ProcessorWrapper findProcessorWrapper(String string) {
        return (ProcessorWrapper)this.processorWrapperMap.get(string);
    }

    void removeProcessorWrapper(String string) {
        this.processorWrapperMap.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getProcessors() {
        HashMap hashMap = null;
        HashMap<String, ProcessorHandle> hashMap2 = new HashMap<String, ProcessorHandle>(0);
        Object[] objectArray = this;
        synchronized (this) {
            hashMap = (HashMap)this.processorWrapperMap.clone();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray = hashMap.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ProcessorWrapper processorWrapper = (ProcessorWrapper)objectArray[i];
                ProcessorHandle processorHandle = processorWrapper.getProcessorHandle();
                if (processorHandle == null) continue;
                hashMap2.put(processorWrapper.getName(), processorHandle);
            }
            return hashMap2.values().iterator();
        }
    }

    public int getProcessorsSize() {
        return this.processorWrapperMap.keySet().size();
    }
}

